/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ReceiveDeptAndPersonApi;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.entity.ReceiveDepartment;
import net.risesoft.entity.ReceivePerson;
import net.risesoft.model.itemadmin.ReceiveOrgUnit;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ReceiveDepartmentRepository;
import net.risesoft.repository.jpa.ReceivePersonRepository;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/receiveDeptAndPerson"}, produces={"application/json"})
public class ReceiveDeptAndPersonApiImpl
implements ReceiveDeptAndPersonApi {
    private final DepartmentApi departmentApi;
    private final OrgUnitApi orgUnitApi;
    private final ReceivePersonRepository receivePersonRepository;
    private final ReceiveDepartmentRepository receiveDepartmentRepository;

    public Y9Result<List<ReceiveOrgUnit>> findByDeptNameLike(@RequestParam String tenantId, @RequestParam String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<ReceiveOrgUnit> listMap = new ArrayList<ReceiveOrgUnit>();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "";
        }
        name = "%" + (String)name + "%";
        List list = this.receiveDepartmentRepository.findByDeptNameLikeOrderByTabIndex((String)name);
        for (ReceiveDepartment receiveDepartment : list) {
            Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
            if (department == null || department.getId() == null) continue;
            ReceiveOrgUnit orgUnit = new ReceiveOrgUnit();
            orgUnit.setId(receiveDepartment.getDeptId());
            orgUnit.setDisabled(department.getDisabled());
            orgUnit.setParentId(receiveDepartment.getParentId());
            orgUnit.setName(department.getName());
            OrgUnit bureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, department.getId()).getData();
            if (bureau != null && bureau.getId() != null && !bureau.getId().equals(department.getId())) {
                orgUnit.setNameWithBureau(department.getName() + "(" + bureau.getName() + ")");
            }
            orgUnit.setOrgType("Department");
            listMap.add(orgUnit);
        }
        return Y9Result.success(listMap);
    }

    public Y9Result<List<ReceiveOrgUnit>> getReceiveDeptTree(@RequestParam String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<ReceiveOrgUnit> listMap = new ArrayList<ReceiveOrgUnit>();
        List list = this.receiveDepartmentRepository.findAll();
        for (ReceiveDepartment receiveDepartment : list) {
            Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
            if (department == null || department.getId() == null) continue;
            ReceiveOrgUnit orgUnit = new ReceiveOrgUnit();
            orgUnit.setId(receiveDepartment.getDeptId());
            orgUnit.setDisabled(department.getDisabled());
            orgUnit.setParentId(receiveDepartment.getParentId());
            orgUnit.setName(department.getName());
            OrgUnit bureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, department.getId()).getData();
            if (bureau != null && bureau.getId() != null && !bureau.getId().equals(department.getId())) {
                orgUnit.setNameWithBureau(department.getName() + "(" + bureau.getName() + ")");
            }
            orgUnit.setOrgType("Department");
            listMap.add(orgUnit);
        }
        return Y9Result.success(listMap);
    }

    public Y9Result<List<ReceiveOrgUnit>> getReceiveDeptTreeById(@RequestParam String tenantId, @RequestParam String orgUnitId, String name) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<ReceiveOrgUnit> listMap = new ArrayList<ReceiveOrgUnit>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            List list = this.receiveDepartmentRepository.findByDeptNameContainingOrderByTabIndex(name);
            for (ReceiveDepartment receiveDepartment : list) {
                Integer count;
                Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
                if (department == null || department.getId() == null) continue;
                ReceiveOrgUnit orgUnit = new ReceiveOrgUnit();
                orgUnit.setId(receiveDepartment.getDeptId());
                orgUnit.setDisabled(department.getDisabled());
                orgUnit.setParentId(receiveDepartment.getParentId());
                orgUnit.setName(department.getName());
                OrgUnit bureau = (OrgUnit)this.orgUnitApi.getBureau(tenantId, department.getId()).getData();
                if (bureau != null && bureau.getId() != null && !bureau.getId().equals(department.getId())) {
                    orgUnit.setNameWithBureau(department.getName() + "(" + bureau.getName() + ")");
                }
                orgUnit.setIsParent(Boolean.valueOf((count = this.receiveDepartmentRepository.countByParentId(receiveDepartment.getDeptId())) > 0));
                orgUnit.setOrgType("Department");
                if (listMap.contains(orgUnit)) continue;
                listMap.add(orgUnit);
            }
        } else if (StringUtils.isBlank((CharSequence)orgUnitId)) {
            List list = this.receiveDepartmentRepository.findAll();
            for (ReceiveDepartment receiveDepartment : list) {
                Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
                if (department == null || department.getId() == null) continue;
                ReceiveOrgUnit orgUnit = new ReceiveOrgUnit();
                orgUnit.setId(receiveDepartment.getDeptId());
                orgUnit.setDisabled(department.getDisabled());
                orgUnit.setParentId(receiveDepartment.getParentId());
                orgUnit.setName(department.getName());
                Integer count = this.receiveDepartmentRepository.countByParentId(receiveDepartment.getDeptId());
                orgUnit.setIsParent(Boolean.valueOf(count > 0));
                orgUnit.setOrgType("Department");
                if (listMap.contains(orgUnit)) continue;
                listMap.add(orgUnit);
            }
        } else {
            List list = this.receiveDepartmentRepository.findByParentIdOrderByTabIndex(orgUnitId);
            for (ReceiveDepartment receiveDepartment : list) {
                Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
                if (department == null || department.getId() == null) continue;
                Integer count = this.receiveDepartmentRepository.countByParentId(receiveDepartment.getDeptId());
                ReceiveOrgUnit orgUnit = new ReceiveOrgUnit();
                orgUnit.setId(receiveDepartment.getDeptId());
                orgUnit.setDisabled(department.getDisabled());
                orgUnit.setParentId(orgUnitId);
                orgUnit.setName(department.getName());
                orgUnit.setIsParent(Boolean.valueOf(count > 0));
                orgUnit.setOrgType("Department");
                if (listMap.contains(orgUnit)) continue;
                listMap.add(orgUnit);
            }
        }
        return Y9Result.success(listMap);
    }

    public Y9Result<List<OrgUnit>> getSendReceiveByDeptId(@RequestParam String tenantId, @RequestParam String deptId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.receivePersonRepository.findByDeptId(deptId);
        ArrayList<OrgUnit> users = new ArrayList<OrgUnit>();
        for (ReceivePerson receivePerson : list) {
            OrgUnit person = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, receivePerson.getPersonId()).getData();
            if (person == null || !StringUtils.isNotBlank((CharSequence)person.getId()) || Boolean.TRUE.equals(person.getDisabled())) continue;
            users.add(person);
        }
        return Y9Result.success(users);
    }

    @GetMapping(value={"/getSendReceiveByUserId"})
    public Y9Result<List<ReceiveOrgUnit>> getSendReceiveByUserId(@RequestParam String tenantId, @RequestParam String orgUnitId) {
        List list;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<ReceiveOrgUnit> listMap = new ArrayList<ReceiveOrgUnit>();
        if (StringUtils.isBlank((CharSequence)orgUnitId)) {
            orgUnitId = "";
        }
        if (!(list = this.receivePersonRepository.findByPersonId((String)(orgUnitId = "%" + (String)orgUnitId + "%"))).isEmpty()) {
            for (ReceivePerson receivePerson : list) {
                Department department = (Department)this.departmentApi.get(tenantId, receivePerson.getDeptId()).getData();
                if (department == null || department.getId() == null) continue;
                ReceiveOrgUnit orgUnit = new ReceiveOrgUnit();
                orgUnit.setId(receivePerson.getDeptId());
                orgUnit.setName(department.getName());
                listMap.add(orgUnit);
            }
        }
        return Y9Result.success(listMap);
    }

    @Generated
    public ReceiveDeptAndPersonApiImpl(DepartmentApi departmentApi, OrgUnitApi orgUnitApi, ReceivePersonRepository receivePersonRepository, ReceiveDepartmentRepository receiveDepartmentRepository) {
        this.departmentApi = departmentApi;
        this.orgUnitApi = orgUnitApi;
        this.receivePersonRepository = receivePersonRepository;
        this.receiveDepartmentRepository = receiveDepartmentRepository;
    }
}

