/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.QueryListApi;
import net.risesoft.model.itemadmin.ActRuDetailModel;
import net.risesoft.model.itemadmin.ItemPage;
import net.risesoft.pojo.Y9Page;
import net.risesoft.service.ItemPageService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/queryList"}, produces={"application/json"})
public class QueryListApiImpl
implements QueryListApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryListApiImpl.class);
    private final ItemPageService itemPageService;

    public Y9Page<ActRuDetailModel> getQueryList(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, String state, String createDate, String tableName, @RequestBody String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        try {
            Object sql0 = "";
            StringBuilder sql1 = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)tableName) && StringUtils.isNotBlank((CharSequence)searchMapStr)) {
                boolean query = false;
                sql0 = " LEFT JOIN " + tableName.toUpperCase() + " F ON T.PROCESSSERIALNUMBER = F.GUID ";
                Object list = Y9JsonUtil.readListOfMap((String)searchMapStr, String.class, Object.class);
                assert (list != null);
                Iterator iterator = list.iterator();
                block23: while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    if (map.get("value") == null || map.get("value").toString().isEmpty()) continue;
                    query = true;
                    String queryType = map.get("queryType").toString();
                    String value = map.get("value").toString();
                    String columnName = map.get("columnName").toString();
                    switch (queryType) {
                        case "select": 
                        case "radio": {
                            sql1.append(" AND F.").append(columnName.toUpperCase()).append(" = '").append(value).append("' ");
                            continue block23;
                        }
                        case "checkbox": {
                            String[] values = value.split(",");
                            if (values.length == 1) {
                                sql1.append(" AND INSTR(F.").append(columnName.toUpperCase()).append(",'").append(values[0]).append("') > 0 ");
                                continue block23;
                            }
                            StringBuilder sql2 = new StringBuilder();
                            for (String val : values) {
                                if (sql2.toString().isEmpty()) {
                                    sql2.append(" AND ( INSTR(F.").append(columnName.toUpperCase()).append(",'").append(val).append("') > 0 ");
                                    continue;
                                }
                                sql2.append(" OR INSTR(F.").append(columnName.toUpperCase()).append(",'").append(val).append("') > 0 ");
                            }
                            sql2.append(" ) ");
                            sql1.append((CharSequence)sql2);
                            continue block23;
                        }
                        case "date": {
                            String[] values = value.split(",");
                            sql1.append(" AND F.").append(columnName.toUpperCase()).append(" >= '").append(values[0]).append("' ");
                            sql1.append(" AND F.").append(columnName.toUpperCase()).append(" < '").append(values[1]).append(" 23:59:59' ");
                            continue block23;
                        }
                    }
                    sql1.append(" AND INSTR(F.").append(columnName.toUpperCase()).append(",'").append(value).append("') > 0 ");
                }
                if (!query) {
                    sql0 = "";
                    sql1 = new StringBuilder();
                }
            }
            String stateSql = "";
            if (StringUtils.isNotBlank((CharSequence)state)) {
                switch (state) {
                    case "todo": {
                        stateSql = " and T.STATUS = 0 AND T.ENDED = FALSE ";
                        break;
                    }
                    case "doing": {
                        stateSql = " and T.STATUS = 1 AND T.ENDED = FALSE ";
                        break;
                    }
                    case "done": {
                        stateSql = " and T.ENDED = TRUE ";
                    }
                }
            }
            Object dateSql = "";
            if (StringUtils.isNotBlank((CharSequence)createDate)) {
                String startDate = createDate.split(",")[0];
                String endDate = createDate.split(",")[1];
                dateSql = " and T.STARTTIME > '" + startDate + "' and T.STARTTIME < '" + endDate + " 23:59:59' ";
            }
            String orderBy = " T.STARTTIME DESC";
            String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + (String)sql0 + " WHERE T.DELETED = FALSE " + stateSql + (String)dateSql + " AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ? " + sql1 + " ORDER BY " + orderBy;
            System.out.println(sql);
            String countSql = "SELECT COUNT(ID) FROM FF_ACT_RU_DETAIL T " + (String)sql0 + " WHERE T.SYSTEMNAME= ? " + stateSql + (String)dateSql + " AND T.ASSIGNEE= ? AND T.DELETED = FALSE " + sql1;
            Object[] args = new Object[]{systemName, userId};
            ItemPage pageList = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
            return Y9Page.success((int)page, (int)pageList.getTotalpages(), (long)pageList.getTotal(), (List)pageList.getRows());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Generated
    public QueryListApiImpl(ItemPageService itemPageService) {
        this.itemPageService = itemPageService;
    }
}

