/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.risesoft.api.itemadmin.ItemRoleApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.enums.ItemPrincipalTypeEnum;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.ItemRoleOrgUnitModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.RoleService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/itemRole"}, produces={"application/json"})
public class ItemRoleApiImpl
implements ItemRoleApi {
    private final RoleService roleService;
    private final PersonApi personApi;
    private final OrgUnitApi orgUnitApi;
    private final OrganizationApi organizationApi;

    public Y9Result<List<ItemRoleOrgUnitModel>> findCsUser(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, String id, @RequestParam Integer principalType, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listCsUser(id, principalType, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findCsUserBureau(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestParam Integer principalType) {
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        if (Objects.equals(principalType, ItemPrincipalTypeEnum.DEPT.getValue())) {
            OrgUnit orgunit = (OrgUnit)this.orgUnitApi.getBureau(tenantId, orgUnit.getParentId()).getData();
            ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
            model.setId(orgunit.getId());
            model.setName(orgunit.getName());
            model.setOrgType(orgunit.getOrgType().getValue());
            model.setIsParent(Boolean.valueOf(OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())));
            item.add(model);
        }
        return Y9Result.success(item);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findCsUserSearch(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, @RequestParam String name, @RequestParam Integer principalType, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listCsUserSearch(name, principalType, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findPermUser(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey, @RequestParam Integer principalType, String id, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listPermUser(itemId, processDefinitionId, taskDefKey, principalType, id, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findPermUserByName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String orgUnitId, String name, @RequestParam Integer principalType, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listPermUserByName(name, itemId, processDefinitionId, taskDefKey, principalType, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findPermUserSendReceive(@RequestParam String tenantId, @RequestParam String orgUnitId, String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        List<ItemRoleOrgUnitModel> list = this.roleService.listPermUserSendReceive(id);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> getOrgTree(@RequestParam String tenantId, @RequestParam String orgUnitId, String id, @RequestParam OrgTreeTypeEnum treeType, String name) {
        List org;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setOrgUnitId((String)orgUnitId);
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        if (StringUtils.isBlank((CharSequence)id) && (org = (List)this.organizationApi.list(tenantId).getData()) != null && !org.isEmpty()) {
            id = ((Organization)org.get(0)).getId();
        }
        List orgUnitList = StringUtils.isNotBlank((CharSequence)name) ? (List)this.orgUnitApi.treeSearch(tenantId, name, treeType).getData() : (List)this.orgUnitApi.getSubTree(tenantId, id, treeType).getData();
        for (OrgUnit orgUnit : orgUnitList) {
            ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
            model.setId(orgUnit.getId());
            model.setName(orgUnit.getName());
            model.setParentId(orgUnit.getParentId());
            model.setIsParent(Boolean.valueOf(false));
            model.setOrgType(orgUnit.getOrgType().getValue());
            if (OrgTypeEnum.DEPARTMENT.equals((Object)orgUnit.getOrgType())) {
                model.setIsParent(Boolean.valueOf(true));
            } else if (OrgTypeEnum.POSITION.equals((Object)orgUnit.getOrgType())) {
                model.setPerson("6:" + orgUnit.getId());
            }
            item.add(model);
        }
        return Y9Result.success(item);
    }

    @Generated
    public ItemRoleApiImpl(RoleService roleService, PersonApi personApi, OrgUnitApi orgUnitApi, OrganizationApi organizationApi) {
        this.roleService = roleService;
        this.personApi = personApi;
        this.orgUnitApi = orgUnitApi;
        this.organizationApi = organizationApi;
    }
}

