/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ItemLinkApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.entity.ItemLinkBind;
import net.risesoft.entity.ItemLinkRole;
import net.risesoft.entity.ItemNodeLinkBind;
import net.risesoft.entity.LinkInfo;
import net.risesoft.model.itemadmin.LinkInfoModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemLinkBindRepository;
import net.risesoft.repository.jpa.ItemLinkRoleRepository;
import net.risesoft.repository.jpa.ItemNodeLinkBindRepository;
import net.risesoft.repository.jpa.LinkInfoRepository;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/itemLink"}, produces={"application/json"})
public class ItemLinkApiImpl
implements ItemLinkApi {
    private final PositionRoleApi positionRoleApi;
    private final ItemLinkBindRepository itemLinkBindRepository;
    private final ItemNodeLinkBindRepository itemNodeLinkBindRepository;
    private final LinkInfoRepository linkInfoRepository;
    private final ItemLinkRoleRepository itemLinkRoleRepository;

    public Y9Result<List<LinkInfoModel>> getItemLinkList(String tenantId, String orgUnitId, String itemId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<LinkInfoModel> linkList = new ArrayList<LinkInfoModel>();
        List list = this.itemLinkBindRepository.findByItemIdOrderByCreateTimeDesc(itemId);
        block0: for (ItemLinkBind bind : list) {
            List roleList = this.itemLinkRoleRepository.findByItemLinkId(bind.getId());
            if (roleList.isEmpty()) continue;
            for (ItemLinkRole linkRole : roleList) {
                boolean b = (Boolean)this.positionRoleApi.hasRole(tenantId, linkRole.getRoleId(), orgUnitId).getData();
                if (!b) continue;
                LinkInfo linkInfo = this.linkInfoRepository.findById((Object)bind.getLinkId()).orElse(null);
                LinkInfoModel model = new LinkInfoModel();
                Y9BeanUtil.copyProperties((Object)linkInfo, (Object)model);
                linkList.add(model);
                continue block0;
            }
        }
        return Y9Result.success(linkList);
    }

    public Y9Result<LinkInfoModel> getItemNodeLinkList(String tenantId, String orgUnitId, String itemId, String processDefinitionId, String taskDefKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        LinkInfoModel model = null;
        ItemNodeLinkBind bind = this.itemNodeLinkBindRepository.findByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
        if (bind != null) {
            List roleList = this.itemLinkRoleRepository.findByItemLinkId(bind.getId());
            if (roleList.isEmpty()) {
                model = new LinkInfoModel();
                LinkInfo linkInfo = this.linkInfoRepository.findById((Object)bind.getLinkId()).orElse(null);
                Y9BeanUtil.copyProperties((Object)linkInfo, (Object)model);
                return Y9Result.success((Object)model);
            }
            for (ItemLinkRole linkRole : roleList) {
                boolean b = (Boolean)this.positionRoleApi.hasRole(tenantId, linkRole.getRoleId(), orgUnitId).getData();
                if (!b) continue;
                model = new LinkInfoModel();
                LinkInfo linkInfo = this.linkInfoRepository.findById((Object)bind.getLinkId()).orElse(null);
                Y9BeanUtil.copyProperties((Object)linkInfo, (Object)model);
                break;
            }
            return Y9Result.success((Object)model);
        }
        return Y9Result.success();
    }

    @Generated
    public ItemLinkApiImpl(PositionRoleApi positionRoleApi, ItemLinkBindRepository itemLinkBindRepository, ItemNodeLinkBindRepository itemNodeLinkBindRepository, LinkInfoRepository linkInfoRepository, ItemLinkRoleRepository itemLinkRoleRepository) {
        this.positionRoleApi = positionRoleApi;
        this.itemLinkBindRepository = itemLinkBindRepository;
        this.itemNodeLinkBindRepository = itemNodeLinkBindRepository;
        this.linkInfoRepository = linkInfoRepository;
        this.itemLinkRoleRepository = itemLinkRoleRepository;
    }
}

