/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ItemInterfaceApi;
import net.risesoft.entity.InterfaceInfo;
import net.risesoft.entity.InterfaceResponseParams;
import net.risesoft.entity.ItemInterfaceBind;
import net.risesoft.entity.ItemInterfaceParamsBind;
import net.risesoft.entity.ItemInterfaceTaskBind;
import net.risesoft.entity.TaskTimeConf;
import net.risesoft.enums.ItemInterfaceTypeEnum;
import net.risesoft.model.itemadmin.InterfaceModel;
import net.risesoft.model.itemadmin.InterfaceParamsModel;
import net.risesoft.model.itemadmin.TaskTimeConfModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.InterfaceInfoRepository;
import net.risesoft.repository.jpa.InterfaceResponseParamsRepository;
import net.risesoft.repository.jpa.ItemInterfaceBindRepository;
import net.risesoft.repository.jpa.ItemInterfaceParamsBindRepository;
import net.risesoft.repository.jpa.ItemInterfaceTaskBindRepository;
import net.risesoft.repository.jpa.TaskTimeConfRepository;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/itemInterface"}, produces={"application/json"})
public class ItemInterfaceApiImpl
implements ItemInterfaceApi {
    private final ItemInterfaceTaskBindRepository itemInterfaceTaskBindRepository;
    private final InterfaceInfoRepository interfaceInfoRepository;
    private final ItemInterfaceBindRepository itemInterfaceBindRepository;
    private final InterfaceResponseParamsRepository interfaceResponseParamsRepository;
    private final ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository;
    private final TaskTimeConfRepository taskTimeConfRepository;

    public Y9Result<List<InterfaceModel>> getInterface(@RequestParam String tenantId, @RequestParam String itemId, String taskKey, @RequestParam String processDefinitionId, @RequestParam String condition) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.itemInterfaceTaskBindRepository.findByItemIdAndTaskDefKeyAndProcessDefinitionIdAndExecuteConditionContaining(itemId, taskKey, processDefinitionId, condition);
        ArrayList<InterfaceModel> resList = new ArrayList<InterfaceModel>();
        for (ItemInterfaceTaskBind bind : list) {
            InterfaceModel model = new InterfaceModel();
            InterfaceInfo info = this.interfaceInfoRepository.findById((Object)bind.getInterfaceId()).orElse(null);
            if (info == null) continue;
            model.setId(info.getId());
            model.setInterfaceAddress(info.getInterfaceAddress());
            model.setInterfaceName(info.getInterfaceName());
            model.setRequestType(info.getRequestType());
            model.setAsyn(info.getAsyn());
            model.setAbnormalStop(info.getAbnormalStop());
            resList.add(model);
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<List<InterfaceModel>> getInterfaceList(@RequestParam String tenantId, @RequestParam String itemId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.itemInterfaceBindRepository.findByItemIdOrderByCreateTimeDesc(itemId);
        ArrayList<InterfaceModel> resList = new ArrayList<InterfaceModel>();
        for (ItemInterfaceBind bind : list) {
            InterfaceModel model = new InterfaceModel();
            InterfaceInfo info = this.interfaceInfoRepository.findById((Object)bind.getInterfaceId()).orElse(null);
            if (info == null) continue;
            model.setId(info.getId());
            model.setInterfaceAddress(info.getInterfaceAddress());
            model.setInterfaceName(info.getInterfaceName());
            model.setRequestType(info.getRequestType());
            model.setAsyn(info.getAsyn());
            model.setAbnormalStop(info.getAbnormalStop());
            List list0 = this.itemInterfaceParamsBindRepository.findByItemIdAndInterfaceIdOrderByCreateTimeDesc(itemId, info.getId());
            ArrayList<InterfaceParamsModel> list1 = new ArrayList<InterfaceParamsModel>();
            for (ItemInterfaceParamsBind bind0 : list0) {
                InterfaceParamsModel model0 = new InterfaceParamsModel();
                model0.setId(bind0.getId());
                model0.setBindType(bind0.getBindType());
                model0.setColumnName(bind0.getColumnName());
                model0.setParameterName(bind0.getParameterName());
                model0.setParameterType(bind0.getParameterType());
                model0.setTableName(bind0.getTableName());
                model0.setTableType(bind0.getTableType());
                list1.add(model0);
            }
            model.setParamsList(list1);
            resList.add(model);
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<List<InterfaceParamsModel>> getInterfaceParams(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String interfaceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.itemInterfaceParamsBindRepository.findByItemIdAndInterfaceIdOrderByCreateTimeDesc(itemId, interfaceId);
        ArrayList<InterfaceParamsModel> resList = new ArrayList<InterfaceParamsModel>();
        for (ItemInterfaceParamsBind bind : list) {
            List plist;
            InterfaceParamsModel model = new InterfaceParamsModel();
            model.setId(bind.getId());
            model.setBindType(bind.getBindType());
            model.setColumnName(bind.getColumnName());
            model.setParameterName(bind.getParameterName());
            model.setParameterType(bind.getParameterType());
            model.setTableName(bind.getTableName());
            model.setTableType(bind.getTableType());
            model.setFileType("");
            if (ItemInterfaceTypeEnum.INTERFACE_RESPONSE.getValue().equals(bind.getBindType()) && (plist = this.interfaceResponseParamsRepository.findByParameterName(bind.getParameterName())) != null && plist.size() > 0) {
                model.setFileType(((InterfaceResponseParams)plist.get(0)).getFileType());
            }
            resList.add(model);
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<TaskTimeConfModel> getTaskTimeConf(@RequestParam String tenantId, @RequestParam String processDefinitionId, @RequestParam String itemId, String taskKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        TaskTimeConf conf = this.taskTimeConfRepository.findByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskKey);
        TaskTimeConfModel taskTimeConf = null;
        if (conf != null) {
            taskTimeConf = new TaskTimeConfModel();
            Y9BeanUtil.copyProperties((Object)conf, (Object)taskTimeConf);
        }
        return Y9Result.success(taskTimeConf, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @Generated
    public ItemInterfaceApiImpl(ItemInterfaceTaskBindRepository itemInterfaceTaskBindRepository, InterfaceInfoRepository interfaceInfoRepository, ItemInterfaceBindRepository itemInterfaceBindRepository, InterfaceResponseParamsRepository interfaceResponseParamsRepository, ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository, TaskTimeConfRepository taskTimeConfRepository) {
        this.itemInterfaceTaskBindRepository = itemInterfaceTaskBindRepository;
        this.interfaceInfoRepository = interfaceInfoRepository;
        this.itemInterfaceBindRepository = itemInterfaceBindRepository;
        this.interfaceResponseParamsRepository = interfaceResponseParamsRepository;
        this.itemInterfaceParamsBindRepository = itemInterfaceParamsBindRepository;
        this.taskTimeConfRepository = taskTimeConfRepository;
    }
}

