/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ActRuDetailApi;
import net.risesoft.entity.ActRuDetail;
import net.risesoft.model.itemadmin.ActRuDetailModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ActRuDetailService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/actRuDetail"}, produces={"application/json"})
public class ActRuDetailApiImpl
implements ActRuDetailApi {
    private final ActRuDetailService actRuDetailService;

    public Y9Result<Object> endByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.actRuDetailService.endByProcessInstanceId(processInstanceId);
        return Y9Result.success();
    }

    public Y9Result<Object> endByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.actRuDetailService.endByProcessSerialNumber(processSerialNumber);
        return Y9Result.success();
    }

    public Y9Result<List<ActRuDetailModel>> findByProcessInstanceIdAndStatus(@RequestParam String tenantId, @RequestParam String processInstanceId, int status) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<ActRuDetail> actRuDetailList = this.actRuDetailService.listByProcessInstanceIdAndStatus(processInstanceId, status);
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : actRuDetailList) {
            ActRuDetailModel model = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)model);
            modelList.add(model);
        }
        return Y9Result.success(modelList);
    }

    public Y9Result<List<ActRuDetailModel>> findByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<ActRuDetail> actRuDetailList = this.actRuDetailService.listByProcessSerialNumber(processSerialNumber);
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : actRuDetailList) {
            ActRuDetailModel model = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)model);
            modelList.add(model);
        }
        return Y9Result.success(modelList);
    }

    public Y9Result<ActRuDetailModel> findByProcessSerialNumberAndAssignee(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String assignee) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ActRuDetail actRuDetail = this.actRuDetailService.findByProcessSerialNumberAndAssignee(processSerialNumber, assignee);
        ActRuDetailModel model = new ActRuDetailModel();
        Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)model);
        return Y9Result.success((Object)model);
    }

    public Y9Result<List<ActRuDetailModel>> findByProcessSerialNumberAndStatus(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam int status) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<ActRuDetail> actRuDetailList = this.actRuDetailService.listByProcessSerialNumberAndStatus(processSerialNumber, status);
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : actRuDetailList) {
            ActRuDetailModel model = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)model);
            modelList.add(model);
        }
        return Y9Result.success(modelList);
    }

    public Y9Result<Object> recoveryByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.actRuDetailService.recoveryByProcessInstanceId(processInstanceId);
        return Y9Result.success();
    }

    public Y9Result<Object> removeByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.actRuDetailService.removeByProcessInstanceId(processInstanceId);
        return Y9Result.success();
    }

    public Y9Result<Object> removeByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.actRuDetailService.removeByProcessSerialNumber(processSerialNumber);
        return Y9Result.success();
    }

    public Y9Result<Object> removeByProcessSerialNumberAndAssignee(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String assignee) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.actRuDetailService.removeByProcessSerialNumberAndAssignee(processSerialNumber, assignee);
        return Y9Result.success();
    }

    public Y9Result<Object> saveOrUpdate(@RequestParam String tenantId, @RequestBody ActRuDetailModel actRuDetailModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ActRuDetail actRuDetail = new ActRuDetail();
        Y9BeanUtil.copyProperties((Object)actRuDetailModel, (Object)actRuDetail);
        this.actRuDetailService.saveOrUpdate(actRuDetail);
        return Y9Result.success();
    }

    public Y9Result<Object> syncByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.actRuDetailService.syncByProcessInstanceId(processInstanceId);
        return Y9Result.success();
    }

    @Generated
    public ActRuDetailApiImpl(ActRuDetailService actRuDetailService) {
        this.actRuDetailService = actRuDetailService;
    }
}

