/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class WorkdayUtils {
    public static final int LEGAL_WORKDAY = 1;
    public static final int LEGAL_HOLIDAY = 2;
    public static final int WORKDAY = 3;
    public static final int HOLIDAY = 4;
    private String datePattern = "yyyy-MM-dd";
    private String legalWorkday;
    private String legalHoliday;

    public WorkdayUtils() {
    }

    public WorkdayUtils(String legalWorkday, String legalHoliday) {
        this.legalWorkday = legalWorkday;
        this.legalHoliday = legalHoliday;
    }

    public WorkdayUtils(String legalWorkday, String legalHoliday, String datePattern) {
        this.legalWorkday = legalWorkday;
        this.legalHoliday = legalHoliday;
        this.datePattern = datePattern;
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        WorkdayUtils workdayUtils = new WorkdayUtils();
        Date date = workdayUtils.getWorkday(new Date(), 15);
        System.out.println(format.format(date));
        System.out.println(workdayUtils.getWorkdayCount(new Date(), format.parse("2013-08-13")));
    }

    private void assertNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("The date must not be null!");
        }
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        if (StringUtils.isNotBlank((CharSequence)datePattern)) {
            this.datePattern = datePattern;
        }
    }

    public int getDayType(Date date) {
        this.assertNotNull(date);
        String dateStr = DateFormatUtils.format((Date)date, (String)this.datePattern);
        if (this.legalWorkday != null && !this.legalWorkday.isEmpty() && this.legalWorkday.contains(dateStr)) {
            return 1;
        }
        if (this.legalHoliday != null && !this.legalHoliday.isEmpty() && this.legalHoliday.contains(dateStr)) {
            return 2;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(7);
        if (2 <= day && day <= 6) {
            return 3;
        }
        return 4;
    }

    private Date getNeighbourWorkday(Date date, int neighbour) {
        this.assertNotNull(date);
        Date nextWorkday = date;
        while (!this.isWorkday(nextWorkday = DateUtils.addDays((Date)nextWorkday, (int)neighbour))) {
        }
        return nextWorkday;
    }

    public Date getNextWorkday(Date date) {
        return this.getNeighbourWorkday(date, 1);
    }

    public Date getPrevWorkday(Date date) {
        return this.getNeighbourWorkday(date, -1);
    }

    public Date getWorkday(Date date, int amount) {
        int i;
        this.assertNotNull(date);
        Date workday = date;
        if (amount > 0) {
            for (i = 0; i < amount; ++i) {
                workday = this.getNextWorkday(workday);
            }
        }
        if (amount < 0) {
            for (i = amount; i < 0; ++i) {
                workday = this.getPrevWorkday(workday);
            }
        }
        return workday;
    }

    public int getWorkdayCount(Date startDate, Date endDate) {
        this.assertNotNull(startDate);
        this.assertNotNull(endDate);
        int count = 0;
        if (DateUtils.isSameDay((Date)startDate, (Date)endDate)) {
            if (this.isWorkday(startDate)) {
                count = 1;
            }
            return count;
        }
        if (endDate.before(startDate)) {
            throw new IllegalArgumentException("The endDate must be greater than startDate");
        }
        Date day = startDate;
        while (!DateUtils.isSameDay((Date)day, (Date)endDate)) {
            if (!this.isWorkday(day = DateUtils.addDays((Date)day, (int)1))) continue;
            ++count;
        }
        return count;
    }

    public boolean isWorkday(Date date) {
        int dayType = this.getDayType(date);
        return dayType == 1 || dayType == 3;
    }

    public void setLegalHoliday(String legalHoliday) {
        this.legalHoliday = legalHoliday;
    }

    public void setLegalWorkday(String legalWorkday) {
        this.legalWorkday = legalWorkday;
    }
}

