/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.customgroup.CustomGroupApi;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.entity.ItemPermission;
import net.risesoft.entity.ReceiveDepartment;
import net.risesoft.enums.ItemPermissionEnum;
import net.risesoft.enums.ItemPrincipalTypeEnum;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.ItemRoleOrgUnitModel;
import net.risesoft.model.platform.CustomGroup;
import net.risesoft.model.platform.CustomGroupMember;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.repository.jpa.ReceiveDepartmentRepository;
import net.risesoft.service.DynamicRoleMemberService;
import net.risesoft.service.RoleService;
import net.risesoft.service.config.ItemPermissionService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    private final ItemPermissionService itemPermissionService;
    private final DynamicRoleMemberService dynamicRoleMemberService;
    private final RoleApi roleManager;
    private final DepartmentApi departmentApi;
    private final OrgUnitApi orgUnitManager;
    private final ReceiveDepartmentRepository receiveDepartmentRepository;
    private final CustomGroupApi customGroupApi;

    @Override
    public List<ItemRoleOrgUnitModel> listCsUser(String id, Integer principalType, String processInstanceId) {
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String userId = Y9LoginUserHolder.getPersonId();
        try {
            if (StringUtils.isBlank((CharSequence)id) || "null".equals(id)) {
                if (ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) {
                    Organization organization = (Organization)this.orgUnitManager.getOrganization(tenantId, userId).getData();
                    List orgUnitList = (List)this.orgUnitManager.getSubTree(tenantId, organization.getId(), OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                    for (OrgUnit orgUnit : orgUnitList) {
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(orgUnit.getId());
                        model.setParentId(id);
                        model.setName(orgUnit.getName());
                        model.setIsParent(Boolean.valueOf(orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                        model.setOrgType(orgUnit.getOrgType().getValue());
                        model.setPrincipalType(orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) ? ItemPermissionEnum.DEPARTMENT.getValue() : ItemPermissionEnum.POSITION.getValue());
                        if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                            model.setPerson("6:" + orgUnit.getId());
                        }
                        item.add(model);
                    }
                } else {
                    List grouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, userId).getData();
                    for (CustomGroup customGroup : grouplist) {
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(customGroup.getId());
                        model.setParentId("");
                        model.setName(customGroup.getGroupName());
                        model.setIsParent(Boolean.valueOf(true));
                        model.setOrgType("customGroup");
                        model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                        if (item.contains(model)) continue;
                        item.add(model);
                    }
                }
            } else if (ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) {
                List orgList = (List)this.orgUnitManager.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                for (OrgUnit orgunit : orgList) {
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    String orgunitId = orgunit.getId();
                    model.setId(orgunitId);
                    model.setParentId(id);
                    model.setName(orgunit.getName());
                    model.setOrgType(orgunit.getOrgType().getValue());
                    model.setIsParent(Boolean.valueOf(orgunit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                    if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                        model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                    } else if (OrgTypeEnum.POSITION.equals((Object)orgunit.getOrgType())) {
                        model.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        model.setPerson("6:" + orgunit.getId());
                    }
                    if (item.contains(model)) continue;
                    item.add(model);
                }
            } else {
                List customGroupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, userId, id, OrgTypeEnum.POSITION).getData();
                if (null != customGroupMemberList && !customGroupMemberList.isEmpty()) {
                    for (CustomGroupMember customGroupMember : customGroupMemberList) {
                        OrgUnit user = (OrgUnit)this.orgUnitManager.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(customGroupMember.getMemberId());
                        model.setParentId(id);
                        model.setName(user.getName());
                        model.setIsParent(Boolean.valueOf(false));
                        model.setOrgType(user.getOrgType().getValue());
                        model.setPerson("6:" + user.getId() + ":" + user.getParentId());
                        model.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        if (item.contains(model)) continue;
                        item.add(model);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listCsUserSearch(String name, Integer principalType, String processInstanceId) {
        ArrayList<ItemRoleOrgUnitModel> item;
        block12: {
            String userId;
            String tenantId;
            block11: {
                tenantId = Y9LoginUserHolder.getTenantId();
                userId = Y9LoginUserHolder.getPersonId();
                item = new ArrayList<ItemRoleOrgUnitModel>();
                if (!ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) break block11;
                Organization organization = (Organization)this.orgUnitManager.getOrganization(tenantId, userId).getData();
                List deptList = (List)this.departmentApi.listByParentId(tenantId, organization.getId()).getData();
                ArrayList orgUnitListTemp = new ArrayList();
                for (OrgUnit orgUnitTemp : deptList) {
                    orgUnitListTemp.addAll((Collection)this.orgUnitManager.treeSearchByDn(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_ORG_POSITION, orgUnitTemp.getDn()).getData());
                }
                for (OrgUnit orgUnitTemp : orgUnitListTemp) {
                    boolean b;
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(orgUnitTemp.getId());
                    model.setParentId(orgUnitTemp.getParentId());
                    model.setName(orgUnitTemp.getName());
                    model.setOrgType(orgUnitTemp.getOrgType().getValue());
                    if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                        model.setIsParent(Boolean.valueOf(true));
                    } else {
                        if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) {
                            model.setIsParent(Boolean.valueOf(true));
                            continue;
                        }
                        if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                            model.setPerson("6:" + orgUnitTemp.getId());
                            model.setIsParent(Boolean.valueOf(true));
                        } else if (orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.PERSON) || orgUnitTemp.getOrgType().equals((Object)OrgTypeEnum.GROUP)) continue;
                    }
                    if (b = item.contains(model)) continue;
                    item.add(model);
                }
                break block12;
            }
            if (!ItemPrincipalTypeEnum.CUSTOMGROUP.getValue().equals(principalType)) break block12;
            try {
                List grouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, userId).getData();
                for (CustomGroup customGroup : grouplist) {
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(customGroup.getId());
                    model.setParentId("");
                    model.setName(customGroup.getGroupName());
                    model.setOrgType("customGroup");
                    model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                    model.setIsParent(Boolean.valueOf(true));
                    if (item.contains(model)) continue;
                    boolean b = false;
                    List customGroupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, userId, customGroup.getId(), OrgTypeEnum.POSITION).getData();
                    if (null == customGroupMemberList || customGroupMemberList.isEmpty()) continue;
                    for (CustomGroupMember customGroupMember : customGroupMemberList) {
                        OrgUnit user = (OrgUnit)this.orgUnitManager.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                        if (user == null || !user.getName().contains(name)) continue;
                        ItemRoleOrgUnitModel model0 = new ItemRoleOrgUnitModel();
                        model0.setIsParent(Boolean.valueOf(false));
                        model0.setPerson("6:" + user.getId() + ":" + user.getParentId());
                        model0.setId(customGroupMember.getMemberId());
                        model0.setOrgType(user.getOrgType().getValue());
                        model0.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        model0.setName(user.getName());
                        model0.setParentId(customGroup.getId());
                        if (item.contains(model0)) continue;
                        item.add(model0);
                        b = true;
                    }
                    if (!b || item.contains(model)) continue;
                    item.add(model);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return item;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listPermUser(String itemId, String processDefinitionId, String taskDefKey, Integer principalType, String id, String processInstanceId) {
        ArrayList<ItemRoleOrgUnitModel> item;
        block29: {
            item = new ArrayList<ItemRoleOrgUnitModel>();
            String tenantId = Y9LoginUserHolder.getTenantId();
            try {
                List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefKey);
                if (ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) {
                    if (StringUtils.isBlank((CharSequence)id)) {
                        ArrayList<OrgUnit> deptList = new ArrayList<OrgUnit>();
                        for (ItemPermission o : list) {
                            if (o.getRoleType() == 1) {
                                deptList.addAll((Collection)this.roleManager.listOrgUnitsById(tenantId, o.getRoleId(), OrgTypeEnum.DEPARTMENT).getData());
                                deptList.addAll((Collection)this.roleManager.listOrgUnitsById(tenantId, o.getRoleId(), OrgTypeEnum.ORGANIZATION).getData());
                            }
                            if (o.getRoleType() == 2) {
                                deptList.add((OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, o.getRoleId()).getData());
                            }
                            if (o.getRoleType() != 4) continue;
                            List<OrgUnit> orgUnitList = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(o.getRoleId(), processInstanceId);
                            for (OrgUnit orgUnit : orgUnitList) {
                                if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) && !orgUnit.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) continue;
                                deptList.add(orgUnit);
                            }
                        }
                        for (OrgUnit org : deptList) {
                            if (OrgTypeEnum.ORGANIZATION.equals((Object)org.getOrgType())) {
                                List orgList = (List)this.orgUnitManager.getSubTree(tenantId, org.getId(), OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                                for (OrgUnit orgUnit : orgList) {
                                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                                    model.setId(orgUnit.getId());
                                    model.setParentId(id);
                                    model.setName(orgUnit.getName());
                                    model.setIsParent(Boolean.valueOf(org.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                                    model.setOrgType(orgUnit.getOrgType().getValue());
                                    model.setPrincipalType(orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) ? ItemPermissionEnum.DEPARTMENT.getValue() : ItemPermissionEnum.POSITION.getValue());
                                    if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                        model.setPerson("6:" + orgUnit.getId());
                                    }
                                    if (item.contains(model)) continue;
                                    item.add(model);
                                }
                                continue;
                            }
                            ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                            model.setId(org.getId());
                            model.setParentId(id);
                            model.setName(org.getName());
                            model.setIsParent(Boolean.valueOf(true));
                            model.setOrgType(org.getOrgType() == null ? OrgTypeEnum.ORGANIZATION.getEnName() : org.getOrgType().getValue());
                            model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                            if (item.contains(model)) continue;
                            item.add(model);
                        }
                        break block29;
                    }
                    List orgList = (List)this.orgUnitManager.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_POSITION).getData();
                    for (OrgUnit orgunit : orgList) {
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        String orgunitId = orgunit.getId();
                        model.setId(orgunitId);
                        model.setParentId(id);
                        model.setName(orgunit.getName());
                        model.setIsParent(Boolean.valueOf(orgunit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)));
                        model.setOrgType(orgunit.getOrgType().getValue());
                        if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                            model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                        } else if (OrgTypeEnum.POSITION.equals((Object)orgunit.getOrgType())) {
                            model.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                            model.setPerson("6:" + orgunit.getId());
                        }
                        if (item.contains(model)) continue;
                        item.add(model);
                    }
                    break block29;
                }
                if (ItemPrincipalTypeEnum.POSITION.getValue().equals(principalType)) {
                    ArrayList<OrgUnit> orgList = new ArrayList<OrgUnit>();
                    for (ItemPermission o : list) {
                        if (o.getRoleType() == 1) {
                            orgList.addAll((Collection)this.roleManager.listOrgUnitsById(tenantId, o.getRoleId(), OrgTypeEnum.POSITION).getData());
                        }
                        if (o.getRoleType() == 6) {
                            orgList.add((OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, o.getRoleId()).getData());
                        }
                        if (o.getRoleType() != 4) continue;
                        List<OrgUnit> orgUnitList = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(o.getRoleId(), processInstanceId);
                        for (OrgUnit orgUnit : orgUnitList) {
                            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) continue;
                            orgList.add(orgUnit);
                        }
                    }
                    for (OrgUnit orgUnit : orgList) {
                        ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                        model.setId(orgUnit.getId());
                        model.setParentId(orgUnit.getParentId());
                        model.setName(orgUnit.getName());
                        model.setIsParent(Boolean.valueOf(false));
                        model.setOrgType(orgUnit.getOrgType().getValue());
                        model.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        model.setPerson("6:" + orgUnit.getId());
                        if (item.contains(model)) continue;
                        item.add(model);
                    }
                } else if (ItemPrincipalTypeEnum.CUSTOMGROUP.getValue().equals(principalType)) {
                    List customGrouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, Y9LoginUserHolder.getPersonId()).getData();
                    if (StringUtils.isBlank((CharSequence)id)) {
                        for (CustomGroup customGroup : customGrouplist) {
                            ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                            model.setId(customGroup.getId());
                            model.setParentId("");
                            model.setName(customGroup.getGroupName());
                            model.setIsParent(Boolean.valueOf(true));
                            model.setOrgType("customGroup");
                            model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                            if (item.contains(model)) continue;
                            item.add(model);
                        }
                    } else {
                        List customGroupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, Y9LoginUserHolder.getPersonId(), id, OrgTypeEnum.POSITION).getData();
                        if (null != customGroupMemberList && !customGroupMemberList.isEmpty()) {
                            for (CustomGroupMember customGroupMember : customGroupMemberList) {
                                OrgUnit user = (OrgUnit)this.orgUnitManager.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                                ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                                model.setId(customGroupMember.getMemberId());
                                model.setParentId(id);
                                model.setName(user.getName());
                                model.setIsParent(Boolean.valueOf(false));
                                model.setOrgType(user.getOrgType().getValue());
                                model.setPerson("6:" + user.getId());
                                model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                                if (item.contains(model)) continue;
                                item.add(model);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return item;
    }

    @Override
    public List<OrgUnit> listPermUser4SUbmitTo(String itemId, String processDefinitionId, String taskDefKey, String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<OrgUnit> orgList = new ArrayList<OrgUnit>();
        try {
            ArrayList<OrgUnit> orgListTemp = new ArrayList<OrgUnit>();
            List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefKey);
            for (ItemPermission o : list) {
                if (o.getRoleType() == 1) {
                    orgListTemp.addAll((Collection)this.roleManager.listOrgUnitsById(tenantId, o.getRoleId(), OrgTypeEnum.POSITION).getData());
                }
                if (o.getRoleType() == 4) {
                    List<OrgUnit> orgUnitList = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(o.getRoleId(), processInstanceId);
                    for (OrgUnit orgUnit : orgUnitList) {
                        if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) continue;
                        orgListTemp.add(orgUnit);
                    }
                }
                if (o.getRoleType() != 6) continue;
                orgListTemp.add((OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, o.getRoleId()).getData());
            }
            for (OrgUnit orgUnit : orgListTemp) {
                if (orgList.contains(orgUnit)) continue;
                orgList.add(orgUnit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgList;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listPermUserByName(String name, String itemId, String processDefinitionId, String taskDefKey, Integer principalType, String processInstanceId) {
        ArrayList<ItemRoleOrgUnitModel> item;
        block22: {
            String tenantId;
            block23: {
                List<ItemPermission> list;
                block21: {
                    List<Object> orgUnitList;
                    tenantId = Y9LoginUserHolder.getTenantId();
                    list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefKey);
                    item = new ArrayList<ItemRoleOrgUnitModel>();
                    if (!ItemPrincipalTypeEnum.DEPT.getValue().equals(principalType)) break block21;
                    ArrayList<Object> deptList = new ArrayList<Object>();
                    for (ItemPermission itemPermission : list) {
                        Department dept;
                        if (itemPermission.getRoleType() == 1) {
                            deptList.addAll((Collection)this.roleManager.listOrgUnitsById(tenantId, itemPermission.getRoleId(), OrgTypeEnum.DEPARTMENT).getData());
                            deptList.addAll((Collection)this.roleManager.listOrgUnitsById(tenantId, itemPermission.getRoleId(), OrgTypeEnum.ORGANIZATION).getData());
                        }
                        if (itemPermission.getRoleType() == 4) {
                            orgUnitList = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(itemPermission.getRoleId(), processInstanceId);
                            for (OrgUnit orgUnit : orgUnitList) {
                                if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT) && !orgUnit.getOrgType().equals((Object)OrgTypeEnum.ORGANIZATION)) continue;
                                deptList.add(orgUnit);
                            }
                        }
                        if (itemPermission.getRoleType() != 2 || (dept = (Department)this.departmentApi.get(tenantId, itemPermission.getRoleId()).getData()) == null) continue;
                        deptList.add(dept);
                    }
                    for (OrgUnit orgUnit : deptList) {
                        ItemRoleOrgUnitModel model;
                        if (OrgTypeEnum.DEPARTMENT.equals((Object)orgUnit.getOrgType())) {
                            orgUnitList = new ArrayList();
                            for (OrgUnit orgUnit2 : deptList) {
                                orgUnitList.addAll((Collection)this.orgUnitManager.treeSearchByDn(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_ORG_POSITION, orgUnit2.getDn()).getData());
                            }
                            for (OrgUnit orgUnit3 : orgUnitList) {
                                model = new ItemRoleOrgUnitModel();
                                model.setId(orgUnit3.getId());
                                model.setName(orgUnit3.getName());
                                model.setOrgType(orgUnit3.getOrgType().getValue());
                                model.setParentId(orgUnit3.getParentId());
                                if (orgUnit3.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                                    model.setIsParent(Boolean.valueOf(true));
                                    if (item.contains(model)) continue;
                                    item.add(model);
                                    continue;
                                }
                                if (!orgUnit3.getOrgType().equals((Object)OrgTypeEnum.POSITION)) continue;
                                model.setIsParent(Boolean.valueOf(false));
                                model.setPerson("6:" + orgUnit3.getId());
                                if (item.contains(model)) continue;
                                item.add(model);
                            }
                            continue;
                        }
                        if (!OrgTypeEnum.ORGANIZATION.equals((Object)orgUnit.getOrgType())) continue;
                        orgUnitList = (List)this.orgUnitManager.treeSearch(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_ORG_POSITION).getData();
                        for (OrgUnit orgUnit4 : orgUnitList) {
                            if (OrgTypeEnum.ORGANIZATION.equals((Object)orgUnit4.getOrgType()) || !orgUnit4.getGuidPath().contains(orgUnit.getId())) continue;
                            model = new ItemRoleOrgUnitModel();
                            model.setId(orgUnit4.getId());
                            model.setName(orgUnit4.getName());
                            model.setOrgType(orgUnit4.getOrgType().getValue());
                            model.setParentId(orgUnit4.getParentId());
                            if (OrgTypeEnum.POSITION.equals((Object)orgUnit4.getOrgType())) {
                                model.setPerson("6:" + orgUnit4.getId());
                            }
                            if (item.contains(model)) continue;
                            item.add(model);
                        }
                    }
                    break block22;
                }
                if (!ItemPrincipalTypeEnum.POSITION.getValue().equals(principalType)) break block23;
                ArrayList<OrgUnit> orgList = new ArrayList<OrgUnit>();
                for (ItemPermission itemPermission : list) {
                    if (itemPermission.getRoleType() == 1) {
                        orgList.addAll((Collection)this.roleManager.listOrgUnitsById(tenantId, itemPermission.getRoleId(), OrgTypeEnum.POSITION).getData());
                    }
                    if (itemPermission.getRoleType() == 4) {
                        List<OrgUnit> orgUnitList = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(itemPermission.getRoleId(), processInstanceId);
                        for (OrgUnit orgUnit : orgUnitList) {
                            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) continue;
                            orgList.add(orgUnit);
                        }
                    }
                    if (itemPermission.getRoleType() != 6) continue;
                    OrgUnit per = (OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, itemPermission.getRoleId()).getData();
                    orgList.add(per);
                }
                for (OrgUnit orgUnit : orgList) {
                    if (!orgUnit.getName().contains(name)) continue;
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(orgUnit.getId());
                    model.setName(orgUnit.getName());
                    model.setOrgType(orgUnit.getOrgType().getValue());
                    model.setParentId(orgUnit.getParentId());
                    if (OrgTypeEnum.POSITION.equals((Object)orgUnit.getOrgType())) {
                        model.setPerson("6:" + orgUnit.getId());
                    }
                    if (item.contains(model)) continue;
                    item.add(model);
                }
                break block22;
            }
            if (!ItemPrincipalTypeEnum.CUSTOMGROUP.getValue().equals(principalType)) break block22;
            try {
                List grouplist = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, Y9LoginUserHolder.getPersonId()).getData();
                for (CustomGroup customGroup : grouplist) {
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(customGroup.getId());
                    model.setName(customGroup.getGroupName());
                    model.setOrgType("customGroup");
                    model.setParentId("");
                    model.setPrincipalType(ItemPermissionEnum.CUSTOMGROUP.getValue());
                    model.setIsParent(Boolean.valueOf(true));
                    if (item.contains(model)) continue;
                    boolean b = false;
                    List list = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, Y9LoginUserHolder.getPersonId(), customGroup.getId(), OrgTypeEnum.POSITION).getData();
                    if (null == list || list.isEmpty()) continue;
                    for (CustomGroupMember customGroupMember : list) {
                        OrgUnit user = (OrgUnit)this.orgUnitManager.getOrgUnitPersonOrPosition(tenantId, customGroupMember.getMemberId()).getData();
                        if (user == null || !user.getName().contains(name)) continue;
                        ItemRoleOrgUnitModel model1 = new ItemRoleOrgUnitModel();
                        model1.setId(customGroupMember.getMemberId());
                        model1.setName(user.getName());
                        model1.setOrgType(user.getOrgType().getValue());
                        model1.setParentId(customGroup.getId());
                        model1.setPerson("6:" + user.getId() + ":" + user.getParentId());
                        model1.setPrincipalType(ItemPermissionEnum.POSITION.getValue());
                        model1.setIsParent(Boolean.valueOf(false));
                        if (item.contains(model1)) continue;
                        item.add(model1);
                        b = true;
                    }
                    if (!b || item.contains(model)) continue;
                    item.add(model);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return item;
    }

    @Override
    public List<ItemRoleOrgUnitModel> listPermUserSendReceive(String id) {
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                List list = this.receiveDepartmentRepository.findAll();
                for (ReceiveDepartment receiveDepartment : list) {
                    Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
                    if (department == null || department.getId() == null) continue;
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(receiveDepartment.getDeptId());
                    model.setName(department.getName());
                    model.setOrgType(OrgTypeEnum.DEPARTMENT.getEnName());
                    model.setParentId(receiveDepartment.getParentId());
                    model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                    Integer count = this.receiveDepartmentRepository.countByParentId(receiveDepartment.getDeptId());
                    model.setIsParent(Boolean.valueOf(count > 0));
                    item.add(model);
                }
            } else {
                List list = this.receiveDepartmentRepository.findByParentIdOrderByTabIndex(id);
                for (ReceiveDepartment receiveDepartment : list) {
                    Department department = (Department)this.departmentApi.get(tenantId, receiveDepartment.getDeptId()).getData();
                    if (department == null || department.getId() == null) continue;
                    ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
                    model.setId(receiveDepartment.getDeptId());
                    model.setName(department.getName());
                    model.setOrgType(OrgTypeEnum.DEPARTMENT.getEnName());
                    model.setParentId(receiveDepartment.getParentId());
                    model.setPrincipalType(ItemPermissionEnum.DEPARTMENT.getValue());
                    Integer count = this.receiveDepartmentRepository.countByParentId(receiveDepartment.getDeptId());
                    model.setIsParent(Boolean.valueOf(count > 0));
                    item.add(model);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    @Generated
    public RoleServiceImpl(ItemPermissionService itemPermissionService, DynamicRoleMemberService dynamicRoleMemberService, RoleApi roleManager, DepartmentApi departmentApi, OrgUnitApi orgUnitManager, ReceiveDepartmentRepository receiveDepartmentRepository, CustomGroupApi customGroupApi) {
        this.itemPermissionService = itemPermissionService;
        this.dynamicRoleMemberService = dynamicRoleMemberService;
        this.roleManager = roleManager;
        this.departmentApi = departmentApi;
        this.orgUnitManager = orgUnitManager;
        this.receiveDepartmentRepository = receiveDepartmentRepository;
        this.customGroupApi = customGroupApi;
    }
}

