/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import net.risesoft.api.platform.customgroup.CustomGroupApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.processadmin.HistoricProcessApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.api.sms.SmsHttpApi;
import net.risesoft.api.todo.TodoTaskApi;
import net.risesoft.entity.ErrorLog;
import net.risesoft.entity.ProcessParam;
import net.risesoft.enums.ItemBoxTypeEnum;
import net.risesoft.enums.ItemPermissionEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.ChaoSongModel;
import net.risesoft.model.itemadmin.OpenDataModel;
import net.risesoft.model.platform.CustomGroupMember;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.HistoricProcessInstanceModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.nosql.elastic.entity.ChaoSongInfo;
import net.risesoft.nosql.elastic.entity.OfficeDoneInfo;
import net.risesoft.nosql.elastic.repository.ChaoSongInfoRepository;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.AsyncHandleService;
import net.risesoft.service.ChaoSongInfoService;
import net.risesoft.service.DocumentService;
import net.risesoft.service.ErrorLogService;
import net.risesoft.service.OfficeDoneInfoService;
import net.risesoft.service.OfficeFollowService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.service.impl.ChaoSongInfoServiceImpl$AjcClosure1;
import net.risesoft.service.impl.ChaoSongInfoServiceImpl$AjcClosure3;
import net.risesoft.service.impl.ChaoSongInfoServiceImpl$AjcClosure5;
import net.risesoft.service.impl.ChaoSongInfoServiceImpl$AjcClosure7;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9.util.Y9BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;

@Service
public class ChaoSongInfoServiceImpl
implements ChaoSongInfoService {
    @Generated
    private static final Logger LOGGER;
    private final ChaoSongInfoRepository chaoSongInfoRepository;
    private final DocumentService documentService;
    private final ProcessParamService processParamService;
    private final TaskApi taskManager;
    private final HistoricProcessApi historicProcessManager;
    private final OrganizationApi organizationManager;
    private final PositionApi positionApi;
    private final OrgUnitApi orgUnitApi;
    private final SmsHttpApi smsHttpManager;
    private final OfficeDoneInfoService officeDoneInfoService;
    private final Y9Properties y9Conf;
    private final OfficeFollowService officeFollowService;
    private final AsyncHandleService asyncHandleService;
    private final ErrorLogService errorLogService;
    private final ElasticsearchTemplate elasticsearchTemplate;
    private final TodoTaskApi todoTaskManager;
    private final CustomGroupApi customGroupApi;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Override
    @Transactional
    public void changeChaoSongState(String id, String type) {
        String string = id;
        String string2 = type;
        Object[] objectArray = new Object[]{this, string, string2};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new ChaoSongInfoServiceImpl$AjcClosure1(objectArray), ajc$tjp_0);
    }

    @Override
    public void changeStatus(String id) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ChaoSongInfo chaoSong = this.chaoSongInfoRepository.findById((Object)id).orElse(null);
        if (chaoSong != null) {
            chaoSong.setStatus(Integer.valueOf(1));
            chaoSong.setReadTime(sdf.format(new Date()));
            this.chaoSongInfoRepository.save((Object)chaoSong);
            try {
                this.todoTaskManager.deleteTodoTask(Y9LoginUserHolder.getTenantId(), id);
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u5f85\u529e\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public void changeStatus(String[] ids) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (String id : ids) {
            ChaoSongInfo chaoSong = this.chaoSongInfoRepository.findById((Object)id).orElse(null);
            if (chaoSong != null) {
                chaoSong.setStatus(Integer.valueOf(1));
                chaoSong.setReadTime(sdf.format(new Date()));
                this.chaoSongInfoRepository.save((Object)chaoSong);
            }
            try {
                this.todoTaskManager.deleteTodoTask(Y9LoginUserHolder.getTenantId(), id);
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u5f85\u529e\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public int countAllByUserId(String userId) {
        return this.chaoSongInfoRepository.countByUserIdAndTenantId(userId, Y9LoginUserHolder.getTenantId());
    }

    @Override
    public int countByProcessInstanceId(String userId, String processInstanceId) {
        return this.chaoSongInfoRepository.countBySenderIdIsNotAndProcessInstanceId(userId, processInstanceId);
    }

    @Override
    public int countByUserIdAndProcessInstanceId(String userId, String processInstanceId) {
        return this.chaoSongInfoRepository.countBySenderIdAndProcessInstanceId(userId, processInstanceId);
    }

    @Override
    public void deleteById(String id) {
        this.chaoSongInfoRepository.deleteById((Object)id);
    }

    @Override
    public void deleteByIds(String[] ids) {
        for (String id : ids) {
            this.chaoSongInfoRepository.deleteById((Object)id);
            try {
                this.todoTaskManager.deleteTodoTask(Y9LoginUserHolder.getTenantId(), id);
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u5f85\u529e\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    @Transactional
    public boolean deleteByProcessInstanceId(String processInstanceId) {
        String string = processInstanceId;
        Object[] objectArray = new Object[]{this, string};
        return Conversions.booleanValue((Object)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new ChaoSongInfoServiceImpl$AjcClosure3(objectArray), ajc$tjp_1));
    }

    @Override
    public OpenDataModel detail(String processInstanceId, Integer status, boolean mobile) {
        String processDefinitionKey;
        String processDefinitionId;
        OpenDataModel model = new OpenDataModel();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String itembox = ItemBoxTypeEnum.DOING.getValue();
        String taskId = "";
        List taskList = (List)this.taskManager.findByProcessInstanceId(tenantId, processInstanceId).getData();
        if (taskList.isEmpty()) {
            itembox = ItemBoxTypeEnum.DONE.getValue();
        }
        if (ItemBoxTypeEnum.DOING.getValue().equals(itembox)) {
            taskId = ((TaskModel)taskList.get(0)).getId();
            TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            processInstanceId = task.getProcessInstanceId();
        }
        String taskDefinitionKey = "";
        String activitiUser = "";
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
        if (hpi == null) {
            OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
            if (officeDoneInfo == null) {
                String year = processParam.getCreateTime().substring(0, 4);
                hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getByIdAndYear(tenantId, processInstanceId, year).getData();
                processDefinitionId = hpi.getProcessDefinitionId();
                processDefinitionKey = processDefinitionId.split(":")[0];
            } else {
                processDefinitionId = officeDoneInfo.getProcessDefinitionId();
                processDefinitionKey = officeDoneInfo.getProcessDefinitionKey();
            }
        } else {
            processDefinitionId = hpi.getProcessDefinitionId();
            processDefinitionKey = processDefinitionId.split(":")[0];
        }
        String startor = processParam.getStartor();
        String processSerialNumber = processParam.getProcessSerialNumber();
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            if (taskId.contains(",")) {
                taskId = taskId.split(",")[0];
            }
            TaskModel taskTemp = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            taskDefinitionKey = taskTemp.getTaskDefinitionKey();
        }
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, Y9LoginUserHolder.getOrgUnitId()).getData();
        model.setTitle(processParam.getTitle());
        model.setStartor(startor);
        model.setItembox(itembox);
        model.setCurrentUser(orgUnit.getName());
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setTaskDefKey(taskDefinitionKey);
        model.setTaskId(taskId);
        model.setActivitiUser(activitiUser);
        model.setItemId(processParam.getItemId());
        model = this.documentService.genDocumentModel(processParam.getItemId(), processDefinitionKey, processDefinitionId, taskDefinitionKey, mobile, model);
        String menuName = "\u6253\u5370,\u6284\u9001,\u5173\u6ce8,\u8fd4\u56de";
        String menuKey = "17,18,follow,03";
        if (status == 1) {
            menuName = "\u6253\u5370,\u6284\u9001,\u5173\u6ce8,\u8fd4\u56de";
            menuKey = "17,18,follow,03";
        }
        model.setMenuName(menuName);
        model.setMenuKey(menuKey);
        return model;
    }

    @Override
    public ChaoSongInfo getById(String id) {
        return this.chaoSongInfoRepository.findById((Object)id).orElse(null);
    }

    @Override
    public int getDone4OpinionCountByUserId(String userId) {
        return this.chaoSongInfoRepository.countByUserIdAndOpinionStateAndTenantId(userId, "1", Y9LoginUserHolder.getTenantId());
    }

    @Override
    public int getDoneCountByUserId(String userId) {
        return this.chaoSongInfoRepository.countByUserIdAndStatus(userId, Integer.valueOf(1));
    }

    @Override
    public int getTodoCountByUserId(String userId) {
        return this.chaoSongInfoRepository.countByUserIdAndStatus(userId, Integer.valueOf(2));
    }

    @Override
    public Y9Page<ChaoSongModel> pageByProcessInstanceIdAndUserName(String processInstanceId, String userName, int rows, int page) {
        String senderId = Y9LoginUserHolder.getOrgUnitId();
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("processInstanceId").is((Object)processInstanceId);
        criteria.subCriteria(new Criteria("senderId").not().is((Object)senderId));
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            criteria.subCriteria(new Criteria("userName").contains(userName));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int startRow = (page - 1) * rows;
        for (ChaoSongInfo info : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)info, (Object)model);
            model.setId(info.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(info.getSenderName());
            model.setSendDeptName(info.getSendDeptName());
            model.setUserName(info.getUserName());
            model.setUserDeptName(info.getUserDeptName());
            model.setTitle(info.getTitle());
            model.setSerialNumber(startRow + 1);
            try {
                if (StringUtils.isBlank((CharSequence)info.getReadTime())) {
                    model.setReadTime("");
                } else {
                    model.setReadTime(sdf.format(sdf.parse(info.getReadTime())));
                }
                model.setCreateTime(sdf.format(sdf.parse(info.getCreateTime())));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            ++startRow;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    public Y9Page<ChaoSongModel> pageBySenderIdAndProcessInstanceId(String senderId, String processInstanceId, String userName, int rows, int page) {
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("senderId").is((Object)senderId).and("processInstanceId").is((Object)processInstanceId);
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            criteria.subCriteria(new Criteria("userName").contains(userName));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int startRow = (page - 1) * rows;
        for (ChaoSongInfo cs : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)cs, (Object)model);
            model.setId(cs.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(cs.getSenderName());
            model.setSendDeptName(cs.getSendDeptName());
            model.setUserName(cs.getUserName());
            model.setUserDeptName(cs.getUserDeptName());
            model.setTitle(cs.getTitle());
            model.setSerialNumber(startRow + 1);
            try {
                if (StringUtils.isBlank((CharSequence)cs.getReadTime())) {
                    model.setReadTime("");
                } else {
                    model.setReadTime(sdf.format(sdf.parse(cs.getReadTime())));
                }
                model.setCreateTime(sdf.format(sdf.parse(cs.getCreateTime())));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            ++startRow;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    public Y9Page<Map<String, Object>> pageByUserIdAndDocumentTitle(String userId, String documentTitle, int rows, int page) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("userId").is((Object)userId);
        if (StringUtils.isNotBlank((CharSequence)documentTitle)) {
            criteria.subCriteria(new Criteria("title").contains(documentTitle));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int num = (page - 1) * rows;
        ArrayList listMap = new ArrayList();
        for (ChaoSongInfo cs : csList) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", cs.getId());
            try {
                boolean banjie;
                String processInstanceId = cs.getProcessInstanceId();
                map.put("createTime", sdf.format(sdf.parse(cs.getCreateTime())));
                ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                map.put("processInstanceId", processInstanceId);
                map.put("senderName", cs.getSenderName());
                map.put("sendDeptId", cs.getSendDeptId());
                map.put("sendDeptName", cs.getSendDeptName());
                map.put("readTime", sdf.format(sdf.parse(cs.getReadTime())));
                map.put("title", processParam.getTitle());
                map.put("status", cs.getStatus());
                map.put("banjie", false);
                map.put("itemId", cs.getItemId());
                map.put("itemName", cs.getItemName());
                map.put("processSerialNumber", processParam.getProcessSerialNumber());
                map.put("number", processParam.getCustomNumber());
                map.put("level", processParam.getCustomLevel());
                int chaosongNum = this.chaoSongInfoRepository.countBySenderIdAndProcessInstanceId(userId, processInstanceId);
                map.put("chaosongNum", chaosongNum);
                HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
                boolean bl = banjie = hpi == null || hpi.getEndTime() != null;
                if (banjie) {
                    map.put("banjie", true);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            map.put("serialNumber", num + 1);
            ++num;
            listMap.add(map);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), listMap);
    }

    @Override
    public Y9Page<ChaoSongModel> pageDoneList(String orgUnitId, String documentTitle, int rows, int page) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("userId").is((Object)orgUnitId).and("status").is((Object)1);
        if (StringUtils.isNotBlank((CharSequence)documentTitle)) {
            criteria.subCriteria(new Criteria("title").contains(documentTitle));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int num = (page - 1) * rows;
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        for (ChaoSongInfo cs : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)cs, (Object)model);
            String processInstanceId = cs.getProcessInstanceId();
            model.setSerialNumber(num + 1);
            model.setId(cs.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(cs.getSenderName());
            model.setSendDeptName(cs.getSendDeptName());
            model.setTitle(cs.getTitle());
            model.setStatus(cs.getStatus());
            model.setItemId(cs.getItemId());
            model.setItemName(cs.getItemName());
            model.setBanjie(false);
            try {
                OfficeDoneInfo officeDoneInfo;
                boolean banjie;
                model.setReadTime(sdf.format(sdf.parse(cs.getReadTime())));
                model.setCreateTime(sdf.format(sdf.parse(cs.getCreateTime())));
                HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
                boolean bl = banjie = hpi == null || hpi.getEndTime() != null;
                if (banjie) {
                    model.setBanjie(true);
                }
                model.setProcessDefinitionId((officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId)) != null ? officeDoneInfo.getProcessDefinitionId() : "");
                model.setProcessSerialNumber(officeDoneInfo.getProcessSerialNumber());
                int countFollow = this.officeFollowService.countByProcessInstanceId(processInstanceId);
                model.setFollow(countFollow > 0);
                ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                model.setNumber(processParam.getCustomNumber());
                model.setLevel(processParam.getCustomLevel());
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            ++num;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    public Y9Page<ChaoSongModel> pageMyChaoSongList(String searchName, String itemId, String userName, String state, String year, int rows, int page) {
        String userId = Y9LoginUserHolder.getOrgUnitId();
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("senderId").is((Object)userId);
        if (StringUtils.isNotBlank((CharSequence)searchName)) {
            criteria.subCriteria(new Criteria("title").contains(searchName));
        }
        if (StringUtils.isNotBlank((CharSequence)itemId)) {
            criteria.subCriteria(new Criteria("itemId").is((Object)itemId));
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            criteria.subCriteria(new Criteria("userName").contains(userName));
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            criteria.subCriteria(new Criteria("status").is((Object)Integer.parseInt(state)));
        }
        if (StringUtils.isNotBlank((CharSequence)year)) {
            criteria.subCriteria(new Criteria("createTime").contains(year));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int num = (page - 1) * rows;
        for (ChaoSongInfo cs : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)cs, (Object)model);
            String processInstanceId = cs.getProcessInstanceId();
            model.setSerialNumber(num + 1);
            model.setId(cs.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(cs.getSenderName());
            model.setSendDeptName(cs.getSendDeptName());
            model.setStatus(cs.getStatus());
            model.setItemId(cs.getItemId());
            model.setItemName(cs.getItemName());
            model.setBanjie(false);
            try {
                boolean banjie;
                OfficeDoneInfo hpi = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
                model.setProcessSerialNumber(hpi.getProcessSerialNumber());
                model.setTitle(hpi.getTitle());
                model.setCreateTime(sdf.format(sdf.parse(cs.getCreateTime())));
                model.setUserId(cs.getUserId());
                model.setUserName(cs.getUserName());
                model.setUserDeptName(cs.getUserDeptName());
                model.setReadTime(StringUtils.isNotBlank((CharSequence)cs.getReadTime()) ? sdf.format(sdf.parse(cs.getReadTime())) : "--");
                model.setSystemName(hpi.getSystemName());
                model.setProcessDefinitionId(hpi != null ? hpi.getProcessDefinitionId() : "");
                boolean bl = banjie = hpi == null || hpi.getEndTime() != null;
                if (banjie) {
                    model.setBanjie(true);
                }
                model.setNumber(hpi.getDocNumber());
                model.setLevel(hpi.getUrgency());
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u5217\u8868\u5931\u8d25", (Throwable)e);
            }
            ++num;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    public Y9Page<ChaoSongModel> pageOpinionChaosongByUserId(String userId, String documentTitle, int rows, int page) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (page < 1) {
            page = 1;
        }
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("userId").is((Object)userId).and("opinionState").is((Object)"1");
        if (StringUtils.isNotBlank((CharSequence)documentTitle)) {
            criteria.subCriteria(new Criteria("title").contains(documentTitle));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int num = (page - 1) * rows;
        for (ChaoSongInfo cs : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)cs, (Object)model);
            String processInstanceId = cs.getProcessInstanceId();
            model.setSerialNumber(num + 1);
            model.setId(cs.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(cs.getSenderName());
            model.setSendDeptName(cs.getSendDeptName());
            model.setTitle(cs.getTitle());
            model.setStatus(cs.getStatus());
            model.setItemId(cs.getItemId());
            model.setItemName(cs.getItemName());
            model.setBanjie(false);
            try {
                OfficeDoneInfo officeDoneInfo;
                boolean banjie;
                model.setReadTime(sdf.format(sdf.parse(cs.getReadTime())));
                model.setCreateTime(sdf.format(sdf.parse(cs.getCreateTime())));
                HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
                boolean bl = banjie = hpi == null || hpi.getEndTime() != null;
                if (banjie) {
                    model.setBanjie(true);
                }
                model.setProcessDefinitionId((officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId)) != null ? officeDoneInfo.getProcessDefinitionId() : "");
                model.setProcessSerialNumber(officeDoneInfo.getProcessSerialNumber());
                int countFollow = this.officeFollowService.countByProcessInstanceId(processInstanceId);
                model.setFollow(countFollow > 0);
                ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                model.setNumber(processParam.getCustomNumber());
                model.setLevel(processParam.getCustomLevel());
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            ++num;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    public Y9Page<ChaoSongModel> pageTodoList(String orgUnitId, String documentTitle, int rows, int page) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("userId").is((Object)orgUnitId).and("status").is((Object)2);
        if (StringUtils.isNotBlank((CharSequence)documentTitle)) {
            criteria.subCriteria(new Criteria("title").contains(documentTitle));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int num = (page - 1) * rows;
        for (ChaoSongInfo cs : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)cs, (Object)model);
            String processInstanceId = cs.getProcessInstanceId();
            model.setSerialNumber(num + 1);
            model.setId(cs.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(cs.getSenderName());
            model.setSendDeptName(cs.getSendDeptName());
            model.setTitle(cs.getTitle());
            model.setStatus(cs.getStatus());
            model.setItemId(cs.getItemId());
            model.setItemName(cs.getItemName());
            model.setBanjie(false);
            try {
                OfficeDoneInfo officeDoneInfo;
                boolean banjie;
                model.setCreateTime(sdf.format(sdf.parse(cs.getCreateTime())));
                HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
                boolean bl = banjie = hpi == null || hpi.getEndTime() != null;
                if (banjie) {
                    model.setBanjie(true);
                }
                model.setProcessDefinitionId((officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId)) != null ? officeDoneInfo.getProcessDefinitionId() : "");
                model.setProcessSerialNumber(officeDoneInfo.getProcessSerialNumber());
                int countFollow = this.officeFollowService.countByProcessInstanceId(processInstanceId);
                model.setFollow(countFollow > 0);
                ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                model.setNumber(processParam.getCustomNumber());
                model.setLevel(processParam.getCustomLevel());
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            ++num;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    public ChaoSongInfo save(ChaoSongInfo chaoSong) {
        return (ChaoSongInfo)this.chaoSongInfoRepository.save((Object)chaoSong);
    }

    @Override
    public void save(List<ChaoSongInfo> chaoSongList) {
        this.chaoSongInfoRepository.saveAll(chaoSongList);
    }

    @Override
    @Transactional
    public Y9Result<Object> save(String processInstanceId, String users, String isSendSms, String isShuMing, String smsContent, String smsPersonId) {
        String string = processInstanceId;
        String string2 = users;
        String string3 = isSendSms;
        String string4 = isShuMing;
        String string5 = smsContent;
        String string6 = smsPersonId;
        Object[] objectArray = new Object[]{this, string, string2, string3, string4, string5, string6};
        return (Y9Result)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new ChaoSongInfoServiceImpl$AjcClosure5(objectArray), ajc$tjp_2);
    }

    @Override
    public Y9Page<ChaoSongModel> searchAllByUserId(String searchName, String itemId, String userName, String state, String year, Integer page, Integer rows) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String userId = Y9LoginUserHolder.getOrgUnitId();
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId()).and("userId").is((Object)userId);
        if (StringUtils.isNotBlank((CharSequence)searchName)) {
            criteria.subCriteria(new Criteria("title").contains(searchName));
        }
        if (StringUtils.isNotBlank((CharSequence)itemId)) {
            criteria.subCriteria(new Criteria("itemId").is((Object)itemId));
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            criteria.subCriteria(new Criteria("senderName").contains(userName));
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            criteria.subCriteria(new Criteria("status").is((Object)Integer.parseInt(state)));
        }
        if (StringUtils.isNotBlank((CharSequence)year)) {
            criteria.subCriteria(new Criteria("createTime").contains(year));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int num = (page - 1) * rows;
        for (ChaoSongInfo cs : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)cs, (Object)model);
            String processInstanceId = cs.getProcessInstanceId();
            model.setSerialNumber(num + 1);
            model.setId(cs.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(cs.getSenderName());
            model.setSendDeptName(cs.getSendDeptName());
            model.setTitle(cs.getTitle());
            model.setStatus(cs.getStatus());
            model.setItemId(cs.getItemId());
            model.setItemName(cs.getItemName());
            model.setBanjie(false);
            try {
                OfficeDoneInfo officeDoneInfo;
                boolean banjie;
                model.setReadTime(StringUtils.isNotBlank((CharSequence)cs.getReadTime()) ? sdf.format(sdf.parse(cs.getReadTime())) : "--");
                model.setCreateTime(sdf.format(sdf.parse(cs.getCreateTime())));
                ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                model.setNumber(processParam.getCustomNumber());
                model.setLevel(processParam.getCustomLevel());
                model.setProcessSerialNumber(processParam.getProcessSerialNumber());
                HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
                boolean bl = banjie = hpi == null || hpi.getEndTime() != null;
                if (banjie) {
                    model.setBanjie(true);
                }
                model.setProcessDefinitionId((officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId)) != null ? officeDoneInfo.getProcessDefinitionId() : "");
                int countFollow = this.officeFollowService.countByProcessInstanceId(processInstanceId);
                model.setFollow(countFollow > 0);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6284\u9001\u5217\u8868\u5931\u8d25", (Throwable)e);
            }
            ++num;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    public Y9Page<ChaoSongModel> searchAllList(String searchName, String itemId, String senderName, String userName, String state, String year, Integer page, Integer rows) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<ChaoSongModel> list = new ArrayList<ChaoSongModel>();
        if (page < 1) {
            page = 1;
        }
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)rows, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"});
        Criteria criteria = new Criteria("tenantId").is((Object)Y9LoginUserHolder.getTenantId());
        if (StringUtils.isNotBlank((CharSequence)searchName)) {
            criteria.subCriteria(new Criteria("title").contains(searchName));
        }
        if (StringUtils.isNotBlank((CharSequence)itemId)) {
            criteria.subCriteria(new Criteria("itemId").is((Object)itemId));
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            criteria.subCriteria(new Criteria("userName").contains(userName));
        }
        if (StringUtils.isNotBlank((CharSequence)senderName)) {
            criteria.subCriteria(new Criteria("senderName").contains(senderName));
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            criteria.subCriteria(new Criteria("status").is((Object)Integer.parseInt(state)));
        }
        if (StringUtils.isNotBlank((CharSequence)year)) {
            criteria.subCriteria(new Criteria("createTime").contains(year));
        }
        Query query = new CriteriaQuery(criteria).setPageable((Pageable)pageable);
        query.setTrackTotalHits(Boolean.valueOf(true));
        IndexCoordinates index = IndexCoordinates.of((String[])new String[]{"y9_chaosonginfo"});
        SearchHits searchHits = this.elasticsearchTemplate.search(query, ChaoSongInfo.class, index);
        List list0 = searchHits.stream().map(SearchHit::getContent).collect(Collectors.toList());
        PageImpl pageList = new PageImpl(list0, (Pageable)pageable, searchHits.getTotalHits());
        List csList = pageList.getContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        int num = (page - 1) * rows;
        for (ChaoSongInfo cs : csList) {
            ChaoSongModel model = new ChaoSongModel();
            Y9BeanUtil.copyProperties((Object)cs, (Object)model);
            String processInstanceId = cs.getProcessInstanceId();
            model.setSerialNumber(num + 1);
            model.setId(cs.getId());
            model.setProcessInstanceId(processInstanceId);
            model.setSenderName(cs.getSenderName());
            model.setSendDeptName(cs.getSendDeptName());
            model.setTitle(cs.getTitle());
            model.setStatus(cs.getStatus());
            model.setItemId(cs.getItemId());
            model.setItemName(cs.getItemName());
            model.setBanjie(false);
            model.setUserName(cs.getUserName());
            model.setUserDeptName(cs.getUserDeptName());
            try {
                OfficeDoneInfo officeDoneInfo;
                boolean banjie;
                model.setReadTime(StringUtils.isNotBlank((CharSequence)cs.getReadTime()) ? sdf.format(sdf.parse(cs.getReadTime())) : "--");
                model.setCreateTime(sdf.format(sdf.parse(cs.getCreateTime())));
                ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                model.setNumber(processParam.getCustomNumber());
                model.setLevel(processParam.getCustomLevel());
                model.setProcessSerialNumber(processParam.getProcessSerialNumber());
                HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
                boolean bl = banjie = hpi == null || hpi.getEndTime() != null;
                if (banjie) {
                    model.setBanjie(true);
                }
                model.setProcessDefinitionId((officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId)) != null ? officeDoneInfo.getProcessDefinitionId() : "");
                int countFollow = this.officeFollowService.countByProcessInstanceId(processInstanceId);
                model.setFollow(countFollow > 0);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6284\u9001\u5217\u8868\u5931\u8d25", (Throwable)e);
            }
            ++num;
            list.add(model);
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    @Override
    @Transactional
    public void updateTitle(String processInstanceId, String documentTitle) {
        String string = processInstanceId;
        String string2 = documentTitle;
        Object[] objectArray = new Object[]{this, string, string2};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new ChaoSongInfoServiceImpl$AjcClosure7(objectArray), ajc$tjp_3);
    }

    @Generated
    public ChaoSongInfoServiceImpl(ChaoSongInfoRepository chaoSongInfoRepository, DocumentService documentService, ProcessParamService processParamService, TaskApi taskManager, HistoricProcessApi historicProcessManager, OrganizationApi organizationManager, PositionApi positionApi, OrgUnitApi orgUnitApi, SmsHttpApi smsHttpManager, OfficeDoneInfoService officeDoneInfoService, Y9Properties y9Conf, OfficeFollowService officeFollowService, AsyncHandleService asyncHandleService, ErrorLogService errorLogService, ElasticsearchTemplate elasticsearchTemplate, TodoTaskApi todoTaskManager, CustomGroupApi customGroupApi) {
        this.chaoSongInfoRepository = chaoSongInfoRepository;
        this.documentService = documentService;
        this.processParamService = processParamService;
        this.taskManager = taskManager;
        this.historicProcessManager = historicProcessManager;
        this.organizationManager = organizationManager;
        this.positionApi = positionApi;
        this.orgUnitApi = orgUnitApi;
        this.smsHttpManager = smsHttpManager;
        this.officeDoneInfoService = officeDoneInfoService;
        this.y9Conf = y9Conf;
        this.officeFollowService = officeFollowService;
        this.asyncHandleService = asyncHandleService;
        this.errorLogService = errorLogService;
        this.elasticsearchTemplate = elasticsearchTemplate;
        this.todoTaskManager = todoTaskManager;
        this.customGroupApi = customGroupApi;
    }

    static {
        ChaoSongInfoServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ChaoSongInfoServiceImpl.class);
    }

    static final /* synthetic */ void changeChaoSongState_aroundBody0(ChaoSongInfoServiceImpl ajc$this, String id, String type) {
        String opinionState = "";
        if (ItemBoxTypeEnum.ADD.getValue().equals(type)) {
            opinionState = "1";
        }
        ChaoSongInfo chaoSongInfo = ajc$this.chaoSongInfoRepository.findById((Object)id).orElse(null);
        assert (chaoSongInfo != null);
        chaoSongInfo.setOpinionState(opinionState);
        ajc$this.chaoSongInfoRepository.save((Object)chaoSongInfo);
    }

    static final /* synthetic */ boolean deleteByProcessInstanceId_aroundBody2(ChaoSongInfoServiceImpl ajc$this, String processInstanceId) {
        ajc$this.chaoSongInfoRepository.deleteByProcessInstanceIdAndTenantId(processInstanceId, Y9LoginUserHolder.getTenantId());
        return true;
    }

    static final /* synthetic */ Y9Result save_aroundBody4(ChaoSongInfoServiceImpl ajc$this, String processInstanceId, String users, String isSendSms, String isShuMing, String smsContent, String smsPersonId) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String tenantId = Y9LoginUserHolder.getTenantId();
            String curruserId = Y9LoginUserHolder.getOrgUnitId();
            OrgUnit currOrgUnit = Y9LoginUserHolder.getOrgUnit();
            ProcessParam processParam = ajc$this.processParamService.findByProcessInstanceId(processInstanceId);
            String title = processParam.getTitle();
            String itemId = processParam.getItemId();
            String itemName = processParam.getItemName();
            String systemName = processParam.getSystemName();
            String[] orgUnitList = users.split(";");
            ArrayList<ChaoSongInfo> csList = new ArrayList<ChaoSongInfo>();
            ArrayList<String> userIdListAdd = new ArrayList<String>();
            for (String orgUnitStr : orgUnitList) {
                String[] orgUnitArr = orgUnitStr.split(":");
                Integer type = Integer.valueOf(orgUnitArr[0]);
                String orgUnitId = orgUnitArr[1];
                if (Objects.equals(ItemPermissionEnum.DEPARTMENT.getValue(), type)) {
                    List list = (List)ajc$this.positionApi.listByParentId(tenantId, orgUnitId).getData();
                    for (Position position : list) {
                        userIdListAdd.add(position.getId());
                    }
                    continue;
                }
                if (Objects.equals(ItemPermissionEnum.POSITION.getValue(), type)) {
                    userIdListAdd.add(orgUnitId);
                    continue;
                }
                if (!type.equals(ItemPermissionEnum.CUSTOMGROUP.getValue())) continue;
                List list0 = (List)ajc$this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, Y9LoginUserHolder.getPersonId(), orgUnitId, OrgTypeEnum.POSITION).getData();
                for (CustomGroupMember pTemp : list0) {
                    OrgUnit user = (OrgUnit)ajc$this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, pTemp.getMemberId()).getData();
                    if (user == null || !StringUtils.isNotBlank((CharSequence)user.getId())) continue;
                    userIdListAdd.add(user.getId());
                }
            }
            OrgUnit dept = (OrgUnit)ajc$this.orgUnitApi.getOrgUnit(tenantId, currOrgUnit.getParentId()).getData();
            if (null == dept || null == dept.getId()) {
                dept = (OrgUnit)ajc$this.organizationManager.get(tenantId, currOrgUnit.getParentId()).getData();
            }
            ArrayList mobile = new ArrayList();
            for (String userId : userIdListAdd) {
                OrgUnit orgUnit = (OrgUnit)ajc$this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
                ChaoSongInfo cs = new ChaoSongInfo();
                cs.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                cs.setCreateTime(sdf.format(new Date()));
                cs.setProcessInstanceId(processInstanceId);
                cs.setSenderId(curruserId);
                cs.setSenderName(currOrgUnit.getName());
                cs.setSendDeptId(dept.getId());
                cs.setSendDeptName(dept.getName());
                cs.setStatus(Integer.valueOf(2));
                cs.setTenantId(tenantId);
                cs.setTitle(title);
                cs.setUserId(orgUnit.getId());
                cs.setUserName(orgUnit.getName());
                OrgUnit department = (OrgUnit)ajc$this.orgUnitApi.getOrgUnit(tenantId, orgUnit.getParentId()).getData();
                cs.setUserDeptId(department.getId());
                cs.setUserDeptName(department.getName());
                cs.setItemId(itemId);
                cs.setItemName(itemName);
                csList.add(cs);
            }
            ajc$this.save(csList);
            ajc$this.asyncHandleService.saveChaoSong4Todo(tenantId, csList);
            if (StringUtils.isNotBlank((CharSequence)isSendSms) && "true".equals(isSendSms)) {
                smsContent = (String)smsContent + "--" + Y9LoginUserHolder.getUserInfo().getName();
                Boolean smsSwitch = ajc$this.y9Conf.getApp().getItemAdmin().getSmsSwitch();
                if (Boolean.TRUE.equals(smsSwitch)) {
                    ajc$this.smsHttpManager.sendSmsHttpList(tenantId, Y9LoginUserHolder.getPersonId(), mobile, (String)smsContent, systemName + "\u6284\u9001");
                } else {
                    LOGGER.info("*********************y9.app.itemAdmin.smsSwitch\u5f00\u5173\u672a\u6253\u5f00**********************************");
                }
            }
            ajc$this.asyncHandleService.weiXinRemind4ChaoSongInfo(tenantId, Y9LoginUserHolder.getPersonId(), processParam.getProcessSerialNumber(), csList);
            return Y9Result.successMsg((String)"\u6284\u9001\u6210\u529f");
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter print = new PrintWriter(result);
            e.printStackTrace(print);
            try {
                String msg = ((Object)result).toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(new Date());
                ErrorLog errorLog = new ErrorLog();
                errorLog.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                errorLog.setCreateTime(time);
                errorLog.setErrorFlag("saveChaoSong");
                errorLog.setErrorType("processInstanceError");
                errorLog.setExtendField("\u6284\u9001\u4fdd\u5b58\u5931\u8d25");
                errorLog.setProcessInstanceId(processInstanceId);
                errorLog.setTaskId("");
                errorLog.setText(msg);
                errorLog.setUpdateTime(time);
                ajc$this.errorLogService.saveErrorLog(errorLog);
            }
            catch (Exception e2) {
                LOGGER.error("\u4fdd\u5b58\u6284\u9001\u5931\u8d25\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Throwable)e2);
            }
            return Y9Result.failure((String)"\u6284\u9001\u5931\u8d25");
        }
    }

    static final /* synthetic */ void updateTitle_aroundBody6(ChaoSongInfoServiceImpl ajc$this, String processInstanceId, String documentTitle) {
        try {
            List list = ajc$this.chaoSongInfoRepository.findByProcessInstanceId(processInstanceId);
            ArrayList<ChaoSongInfo> newList = new ArrayList<ChaoSongInfo>();
            for (ChaoSongInfo info : list) {
                info.setTitle(documentTitle);
                newList.add(info);
            }
            if (!newList.isEmpty()) {
                ajc$this.chaoSongInfoRepository.saveAll(newList);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u6284\u9001\u6807\u9898\u5931\u8d25", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ChaoSongInfoServiceImpl.java", ChaoSongInfoServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "changeChaoSongState", "net.risesoft.service.impl.ChaoSongInfoServiceImpl", "java.lang.String:java.lang.String", "id:type", "", "void"), 123);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteByProcessInstanceId", "net.risesoft.service.impl.ChaoSongInfoServiceImpl", "java.lang.String", "processInstanceId", "", "boolean"), 202);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "net.risesoft.service.impl.ChaoSongInfoServiceImpl", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "processInstanceId:users:isSendSms:isShuMing:smsContent:smsPersonId", "", "net.risesoft.pojo.Y9Result"), 758);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTitle", "net.risesoft.service.impl.ChaoSongInfoServiceImpl", "java.lang.String:java.lang.String", "processInstanceId:documentTitle", "", "void"), 1034);
    }
}

