/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.kafka;

import java.util.HashMap;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.user.UserInfo;
import net.risesoft.service.ItemDataCopyService;
import net.risesoft.service.SyncYearTableService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class KafkaConsumer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConsumer.class);
    private final ItemDataCopyService itemDataCopyService;
    private final OrgUnitApi orgUnitApi;
    private final SyncYearTableService syncYearTableService;

    @KafkaListener(topics={"y9_dataCopy_message", "y9_dataCopy4System_message"})
    public void onMessage(ConsumerRecord<Integer, String> message) {
        String tenantId = "";
        try {
            String sourceTenantId;
            HashMap map;
            String msg = (String)message.value();
            String topic = message.topic();
            LOGGER.info("****************\u5f00\u59cb\u6d88\u8d39topic:{},value:{}******************", (Object)topic, (Object)msg);
            if (topic.equals("y9_dataCopy_message")) {
                String targetTenantId;
                map = Y9JsonUtil.readHashMap((String)msg);
                assert (map != null);
                sourceTenantId = (String)map.get("sourceTenantId");
                tenantId = targetTenantId = (String)map.get("targetTenantId");
                String itemId = (String)map.get("itemId");
                String personId = (String)map.get("personId");
                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(targetTenantId, personId).getData();
                UserInfo userInfo = new UserInfo();
                userInfo.setPersonId(orgUnit.getId());
                userInfo.setName(orgUnit.getName());
                userInfo.setTenantId(orgUnit.getTenantId());
                userInfo.setParentId(orgUnit.getParentId());
                Y9LoginUserHolder.setUserInfo((UserInfo)userInfo);
                this.itemDataCopyService.dataCopy(sourceTenantId, targetTenantId, itemId);
            } else if (topic.equals("y9_dataCopy4System_message")) {
                String targetTenantId;
                map = Y9JsonUtil.readHashMap((String)msg);
                assert (map != null);
                sourceTenantId = (String)map.get("sourceTenantId");
                tenantId = targetTenantId = (String)map.get("targetTenantId");
                String systemName = (String)map.get("systemName");
                String personId = (String)map.get("personId");
                OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(targetTenantId, personId).getData();
                UserInfo userInfo = new UserInfo();
                userInfo.setPersonId(orgUnit.getId());
                userInfo.setName(orgUnit.getName());
                userInfo.setTenantId(orgUnit.getTenantId());
                userInfo.setParentId(orgUnit.getParentId());
                Y9LoginUserHolder.setUserInfo((UserInfo)userInfo);
                this.itemDataCopyService.dataCopy4System(sourceTenantId, targetTenantId, systemName);
            }
            Integer key = (Integer)message.key();
            long offset = message.offset();
            int partition = message.partition();
            LOGGER.info("topic:{},value:{},key:{},offset:{},partition:{}", new Object[]{topic, msg, key, offset, partition});
            LOGGER.info("*****************************\u6d88\u8d39\u6210\u529f********************************");
        }
        catch (Exception e) {
            LOGGER.error("{}\u6d88\u8d39\u5931\u8d25", (Object)message.topic(), (Object)e);
        }
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            this.syncYearTableService.syncYearTable("");
        }
    }

    @Generated
    public KafkaConsumer(ItemDataCopyService itemDataCopyService, OrgUnitApi orgUnitApi, SyncYearTableService syncYearTableService) {
        this.itemDataCopyService = itemDataCopyService;
        this.orgUnitApi = orgUnitApi;
        this.syncYearTableService = syncYearTableService;
    }
}

