/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.sync;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.processadmin.HistoricTaskApi;
import net.risesoft.entity.ActRuDetail;
import net.risesoft.entity.ErrorLog;
import net.risesoft.entity.ProcessParam;
import net.risesoft.enums.DialectEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.processadmin.HistoricTaskInstanceModel;
import net.risesoft.nosql.elastic.entity.OfficeDoneInfo;
import net.risesoft.service.ActRuDetailService;
import net.risesoft.service.DataCenterService;
import net.risesoft.service.ErrorLogService;
import net.risesoft.service.OfficeDoneInfoService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.util.form.Y9FormDbMetaDataUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/datacenter"})
public class Sync2DataCenterController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Sync2DataCenterController.class);
    private final JdbcTemplate jdbcTemplate;
    private final DataCenterService dataCenterService;
    private final ErrorLogService errorLogService;
    private final ActRuDetailService actRuDetailService;
    private final ProcessParamService processParamService;
    private final HistoricTaskApi historicTaskManager;
    private final OrgUnitApi orgUnitApi;
    private final OfficeDoneInfoService officeDoneInfoService;

    public Sync2DataCenterController(@Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate, DataCenterService dataCenterService, ErrorLogService errorLogService, ActRuDetailService actRuDetailService, ProcessParamService processParamService, HistoricTaskApi historicTaskManager, OrgUnitApi orgUnitApi, OfficeDoneInfoService officeDoneInfoService) {
        this.jdbcTemplate = jdbcTemplate;
        this.dataCenterService = dataCenterService;
        this.errorLogService = errorLogService;
        this.actRuDetailService = actRuDetailService;
        this.processParamService = processParamService;
        this.historicTaskManager = historicTaskManager;
        this.orgUnitApi = orgUnitApi;
        this.officeDoneInfoService = officeDoneInfoService;
    }

    @RequestMapping(value={"/tongbu2DataCenter"})
    public void tongbu2DataCenter(String tenantId, HttpServletResponse response) {
        HashMap<String, Integer> resMap = new HashMap<String, Integer>(16);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Y9LoginUserHolder.setTenantId((String)tenantId);
            String sql = "SELECT   P .PROC_INST_ID_,  TO_CHAR(P .START_TIME_,'yyyy-MM-dd HH:mi:ss') as START_TIME_,  P .PROC_DEF_ID_ FROM  ACT_HI_PROCINST P WHERE   P .END_TIME_ IS NULL AND P .DELETE_REASON_ IS NULL ORDER BY  P .START_TIME_ DESC";
            DataSource dataSource = this.jdbcTemplate.getDataSource();
            assert (dataSource != null);
            String dialectName = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
            if (DialectEnum.MYSQL.getValue().equals(dialectName)) {
                sql = "SELECT  P .PROC_INST_ID_,  SUBSTRING(P.START_TIME_,1,19) as START_TIME_,  P .PROC_DEF_ID_ FROM  ACT_HI_PROCINST_2023 P WHERE   P .END_TIME_ IS NOT NULL AND P .DELETE_REASON_ IS NULL ORDER BY  P .START_TIME_ DESC";
            }
            List list = this.jdbcTemplate.queryForList(sql);
            LOGGER.info("*********************\u5171{}\u6761\u6570\u636e***************************", (Object)list.size());
            int i = 0;
            String processInstanceId = "";
            for (Map map : list) {
                try {
                    processInstanceId = (String)map.get("PROC_INST_ID_");
                    String processDefinitionId = (String)map.get("PROC_DEF_ID_");
                    this.dataCenterService.saveToDateCenter1(processInstanceId, processDefinitionId);
                }
                catch (Exception e) {
                    ++i;
                    StringWriter result = new StringWriter();
                    PrintWriter print = new PrintWriter(result);
                    e.printStackTrace(print);
                    String msg = ((Object)result).toString();
                    String time = sdf.format(new Date());
                    ErrorLog errorLogModel = new ErrorLog();
                    errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    errorLogModel.setCreateTime(time);
                    errorLogModel.setErrorFlag("saveOfficeDone");
                    errorLogModel.setErrorType("processInstanceError");
                    errorLogModel.setExtendField("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3");
                    errorLogModel.setProcessInstanceId(processInstanceId);
                    errorLogModel.setTaskId("");
                    errorLogModel.setText(msg);
                    errorLogModel.setUpdateTime(time);
                    try {
                        this.errorLogService.saveErrorLog(errorLogModel);
                    }
                    catch (Exception e1) {
                        LOGGER.error("\u4fdd\u5b58\u9519\u8bef\u65e5\u5fd7\u5931\u8d25", (Throwable)e1);
                    }
                    LOGGER.error("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
                }
            }
            LOGGER.info("********************\u540c\u6b65\u5931\u8d25{}\u6761\u6570\u636e***************************", (Object)i);
            resMap.put("\u603b\u6570", list.size());
            resMap.put("\u540c\u6b65\u5931\u8d25", i);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
        }
        Y9Util.renderJson((HttpServletResponse)response, (String)Y9JsonUtil.writeValueAsString(resMap));
    }

    @RequestMapping(value={"/tongbuActRuDetail"})
    public void tongbuActRuDetail(String tenantId, String year, HttpServletResponse response) {
        HashMap<String, Integer> resMap = new HashMap<String, Integer>(16);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Y9LoginUserHolder.setTenantId((String)tenantId);
            Object sql = "SELECT   P .PROC_INST_ID_,  TO_CHAR(P .START_TIME_,'yyyy-MM-dd HH:mi:ss') as START_TIME_,  P .PROC_DEF_ID_ FROM  ACT_HI_PROCINST P WHERE   P .END_TIME_ IS NULL AND P .DELETE_REASON_ IS NULL ORDER BY  P .START_TIME_ DESC";
            DataSource dataSource = this.jdbcTemplate.getDataSource();
            assert (dataSource != null);
            String dialectName = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
            if (DialectEnum.MYSQL.getValue().equals(dialectName)) {
                sql = "SELECT  P .PROC_INST_ID_, SUBSTRING(P.START_TIME_,1,19) as START_TIME_,  P .PROC_DEF_ID_ FROM  ACT_HI_PROCINST_" + year + " P WHERE P .END_TIME_ IS NOT NULL AND P .DELETE_REASON_ IS NULL ORDER BY P .START_TIME_ DESC";
            }
            List list = this.jdbcTemplate.queryForList((String)sql);
            LOGGER.info("*********************\u5171{}\u6761\u6570\u636e***************************", (Object)list.size());
            int i = 0;
            String processInstanceId = "";
            for (Map map : list) {
                try {
                    processInstanceId = (String)map.get("PROC_INST_ID_");
                    List htiList = (List)this.historicTaskManager.findTaskByProcessInstanceIdOrByEndTimeAsc(tenantId, processInstanceId, year).getData();
                    for (HistoricTaskInstanceModel hti : htiList) {
                        OrgUnit user;
                        ActRuDetail newActRuDetail = new ActRuDetail();
                        String assignee = hti.getAssignee();
                        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                        String systemName = processParam.getSystemName();
                        if (!StringUtils.isNotBlank((CharSequence)assignee)) continue;
                        String owner = hti.getOwner();
                        if (StringUtils.isNotBlank((CharSequence)owner)) {
                            newActRuDetail.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                            newActRuDetail.setProcessSerialNumber(processParam.getProcessSerialNumber());
                            newActRuDetail.setAssignee(owner);
                            user = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, owner).getData();
                            newActRuDetail.setAssigneeName(user.getName());
                            newActRuDetail.setDeptId(user.getParentId());
                            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, user.getParentId()).getData();
                            newActRuDetail.setDeptName(orgUnit.getName());
                            newActRuDetail.setCreateTime(hti.getStartTime());
                            newActRuDetail.setLastTime(hti.getEndTime());
                            newActRuDetail.setProcessDefinitionKey(hti.getProcessDefinitionId().split(":")[0]);
                            newActRuDetail.setSystemName(processParam.getSystemName());
                            newActRuDetail.setStatus(Integer.valueOf(1));
                            newActRuDetail.setTaskId(hti.getId());
                            newActRuDetail.setStarted(true);
                            newActRuDetail.setEnded(true);
                            newActRuDetail.setStartTime(map.get("START_TIME_").toString());
                            newActRuDetail.setItemId(processParam.getItemId());
                            newActRuDetail.setProcessInstanceId(hti.getProcessInstanceId());
                            newActRuDetail.setItemId(processParam.getItemId());
                            newActRuDetail.setSystemName(systemName);
                            this.actRuDetailService.saveOrUpdate(newActRuDetail);
                        }
                        newActRuDetail = new ActRuDetail();
                        newActRuDetail.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                        newActRuDetail.setProcessSerialNumber(processParam.getProcessSerialNumber());
                        newActRuDetail.setAssignee(assignee);
                        user = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
                        newActRuDetail.setAssigneeName(user.getName());
                        newActRuDetail.setDeptId(user.getParentId());
                        OrgUnit orgUnit1 = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, user.getParentId()).getData();
                        newActRuDetail.setDeptName(orgUnit1.getName());
                        newActRuDetail.setCreateTime(hti.getStartTime());
                        newActRuDetail.setLastTime(hti.getEndTime());
                        newActRuDetail.setProcessDefinitionKey(hti.getProcessDefinitionId().split(":")[0]);
                        newActRuDetail.setSystemName(processParam.getSystemName());
                        newActRuDetail.setStatus(Integer.valueOf(1));
                        newActRuDetail.setTaskId(hti.getId());
                        newActRuDetail.setStarted(true);
                        newActRuDetail.setEnded(true);
                        newActRuDetail.setStartTime(map.get("START_TIME_").toString());
                        newActRuDetail.setItemId(processParam.getItemId());
                        newActRuDetail.setProcessInstanceId(hti.getProcessInstanceId());
                        newActRuDetail.setItemId(processParam.getItemId());
                        newActRuDetail.setSystemName(systemName);
                        this.actRuDetailService.saveOrUpdate(newActRuDetail);
                    }
                }
                catch (Exception e) {
                    ++i;
                    StringWriter result = new StringWriter();
                    PrintWriter print = new PrintWriter(result);
                    e.printStackTrace(print);
                    String msg = ((Object)result).toString();
                    String time = sdf.format(new Date());
                    ErrorLog errorLogModel = new ErrorLog();
                    errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    errorLogModel.setCreateTime(time);
                    errorLogModel.setErrorFlag("saveOfficeDone");
                    errorLogModel.setErrorType("processInstanceError");
                    errorLogModel.setExtendField("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3");
                    errorLogModel.setProcessInstanceId(processInstanceId);
                    errorLogModel.setTaskId("");
                    errorLogModel.setText(msg);
                    errorLogModel.setUpdateTime(time);
                    try {
                        this.errorLogService.saveErrorLog(errorLogModel);
                    }
                    catch (Exception e1) {
                        LOGGER.error("\u4fdd\u5b58\u9519\u8bef\u65e5\u5fd7\u5931\u8d25", (Throwable)e1);
                    }
                    LOGGER.error("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
                }
            }
            LOGGER.info("********************\u540c\u6b65\u5931\u8d25{}\u6761\u6570\u636e***************************", (Object)i);
            resMap.put("\u603b\u6570", list.size());
            resMap.put("\u540c\u6b65\u5931\u8d25", i);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
        }
        Y9Util.renderJson((HttpServletResponse)response, (String)Y9JsonUtil.writeValueAsString(resMap));
    }

    @RequestMapping(value={"/tongbuActRuDetail1"})
    public void tongbuActRuDetail1(String tenantId, HttpServletResponse response) {
        HashMap<String, Integer> resMap = new HashMap<String, Integer>(16);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Y9LoginUserHolder.setTenantId((String)tenantId);
            String sql = "SELECT   P .PROC_INST_ID_,  TO_CHAR(P .START_TIME_,'yyyy-MM-dd HH:mi:ss') as START_TIME_,  P .PROC_DEF_ID_ FROM  ACT_HI_PROCINST P WHERE   P .END_TIME_ IS NULL AND P .DELETE_REASON_ IS NULL ORDER BY  P .START_TIME_ DESC";
            DataSource dataSource = this.jdbcTemplate.getDataSource();
            assert (dataSource != null);
            String dialectName = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
            if (DialectEnum.MYSQL.getValue().equals(dialectName)) {
                sql = "SELECT P .PROC_INST_ID_,  SUBSTRING(P.START_TIME_,1,19) as START_TIME_,  P .PROC_DEF_ID_ FROM  ACT_HI_PROCINST P WHERE P .DELETE_REASON_ IS NULL ORDER BY  P .START_TIME_ DESC";
            }
            List list = this.jdbcTemplate.queryForList(sql);
            LOGGER.info("*********************\u5171{}\u6761\u6570\u636e***************************", (Object)list.size());
            int i = 0;
            String processInstanceId = "";
            for (Map map : list) {
                try {
                    processInstanceId = (String)map.get("PROC_INST_ID_");
                    List htiList = (List)this.historicTaskManager.findTaskByProcessInstanceIdOrderByStartTimeAsc(tenantId, processInstanceId, "").getData();
                    for (HistoricTaskInstanceModel hti : htiList) {
                        OrgUnit user;
                        ActRuDetail newActRuDetail = new ActRuDetail();
                        String assignee = hti.getAssignee();
                        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                        String systemName = processParam.getSystemName();
                        if (!StringUtils.isNotBlank((CharSequence)assignee)) continue;
                        String owner = hti.getOwner();
                        if (StringUtils.isNotBlank((CharSequence)owner)) {
                            newActRuDetail.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                            newActRuDetail.setProcessSerialNumber(processParam.getProcessSerialNumber());
                            newActRuDetail.setAssignee(owner);
                            user = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, owner).getData();
                            newActRuDetail.setAssigneeName(user.getName());
                            newActRuDetail.setDeptId(user.getParentId());
                            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, user.getParentId()).getData();
                            newActRuDetail.setDeptName(orgUnit.getName());
                            newActRuDetail.setCreateTime(hti.getStartTime());
                            newActRuDetail.setLastTime(hti.getEndTime());
                            newActRuDetail.setProcessDefinitionKey(hti.getProcessDefinitionId().split(":")[0]);
                            newActRuDetail.setSystemName(processParam.getSystemName());
                            newActRuDetail.setStatus(Integer.valueOf(1));
                            newActRuDetail.setTaskId(hti.getId());
                            newActRuDetail.setStarted(true);
                            newActRuDetail.setEnded(false);
                            newActRuDetail.setStartTime(map.get("START_TIME_").toString());
                            newActRuDetail.setItemId(processParam.getItemId());
                            newActRuDetail.setProcessInstanceId(hti.getProcessInstanceId());
                            newActRuDetail.setItemId(processParam.getItemId());
                            newActRuDetail.setSystemName(systemName);
                            this.actRuDetailService.saveOrUpdate(newActRuDetail);
                        }
                        newActRuDetail = new ActRuDetail();
                        newActRuDetail.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                        newActRuDetail.setProcessSerialNumber(processParam.getProcessSerialNumber());
                        newActRuDetail.setAssignee(assignee);
                        user = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData();
                        newActRuDetail.setAssigneeName(user.getName());
                        newActRuDetail.setDeptId(user.getParentId());
                        OrgUnit orgUnit1 = (OrgUnit)this.orgUnitApi.getOrgUnit(tenantId, user.getParentId()).getData();
                        newActRuDetail.setDeptName(orgUnit1.getName());
                        newActRuDetail.setCreateTime(hti.getStartTime());
                        newActRuDetail.setLastTime(hti.getEndTime());
                        newActRuDetail.setProcessDefinitionKey(hti.getProcessDefinitionId().split(":")[0]);
                        newActRuDetail.setSystemName(processParam.getSystemName());
                        newActRuDetail.setStatus(Integer.valueOf(hti.getEndTime() == null ? 0 : 1));
                        newActRuDetail.setTaskId(hti.getId());
                        newActRuDetail.setStarted(true);
                        newActRuDetail.setEnded(false);
                        newActRuDetail.setStartTime(map.get("START_TIME_").toString());
                        newActRuDetail.setItemId(processParam.getItemId());
                        newActRuDetail.setProcessInstanceId(hti.getProcessInstanceId());
                        newActRuDetail.setItemId(processParam.getItemId());
                        newActRuDetail.setSystemName(systemName);
                        this.actRuDetailService.saveOrUpdate(newActRuDetail);
                    }
                }
                catch (Exception e) {
                    ++i;
                    StringWriter result = new StringWriter();
                    PrintWriter print = new PrintWriter(result);
                    e.printStackTrace(print);
                    String msg = ((Object)result).toString();
                    String time = sdf.format(new Date());
                    ErrorLog errorLogModel = new ErrorLog();
                    errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    errorLogModel.setCreateTime(time);
                    errorLogModel.setErrorFlag("saveOfficeDone");
                    errorLogModel.setErrorType("processInstanceError");
                    errorLogModel.setExtendField("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3");
                    errorLogModel.setProcessInstanceId(processInstanceId);
                    errorLogModel.setTaskId("");
                    errorLogModel.setText(msg);
                    errorLogModel.setUpdateTime(time);
                    try {
                        this.errorLogService.saveErrorLog(errorLogModel);
                    }
                    catch (Exception e1) {
                        LOGGER.error("\u4fdd\u5b58\u9519\u8bef\u65e5\u5fd7\u5931\u8d25", (Throwable)e1);
                    }
                    LOGGER.error("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
                }
            }
            LOGGER.info("********************\u540c\u6b65\u5931\u8d25{}\u6761\u6570\u636e***************************", (Object)i);
            resMap.put("\u603b\u6570", list.size());
            resMap.put("\u540c\u6b65\u5931\u8d25", i);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
        }
        Y9Util.renderJson((HttpServletResponse)response, (String)Y9JsonUtil.writeValueAsString(resMap));
    }

    @RequestMapping(value={"/tongbuActRuDetailStartTime"})
    public void tongbuActRuDetailStartTime(String tenantId, HttpServletResponse response) {
        HashMap<String, Integer> resMap = new HashMap<String, Integer>(16);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Y9LoginUserHolder.setTenantId((String)tenantId);
            Object sql = "SELECT P.PROCESSINSTANCEID FROM  FF_ACT_RU_DETAIL P group by P.PROCESSINSTANCEID";
            List list = this.jdbcTemplate.queryForList((String)sql);
            LOGGER.info("*********************\u5171{}\u6761\u6570\u636e***************************", (Object)list.size());
            int i = 0;
            String processInstanceId = "";
            for (Map map : list) {
                try {
                    processInstanceId = (String)map.get("PROCESSINSTANCEID");
                    OfficeDoneInfo info = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
                    if (info == null) continue;
                    sql = "update FF_ACT_RU_DETAIL set STARTTIME = '" + info.getStartTime() + "' where PROCESSINSTANCEID = '" + processInstanceId + "'";
                    this.jdbcTemplate.execute((String)sql);
                }
                catch (Exception e) {
                    ++i;
                    StringWriter result = new StringWriter();
                    PrintWriter print = new PrintWriter(result);
                    e.printStackTrace(print);
                    String msg = ((Object)result).toString();
                    String time = sdf.format(new Date());
                    ErrorLog errorLogModel = new ErrorLog();
                    errorLogModel.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    errorLogModel.setCreateTime(time);
                    errorLogModel.setErrorFlag("saveOfficeDone");
                    errorLogModel.setErrorType("processInstanceError");
                    errorLogModel.setExtendField("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3");
                    errorLogModel.setProcessInstanceId(processInstanceId);
                    errorLogModel.setTaskId("");
                    errorLogModel.setText(msg);
                    errorLogModel.setUpdateTime(time);
                    try {
                        this.errorLogService.saveErrorLog(errorLogModel);
                    }
                    catch (Exception e1) {
                        LOGGER.error("\u4fdd\u5b58\u9519\u8bef\u65e5\u5fd7\u5931\u8d25", (Throwable)e1);
                    }
                    LOGGER.error("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
                }
            }
            LOGGER.info("********************\u540c\u6b65\u5931\u8d25{}\u6761\u6570\u636e***************************", (Object)i);
            resMap.put("\u603b\u6570", list.size());
            resMap.put("\u540c\u6b65\u5931\u8d25", i);
        }
        catch (Exception e) {
            LOGGER.error("\u540c\u6b65\u529e\u7ed3\u6570\u636e\u5230\u6570\u636e\u4e2d\u5fc3\u5931\u8d25", (Throwable)e);
        }
        Y9Util.renderJson((HttpServletResponse)response, (String)Y9JsonUtil.writeValueAsString(resMap));
    }
}

