/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.controller.vo.Y9FormItemBindVO;
import net.risesoft.controller.vo.Y9FormVO;
import net.risesoft.entity.ItemPrintTemplateBind;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.Y9FormItemMobileBind;
import net.risesoft.entity.form.Y9Form;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.form.Y9FormRepository;
import net.risesoft.repository.jpa.Y9FormItemMobileBindRepository;
import net.risesoft.service.PrintTemplateService;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/y9form/item"}, produces={"application/json"})
public class Y9FormItemBindRestController {
    private final Y9FormItemBindService y9FormItemBindService;
    private final Y9FormItemMobileBindRepository y9FormItemMobileBindRepository;
    private final SpmApproveItemService spmApproveItemService;
    private final RepositoryApi repositoryManager;
    private final ProcessDefinitionApi processDefinitionManager;
    private final Y9FormRepository y9FormRepository;
    private final PrintTemplateService printTemplateService;

    @GetMapping(value={"/bindList"})
    public Y9Result<List<Y9FormItemBind>> bindList(@RequestParam String itemId, @RequestParam String procDefId, @RequestParam(required=false) String taskDefKey) {
        List<Y9FormItemBind> eformItemList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey4Own(itemId, procDefId, taskDefKey);
        Iterator<Y9FormItemBind> iterator = eformItemList.iterator();
        while (iterator.hasNext()) {
            Y9FormItemBind bind;
            Y9Form form = this.y9FormRepository.findById((Object)(bind = iterator.next()).getFormId()).orElse(null);
            bind.setFormName(form != null ? form.getFormName() : "\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return Y9Result.success(eformItemList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/copyForm"})
    public Y9Result<String> copyForm(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.y9FormItemBindService.copyEform(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @PostMapping(value={"/deleteBind"})
    public Y9Result<String> delete(@RequestParam String id) {
        return this.y9FormItemBindService.delete(id);
    }

    @PostMapping(value={"/deleteMobileBind"})
    public Y9Result<String> deleteMobileBind(@RequestParam String id) {
        this.y9FormItemMobileBindRepository.deleteById((Object)id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/formList"})
    public Y9Result<List<Y9FormVO>> formList(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey, @RequestParam String systemName) {
        ArrayList<Y9FormVO> listMap = new ArrayList<Y9FormVO>();
        List list = this.y9FormRepository.findBySystemNameAndFormNameLike(systemName, "%%");
        List<Y9FormItemBind> bindList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey4Own(itemId, processDefinitionId, taskDefKey);
        for (Y9Form y9Form : list) {
            boolean isbind = false;
            for (Y9FormItemBind bind : bindList) {
                if (!bind.getFormId().equals(y9Form.getId())) continue;
                isbind = true;
                break;
            }
            if (isbind) continue;
            Y9FormVO form = new Y9FormVO();
            form.setFormId(y9Form.getId());
            form.setFormName(y9Form.getFormName());
            listMap.add(form);
        }
        return Y9Result.success(listMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindForm"})
    public Y9Result<Y9FormItemBind> getBindForm(@RequestParam(required=false) String id, @RequestParam String procDefId) {
        Y9FormItemBind eformItemBind;
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            Y9Form form = this.y9FormRepository.findById((Object)(eformItemBind = this.y9FormItemBindService.getById(id)).getFormId()).orElse(null);
            eformItemBind.setFormName(form != null ? form.getFormName() : "\u8868\u5355\u4e0d\u5b58\u5728");
        } else {
            id = Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE);
            eformItemBind = new Y9FormItemBind();
            eformItemBind.setId(id);
            eformItemBind.setProcessDefinitionId(procDefId);
        }
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryManager.getProcessDefinitionById(tenantId, procDefId).getData();
        eformItemBind.setProcDefName(processDefinition.getName());
        return Y9Result.success((Object)eformItemBind, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<Y9FormItemBindVO>> getBpmList(@RequestParam String processDefinitionId, @RequestParam String itemId) {
        ArrayList<Y9FormItemBindVO> list = new ArrayList<Y9FormItemBindVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List targetModelList = (List)this.processDefinitionManager.getNodes(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
        for (TargetModel targetModel : targetModelList) {
            String formName;
            Y9Form form;
            String formId;
            Y9FormItemBindVO map = new Y9FormItemBindVO();
            String eformNames = "";
            String mobileFormName = "";
            List<Y9FormItemBind> pcBindList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey4Own(itemId, processDefinitionId, targetModel.getTaskDefKey());
            List<Y9FormItemMobileBind> mobileBindList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey4OwnMobile(itemId, processDefinitionId, targetModel.getTaskDefKey());
            for (Y9FormItemBind eib : pcBindList) {
                formId = eib.getFormId();
                form = this.y9FormRepository.findById((Object)formId).orElse(null);
                formName = form != null ? form.getFormName() : "\u8868\u5355\u4e0d\u5b58\u5728";
                eformNames = Y9Util.genCustomStr((String)eformNames, (String)formName);
            }
            if (!mobileBindList.isEmpty()) {
                for (Y9FormItemMobileBind mobileBind : mobileBindList) {
                    formId = mobileBind.getFormId();
                    form = this.y9FormRepository.findById((Object)formId).orElse(null);
                    formName = form != null ? form.getFormName() : "\u8868\u5355\u4e0d\u5b58\u5728";
                    mobileFormName = Y9Util.genCustomStr((String)mobileFormName, (String)formName);
                }
            }
            map.setTaskDefName(targetModel.getTaskDefName());
            map.setEformNames(eformNames);
            map.setMobileFormName(mobileFormName);
            map.setTaskDefKey(targetModel.getTaskDefKey());
            list.add(map);
        }
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getformList"})
    public Y9Result<List<Y9FormVO>> getformList(@RequestParam String systemName) {
        ArrayList<Y9FormVO> listMap = new ArrayList<Y9FormVO>();
        List list = this.y9FormRepository.findBySystemNameAndFormNameLike(systemName, "%%");
        for (Y9Form y9Form : list) {
            Y9FormVO form = new Y9FormVO();
            form.setFormName(y9Form.getFormName());
            form.setFormId(y9Form.getId());
            listMap.add(form);
        }
        return Y9Result.success(listMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getPrintFormList"})
    public Y9Result<List<Y9FormVO>> listFormByItemId(@RequestParam String itemId, @RequestParam(required=false) String formName) {
        ArrayList<Y9FormVO> listmap = new ArrayList<Y9FormVO>();
        SpmApproveItem spmApproveItem = this.spmApproveItemService.findById(itemId);
        List list = this.y9FormRepository.findBySystemNameAndFormNameLike(spmApproveItem.getSystemName(), (String)(StringUtils.isNotBlank((CharSequence)formName) ? "%" + formName + "%" : "%%"));
        List<ItemPrintTemplateBind> bindList = this.printTemplateService.listTemplateBindByItemId(itemId);
        ItemPrintTemplateBind itemPrintTemplateBind = !bindList.isEmpty() ? bindList.get(0) : null;
        for (Y9Form y9Form : list) {
            Y9FormVO form = new Y9FormVO();
            boolean isBind = itemPrintTemplateBind != null && itemPrintTemplateBind.getTemplateId().equals(y9Form.getId());
            if (isBind) continue;
            form.setFormName(y9Form.getFormName());
            form.setFormId(y9Form.getId());
            listmap.add(form);
        }
        return Y9Result.success(listmap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/mobileBindList"})
    public Y9Result<List<Y9FormItemMobileBind>> mobileBindList(@RequestParam String itemId, @RequestParam String procDefId, @RequestParam(required=false) String taskDefKey) {
        List<Y9FormItemMobileBind> eformItemList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey4OwnMobile(itemId, procDefId, taskDefKey);
        Iterator<Y9FormItemMobileBind> iterator = eformItemList.iterator();
        while (iterator.hasNext()) {
            Y9FormItemMobileBind bind;
            Y9Form form = this.y9FormRepository.findById((Object)(bind = iterator.next()).getFormId()).orElse(null);
            bind.setFormName(form != null ? form.getFormName() : "\u8868\u5355\u4e0d\u5b58\u5728");
        }
        return Y9Result.success(eformItemList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> save(Y9FormItemBind eformItem) {
        return this.y9FormItemBindService.save(eformItem);
    }

    @PostMapping(value={"/saveMobileBind"})
    public Y9Result<String> saveMobileBind(Y9FormItemMobileBind eformItem) {
        return this.y9FormItemBindService.save(eformItem);
    }

    @Generated
    public Y9FormItemBindRestController(Y9FormItemBindService y9FormItemBindService, Y9FormItemMobileBindRepository y9FormItemMobileBindRepository, SpmApproveItemService spmApproveItemService, RepositoryApi repositoryManager, ProcessDefinitionApi processDefinitionManager, Y9FormRepository y9FormRepository, PrintTemplateService printTemplateService) {
        this.y9FormItemBindService = y9FormItemBindService;
        this.y9FormItemMobileBindRepository = y9FormItemMobileBindRepository;
        this.spmApproveItemService = spmApproveItemService;
        this.repositoryManager = repositoryManager;
        this.processDefinitionManager = processDefinitionManager;
        this.y9FormRepository = y9FormRepository;
        this.printTemplateService = printTemplateService;
    }
}

