/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.entity.ItemInterfaceParamsBind;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.form.Y9FormField;
import net.risesoft.entity.form.Y9Table;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemInterfaceParamsBindRepository;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemInterfaceParamsBindService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.service.form.Y9FormFieldService;
import net.risesoft.service.form.Y9TableService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/interfaceParamsBind"}, produces={"application/json"})
public class ItemInterfaceParamsBindController {
    private final ItemInterfaceParamsBindService itemInterfaceParamsBindService;
    private final SpmApproveItemService spmApproveItemService;
    private final RepositoryApi repositoryApi;
    private final Y9FormItemBindService y9FormItemBindService;
    private final Y9FormFieldService y9FormFieldService;
    private final Y9TableService y9TableService;
    private final ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository;

    @GetMapping(value={"/getBindInfo"})
    public Y9Result<Map<String, Object>> getBindInfo(@RequestParam(required=false) String id, @RequestParam String itemId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        String tenantId = Y9LoginUserHolder.getTenantId();
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        String processDefineKey = item.getWorkflowGuid();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryApi.getLatestProcessDefinitionByKey(tenantId, processDefineKey).getData();
        List<Y9FormItemBind> formList = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKeyIsNull(itemId, processDefinition.getId());
        ArrayList<String> tableNameList = new ArrayList<String>();
        ArrayList<Y9Table> tableList = new ArrayList<Y9Table>();
        ArrayList tableField = new ArrayList();
        for (Y9FormItemBind bind : formList) {
            String formId = bind.getFormId();
            List<Y9FormField> formFieldList = this.y9FormFieldService.listByFormId(formId);
            for (Y9FormField formField : formFieldList) {
                if (tableNameList.contains(formField.getTableName())) continue;
                Y9Table y9Table = this.y9TableService.findById(formField.getTableId());
                tableNameList.add(formField.getTableName());
                tableList.add(y9Table);
                ArrayList<Y9FormField> fieldlist = new ArrayList<Y9FormField>();
                for (Y9FormField formField1 : formFieldList) {
                    if (!y9Table.getTableName().equals(formField1.getTableName())) continue;
                    fieldlist.add(formField1);
                }
                HashMap<String, Object> tableFieldMap = new HashMap<String, Object>();
                tableFieldMap.put("tableName", y9Table.getTableName());
                tableFieldMap.put("fieldlist", fieldlist);
                tableField.add(tableFieldMap);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ItemInterfaceParamsBind info = this.itemInterfaceParamsBindRepository.findById((Object)id).orElse(null);
            resMap.put("info", info);
        }
        resMap.put("tableList", tableList);
        resMap.put("tablefield", tableField);
        return Y9Result.success(resMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<ItemInterfaceParamsBind>> getBindList(@RequestParam String itemId, @RequestParam String interfaceId, @RequestParam String type) {
        List<ItemInterfaceParamsBind> list = this.itemInterfaceParamsBindService.listByItemIdAndInterfaceIdAndType(itemId, interfaceId, type);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeBind"})
    public Y9Result<String> removeBind(@RequestParam String id) {
        this.itemInterfaceParamsBindService.removeBind(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveBind"})
    public Y9Result<String> saveBind(ItemInterfaceParamsBind info) {
        this.itemInterfaceParamsBindService.saveBind(info);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public ItemInterfaceParamsBindController(ItemInterfaceParamsBindService itemInterfaceParamsBindService, SpmApproveItemService spmApproveItemService, RepositoryApi repositoryApi, Y9FormItemBindService y9FormItemBindService, Y9FormFieldService y9FormFieldService, Y9TableService y9TableService, ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository) {
        this.itemInterfaceParamsBindService = itemInterfaceParamsBindService;
        this.spmApproveItemService = spmApproveItemService;
        this.repositoryApi = repositoryApi;
        this.y9FormItemBindService = y9FormItemBindService;
        this.y9FormFieldService = y9FormFieldService;
        this.y9TableService = y9TableService;
        this.itemInterfaceParamsBindRepository = itemInterfaceParamsBindRepository;
    }
}

