/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.entity.TaoHongTemplateType;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.TaoHongTemplateTypeService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/taoHongTemplateType"}, produces={"application/json"})
public class TaoHongTemplateTypeRestController {
    private final TaoHongTemplateTypeService taoHongTemplateTypeService;
    private final OrgUnitApi orgUnitApi;

    @GetMapping(value={"/list"})
    public Y9Result<List<TaoHongTemplateType>> list() {
        List<TaoHongTemplateType> list;
        UserInfo person = Y9LoginUserHolder.getUserInfo();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String personId = person.getPersonId();
        if (person.isGlobalManager()) {
            list = this.taoHongTemplateTypeService.listAll();
        } else {
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getBureau(tenantId, personId).getData();
            list = this.taoHongTemplateTypeService.listByBureauId(orgUnit.getId());
        }
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/newOrModify"})
    public Y9Result<TaoHongTemplateType> newOrModify(@RequestParam String id) {
        TaoHongTemplateType t = this.taoHongTemplateTypeService.getById(id);
        return Y9Result.success((Object)t, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeTaoHongTemplateType"})
    public Y9Result<String> removeTaoHongTemplateType(@RequestParam String[] ids) {
        this.taoHongTemplateTypeService.removeTaoHongTemplateType(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(@RequestParam String[] idAndTabIndexs) {
        this.taoHongTemplateTypeService.saveOrder(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(TaoHongTemplateType t) {
        this.taoHongTemplateTypeService.saveOrUpdate(t);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public TaoHongTemplateTypeRestController(TaoHongTemplateTypeService taoHongTemplateTypeService, OrgUnitApi orgUnitApi) {
        this.taoHongTemplateTypeService = taoHongTemplateTypeService;
        this.orgUnitApi = orgUnitApi;
    }
}

