/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.api.platform.resource.AppApi;
import net.risesoft.api.platform.resource.SystemApi;
import net.risesoft.controller.vo.NodeTreeVO;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.enums.platform.RoleTypeEnum;
import net.risesoft.model.platform.App;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Role;
import net.risesoft.model.platform.System;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/role"}, produces={"application/json"})
public class RoleRestController {
    private final RoleApi roleManager;
    private final OrgUnitApi orgUnitManager;
    private final SystemApi systemEntityManager;
    private final AppApi appApi;

    @GetMapping(value={"/findRole"})
    public Y9Result<List<NodeTreeVO>> findAll(@RequestParam(required=false) String id) {
        ArrayList<NodeTreeVO> listMap;
        block7: {
            block6: {
                listMap = new ArrayList<NodeTreeVO>();
                if (!StringUtils.isBlank((CharSequence)id)) break block6;
                System system = (System)this.systemEntityManager.getByName(Y9Context.getSystemName()).getData();
                List appList = (List)this.appApi.listBySystemId(system.getId()).getData();
                for (App app : appList) {
                    NodeTreeVO map = new NodeTreeVO();
                    map.setId(app.getId());
                    map.setName(app.getName());
                    map.setParentId(app.getId());
                    map.setIsParent(true);
                    map.setOrgType("App");
                    listMap.add(map);
                }
                break block7;
            }
            List listRole = (List)this.roleManager.listRoleByParentId(id).getData();
            if (listRole == null) break block7;
            for (Role role : listRole) {
                NodeTreeVO map = new NodeTreeVO();
                map.setId(role.getId());
                map.setName(role.getName());
                map.setParentId(id);
                map.setGuidPath(role.getGuidPath());
                if (RoleTypeEnum.ROLE.equals((Object)role.getType())) {
                    map.setIsParent(false);
                    map.setOrgType("role");
                } else {
                    List list = (List)this.roleManager.listRoleByParentId(role.getId()).getData();
                    boolean isP = false;
                    if (list != null) {
                        boolean bl = isP = !list.isEmpty();
                    }
                    if (isP) {
                        map.setChkDisabled(true);
                    }
                    map.setIsParent(isP);
                    map.setOrgType("folder");
                }
                listMap.add(map);
            }
        }
        return Y9Result.success(listMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/findRoleMember"})
    public Y9Result<List<NodeTreeVO>> findRoleMember(@RequestParam String roleId) {
        ArrayList<NodeTreeVO> listMap = new ArrayList<NodeTreeVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.roleManager.listOrgUnitsById(tenantId, roleId, OrgTypeEnum.POSITION).getData();
        for (OrgUnit orgUnit : list) {
            NodeTreeVO map = new NodeTreeVO();
            map.setId(orgUnit.getId());
            map.setName(orgUnit.getName());
            map.setParentId(roleId);
            map.setGuidPath(orgUnit.getGuidPath());
            map.setOrgType(orgUnit.getOrgType().getValue());
            map.setIsParent(false);
            if (orgUnit.getOrgType().getValue().equals(OrgTypeEnum.DEPARTMENT.getValue()) || orgUnit.getOrgType().getValue().equals(OrgTypeEnum.GROUP.getValue())) {
                map.setIsParent(true);
            }
            listMap.add(map);
        }
        return Y9Result.success(listMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/findRoleMember1"})
    public Y9Result<List<NodeTreeVO>> findRoleMember1(@RequestParam(required=false) String roleId, @RequestParam(required=false) String id, @RequestParam(required=false) OrgTreeTypeEnum treeType) {
        ArrayList<NodeTreeVO> listMap = new ArrayList<NodeTreeVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)roleId) && StringUtils.isBlank((CharSequence)id)) {
            List list = (List)this.roleManager.listOrgUnitsById(tenantId, roleId, OrgTypeEnum.PERSON).getData();
            for (OrgUnit orgUnit : list) {
                NodeTreeVO map = new NodeTreeVO();
                map.setId(orgUnit.getId());
                map.setName(orgUnit.getName());
                map.setParentId(roleId);
                map.setGuidPath(orgUnit.getGuidPath());
                map.setOrgType(orgUnit.getOrgType().getValue());
                map.setIsParent(false);
                if (orgUnit.getOrgType().getValue().equals(OrgTypeEnum.DEPARTMENT.getValue()) || orgUnit.getOrgType().getValue().equals(OrgTypeEnum.GROUP.getValue())) {
                    map.setIsParent(true);
                }
                listMap.add(map);
            }
        } else {
            List list = (List)this.orgUnitManager.getSubTree(tenantId, id, treeType).getData();
            for (OrgUnit orgUnit : list) {
                NodeTreeVO map = new NodeTreeVO();
                map.setId(orgUnit.getId());
                map.setName(orgUnit.getName());
                map.setParentId(id);
                map.setGuidPath(orgUnit.getGuidPath());
                map.setOrgType(orgUnit.getOrgType().getValue());
                map.setIsParent(false);
                if (orgUnit.getOrgType().getValue().equals(OrgTypeEnum.DEPARTMENT.getValue()) || orgUnit.getOrgType().getValue().equals(OrgTypeEnum.GROUP.getValue())) {
                    map.setIsParent(true);
                }
                listMap.add(map);
            }
        }
        return Y9Result.success(listMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @Generated
    public RoleRestController(RoleApi roleManager, OrgUnitApi orgUnitManager, SystemApi systemEntityManager, AppApi appApi) {
        this.roleManager = roleManager;
        this.orgUnitManager = orgUnitManager;
        this.systemEntityManager = systemEntityManager;
        this.appApi = appApi;
    }
}

