/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.entity.ExtendedContent;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ExtendedContentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/extendedContent"}, produces={"application/json"})
public class ExtendedContentController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedContentController.class);
    private final ExtendedContentService extendedContentService;

    @RequestMapping(value={"/checkSignContent"})
    public Y9Result<Boolean> checkSignContent(@RequestParam(required=false) String category, @RequestParam(required=false) String processSerialNumber) {
        try {
            int count = this.extendedContentService.countByProcSerialNumberAndCategory(processSerialNumber, category);
            return Y9Result.success((Object)(count > 0 ? 1 : 0));
        }
        catch (Exception e) {
            LOGGER.error("\u662f\u5426\u586b\u5199\u5185\u5bb9", (Throwable)e);
            return Y9Result.failure((String)"\u662f\u5426\u586b\u5199\u5185\u5bb9");
        }
    }

    @RequestMapping(value={"/contentList"})
    public Y9Result<List<Map<String, Object>>> contentList(@RequestParam String processSerialNumber, @RequestParam String itembox, @RequestParam String taskId, @RequestParam String category) {
        List<Map<String, Object>> contentList = this.extendedContentService.listContents(processSerialNumber, taskId, itembox, category);
        return Y9Result.success(contentList);
    }

    @RequestMapping(value={"/delete"})
    public Y9Result<Object> delete(@RequestParam String id) {
        return this.extendedContentService.delete(id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<Object> saveOrUpdate(ExtendedContent content) {
        return this.extendedContentService.saveOrUpdate(content);
    }

    @Generated
    public ExtendedContentController(ExtendedContentService extendedContentService) {
        this.extendedContentService = extendedContentService;
    }
}

