/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.controller.vo.NodeTreeVO;
import net.risesoft.entity.Entrust;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.SpmApproveItemRepository;
import net.risesoft.service.EntrustService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/entrust"}, produces={"application/json"})
public class EntrustController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EntrustController.class);
    private final EntrustService entrustService;
    private final SpmApproveItemRepository spmApproveItemRepository;
    private final PersonApi personApi;
    private final DepartmentApi departmentApi;
    private final OrgUnitApi orgUnitManager;
    private final OrganizationApi organizationManager;

    @GetMapping(value={"/deptTreeSearch"})
    public Y9Result<List<NodeTreeVO>> deptTreeSearch(@RequestParam String name) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<NodeTreeVO> item = new ArrayList<NodeTreeVO>();
        List<OrgUnit> orgUnitList = new ArrayList();
        OrgUnit orgUnit = (OrgUnit)this.orgUnitManager.getBureau(tenantId, Y9LoginUserHolder.getPersonId()).getData();
        if (OrgTypeEnum.DEPARTMENT.equals((Object)orgUnit.getOrgType())) {
            List personList = (List)this.personApi.listRecursivelyByParentIdAndName(tenantId, orgUnit.getId(), name).getData();
            for (Person person : personList) {
                orgUnitList.add((OrgUnit)person);
                Person p = (Person)this.personApi.get(tenantId, person.getId()).getData();
                this.recursionUpToOrg(tenantId, orgUnit.getId(), p.getParentId(), orgUnitList, false);
            }
        } else {
            orgUnitList = (List)this.orgUnitManager.treeSearch(tenantId, name, OrgTreeTypeEnum.TREE_TYPE_PERSON).getData();
        }
        for (OrgUnit orgUnit0 : orgUnitList) {
            NodeTreeVO map = new NodeTreeVO();
            map.setId(orgUnit0.getId());
            map.setName(orgUnit0.getName());
            map.setOrgType(orgUnit0.getOrgType().getValue());
            map.setParentId(orgUnit0.getParentId());
            map.setIsParent(true);
            if (OrgTypeEnum.PERSON.equals((Object)orgUnit0.getOrgType())) {
                Person per = (Person)this.personApi.get(Y9LoginUserHolder.getTenantId(), orgUnit0.getId()).getData();
                map.setSex(per.getSex().getValue());
                map.setDuty(per.getDuty());
                map.setIsParent(false);
            }
            item.add(map);
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getDeptTree"})
    public Y9Result<List<NodeTreeVO>> getDeptTree(@RequestParam(required=false) String id) {
        OrgUnit orgUnit;
        ArrayList<NodeTreeVO> item = new ArrayList<NodeTreeVO>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isBlank((CharSequence)id) && (orgUnit = (OrgUnit)this.orgUnitManager.getBureau(tenantId, Y9LoginUserHolder.getPersonId()).getData()) != null && orgUnit.getId() != null) {
            NodeTreeVO map = new NodeTreeVO();
            id = orgUnit.getId();
            map.setId(id);
            map.setName(orgUnit.getName());
            map.setOrgType(orgUnit.getOrgType().getValue());
            map.setParentId(orgUnit.getParentId());
            map.setIsParent(true);
            item.add(map);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List orgList = (List)this.orgUnitManager.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_PERSON).getData();
            for (OrgUnit orgunit : orgList) {
                NodeTreeVO map = new NodeTreeVO();
                map.setId(orgunit.getId());
                map.setName(orgunit.getName());
                map.setOrgType(orgunit.getOrgType().getValue());
                map.setParentId(orgunit.getParentId());
                if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                    map.setIsParent(true);
                } else {
                    if (!OrgTypeEnum.PERSON.equals((Object)orgunit.getOrgType())) continue;
                    Person person = (Person)this.personApi.get(tenantId, orgunit.getId()).getData();
                    map.setSex(person.getSex().getValue());
                    map.setDuty(person.getDuty());
                    map.setIsParent(false);
                }
                item.add(map);
            }
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getEntrustInfo"})
    public Y9Result<Map<String, Object>> getEntrustInfo(String id) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            Entrust entrust = this.entrustService.getById(id);
            if (entrust.getItemId().equals("ALL")) {
                entrust.setItemName("\u6240\u6709\u4e8b\u9879");
            } else {
                SpmApproveItem item = this.spmApproveItemRepository.findById((Object)entrust.getItemId()).orElse(null);
                entrust.setItemName(item != null ? item.getName() : "\u4e8b\u9879\u4e0d\u5b58\u5728");
            }
            map.put("entrust", entrust);
        }
        List itemList = this.spmApproveItemRepository.findAll();
        ArrayList<SpmApproveItem> list = new ArrayList<SpmApproveItem>();
        Integer count = this.entrustService.getCountByOwnerIdAndItemId(Y9LoginUserHolder.getPersonId(), "ALL");
        if (count == 0) {
            SpmApproveItem item = new SpmApproveItem();
            item.setId("ALL");
            item.setName("\u6240\u6709\u4e8b\u9879");
            list.add(item);
        }
        for (SpmApproveItem item : itemList) {
            Integer count1 = this.entrustService.getCountByOwnerIdAndItemId(Y9LoginUserHolder.getPersonId(), item.getId());
            if (count1 != 0) continue;
            list.add(item);
        }
        map.put("itemList", list);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public OrgUnit getParent(String tenantId, String parentId) {
        Organization parent = (Organization)this.organizationManager.get(tenantId, parentId).getData();
        return parent.getId() != null ? parent : (OrgUnit)this.departmentApi.get(tenantId, parentId).getData();
    }

    @GetMapping(value={"/list"})
    public Y9Result<List<Entrust>> list() {
        UserInfo person = Y9LoginUserHolder.getUserInfo();
        List<Entrust> entrustList = this.entrustService.list(person.getPersonId());
        return Y9Result.success(entrustList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public void recursionUpToOrg(String tenantId, String nodeId, String parentId, List<OrgUnit> orgUnitList, boolean isParent) {
        OrgUnit parent = this.getParent(tenantId, parentId);
        if (isParent) {
            parent.setDescription("parent");
        }
        if (orgUnitList.isEmpty()) {
            orgUnitList.add(parent);
        } else {
            boolean add = true;
            for (OrgUnit orgUnit : orgUnitList) {
                if (!orgUnit.getId().equals(parent.getId())) continue;
                add = false;
                break;
            }
            if (add) {
                orgUnitList.add(parent);
            }
        }
        if (parent.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
            if (parent.getId().equals(nodeId)) {
                return;
            }
            this.recursionUpToOrg(tenantId, nodeId, parent.getParentId(), orgUnitList, true);
        }
    }

    @PostMapping(value={"/removeEntrust"})
    public Y9Result<String> removeEntrust(String id) {
        this.entrustService.removeEntrust(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(Entrust entrust) {
        try {
            this.entrustService.saveOrUpdate(entrust);
            return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Generated
    public EntrustController(EntrustService entrustService, SpmApproveItemRepository spmApproveItemRepository, PersonApi personApi, DepartmentApi departmentApi, OrgUnitApi orgUnitManager, OrganizationApi organizationManager) {
        this.entrustService = entrustService;
        this.spmApproveItemRepository = spmApproveItemRepository;
        this.personApi = personApi;
        this.departmentApi = departmentApi;
        this.orgUnitManager = orgUnitManager;
        this.organizationManager = organizationManager;
    }
}

