/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ItemDoingApi;
import net.risesoft.entity.ActRuDetail;
import net.risesoft.model.itemadmin.ActRuDetailModel;
import net.risesoft.model.itemadmin.ItemPage;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ActRuDetailService;
import net.risesoft.service.ItemPageService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/itemDoing"}, produces={"application/json"})
public class ItemDoingApiImpl
implements ItemDoingApi {
    private final ItemPageService itemPageService;
    private final ActRuDetailService actRuDetailService;

    public Y9Result<Integer> countByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int count = this.actRuDetailService.countBySystemNameAndAssigneeAndStatus(systemName, userId, 1);
        return Y9Result.success((Object)count);
    }

    public Y9Page<ActRuDetailModel> findBySystemName(@RequestParam String tenantId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String sql = "SELECT A.* FROM ( SELECT T.*, ROW_NUMBER() OVER (PARTITION BY T.PROCESSSERIALNUMBER) AS RS_NUM FROM FF_ACT_RU_DETAIL T WHERE T.STATUS = 0 AND T.DELETED = FALSE AND T.SYSTEMNAME = ? ORDER BY T.LASTTIME DESC) A WHERE A.RS_NUM=1";
        String countSql = "SELECT COUNT(DISTINCT T.PROCESSSERIALNUMBER) FROM FF_ACT_RU_DETAIL T WHERE T.SYSTEMNAME= ? AND T.STATUS=0 AND T.DELETED = FALSE ";
        Object[] args = new Object[]{systemName};
        ItemPage itemPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)itemPage.getCurrpage(), (int)itemPage.getTotalpages(), (long)itemPage.getTotal(), (List)itemPage.getRows());
    }

    public Y9Page<ActRuDetailModel> findByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"lastTime"});
        Page<ActRuDetail> ardPage = this.actRuDetailService.pageBySystemNameAndAssigneeAndStatus(systemName, userId, 1, rows, page, sort);
        List ardList = ardPage.getContent();
        ArrayList<ActRuDetailModel> modelList = new ArrayList<ActRuDetailModel>();
        for (ActRuDetail actRuDetail : ardList) {
            ActRuDetailModel actRuDetailModel = new ActRuDetailModel();
            Y9BeanUtil.copyProperties((Object)actRuDetail, (Object)actRuDetailModel);
            modelList.add(actRuDetailModel);
        }
        return Y9Page.success((int)page, (int)ardPage.getTotalPages(), (long)ardPage.getTotalElements(), modelList);
    }

    public Y9Page<ActRuDetailModel> searchBySystemName(@RequestParam String tenantId, @RequestParam String systemName, @RequestParam String tableName, @RequestBody String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String sql0 = "LEFT JOIN " + tableName.toUpperCase() + " F ON T.PROCESSSERIALNUMBER = F.GUID ";
        StringBuilder sql1 = new StringBuilder();
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        for (String columnName : searchMap.keySet()) {
            sql1.append("AND INSTR(F.").append(columnName.toUpperCase()).append(",'").append(searchMap.get(columnName).toString()).append("') > 0 ");
        }
        String orderBy = "T.LASTTIME DESC";
        String sql = "SELECT A.* FROM ( SELECT T.*, ROW_NUMBER() OVER (PARTITION BY T.PROCESSSERIALNUMBER) AS RS_NUM FROM FF_ACT_RU_DETAIL T " + sql0 + " WHERE T.STATUS = 0 AND T.DELETED = FALSE " + sql1 + " AND T.SYSTEMNAME = ?  ORDER BY " + orderBy + ") A WHERE A.RS_NUM=1";
        String countSql = "SELECT COUNT(DISTINCT T.PROCESSSERIALNUMBER) FROM FF_ACT_RU_DETAIL T " + sql0 + " WHERE T.SYSTEMNAME= ? AND T.STATUS=0 AND T.DELETED = FALSE " + sql1;
        Object[] args = new Object[]{systemName};
        ItemPage itemPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)itemPage.getCurrpage(), (int)itemPage.getTotalpages(), (long)itemPage.getTotal(), (List)itemPage.getRows());
    }

    public Y9Page<ActRuDetailModel> searchByUserIdAndSystemName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String systemName, @RequestParam String tableName, @RequestBody String searchMapStr, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String sql0 = "LEFT JOIN " + tableName.toUpperCase() + " F ON T.PROCESSSERIALNUMBER = F.GUID ";
        StringBuilder sql1 = new StringBuilder();
        HashMap searchMap = Y9JsonUtil.readHashMap((String)searchMapStr);
        assert (searchMap != null);
        for (String columnName : searchMap.keySet()) {
            sql1.append("AND INSTR(F.").append(columnName.toUpperCase()).append(",'").append(searchMap.get(columnName).toString()).append("') > 0 ");
        }
        String orderBy = "T.LASTTIME DESC";
        String sql = "SELECT T.* FROM FF_ACT_RU_DETAIL T " + sql0 + " WHERE T.STATUS = 1 AND T.ENDED = FALSE AND T.DELETED = FALSE " + sql1 + " AND T.SYSTEMNAME = ? AND T.ASSIGNEE = ? ORDER BY " + orderBy;
        String countSql = "SELECT COUNT(ID) FROM FF_ACT_RU_DETAIL T " + sql0 + " WHERE T.SYSTEMNAME= ? AND T.ASSIGNEE= ? AND T.STATUS=1 AND T.ENDED = FALSE AND T.DELETED = FALSE " + sql1;
        Object[] args = new Object[]{systemName, userId};
        ItemPage itemPage = this.itemPageService.page(sql, args, new BeanPropertyRowMapper(ActRuDetailModel.class), countSql, args, (int)page, (int)rows);
        return Y9Page.success((int)itemPage.getCurrpage(), (int)itemPage.getTotalpages(), (long)itemPage.getTotal(), (List)itemPage.getRows());
    }

    @Generated
    public ItemDoingApiImpl(ItemPageService itemPageService, ActRuDetailService actRuDetailService) {
        this.itemPageService = itemPageService;
        this.actRuDetailService = actRuDetailService;
    }
}

