/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.EntrustApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.entity.Entrust;
import net.risesoft.model.itemadmin.EntrustModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.EntrustService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/entrust"}, produces={"application/json"})
public class EntrustApiImpl
implements EntrustApi {
    private final EntrustService entrustService;
    private final OrgUnitApi orgUnitApi;

    public Y9Result<Object> deleteEntrust(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.entrustService.destroyEntrust(id);
        return Y9Result.success();
    }

    public Y9Result<List<EntrustModel>> getEntrustList(@RequestParam String tenantId, @RequestParam String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<EntrustModel> list = this.entrustService.listEntrustByUserId(orgUnitId);
        return Y9Result.success(list);
    }

    public Y9Result<List<EntrustModel>> getMyEntrustList(@RequestParam String tenantId, @RequestParam String orgUnitId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<EntrustModel> list = this.entrustService.listMyEntrust(orgUnitId);
        return Y9Result.success(list);
    }

    public Y9Result<Object> saveOrUpdate(@RequestParam String tenantId, @RequestParam String orgUnitId, @RequestBody EntrustModel entrustModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, orgUnitId).getData();
        Y9LoginUserHolder.setOrgUnit((OrgUnit)orgUnit);
        Entrust entrust = new Entrust();
        Y9BeanUtil.copyProperties((Object)entrustModel, (Object)entrust);
        this.entrustService.saveOrUpdate(entrust);
        return Y9Result.success();
    }

    @Generated
    public EntrustApiImpl(EntrustService entrustService, OrgUnitApi orgUnitApi) {
        this.entrustService = entrustService;
        this.orgUnitApi = orgUnitApi;
    }
}

