/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.CommonSentencesApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.CommonSentences;
import net.risesoft.model.itemadmin.CommonSentencesModel;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.CommonSentencesService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/commonSentences"}, produces={"application/json"})
public class CommonSentencesApiImpl
implements CommonSentencesApi {
    private final CommonSentencesService commonSentencesService;
    private final PersonApi personApi;

    public Y9Result<Object> delete(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.commonSentencesService.deleteById(id);
        return Y9Result.success();
    }

    public Y9Result<List<CommonSentencesModel>> listSentencesService(@RequestParam String tenantId, @RequestParam String userId) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        List<CommonSentences> list = this.commonSentencesService.listSentencesService();
        ArrayList<CommonSentencesModel> res_list = new ArrayList<CommonSentencesModel>();
        for (CommonSentences item : list) {
            CommonSentencesModel model = new CommonSentencesModel();
            Y9BeanUtil.copyProperties((Object)item, (Object)model);
            res_list.add(model);
        }
        return Y9Result.success(res_list);
    }

    public Y9Result<Object> removeCommonSentences(@RequestParam String tenantId, @RequestParam String userId, @RequestParam int tabIndex) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        this.commonSentencesService.removeCommonSentences(tabIndex);
        return Y9Result.success();
    }

    public Y9Result<Object> removeUseNumber(@RequestParam String tenantId, @RequestParam String userId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPersonId((String)userId);
        this.commonSentencesService.removeUseNumber();
        return Y9Result.success();
    }

    public Y9Result<Object> save(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String id, @RequestParam String content) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        this.commonSentencesService.save(id, content);
        return Y9Result.success();
    }

    public Y9Result<Object> saveCommonSentences(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String content, @RequestParam int tabIndex) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        this.commonSentencesService.saveCommonSentences(userId, content, tabIndex);
        return Y9Result.success();
    }

    public Y9Result<Object> updateUseNumber(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.commonSentencesService.updateUseNumber(id);
        return Y9Result.success();
    }

    @Generated
    public CommonSentencesApiImpl(CommonSentencesService commonSentencesService, PersonApi personApi) {
        this.commonSentencesService = commonSentencesService;
        this.personApi = personApi;
    }
}

