/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.entity.ProcessParam;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ItemDataTransferService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class ItemDataTransferServiceImpl
implements ItemDataTransferService {
    private final JdbcTemplate jdbcTemplate4Tenant;
    private final RuntimeApi runtimeManager;
    private final TaskApi taskManager;
    private final RepositoryApi repositoryManager;
    private final PositionApi positionApi;
    private final ProcessParamService processParamService;

    public ItemDataTransferServiceImpl(@Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate4Tenant, RuntimeApi runtimeManager, TaskApi taskManager, RepositoryApi repositoryManager, PositionApi positionApi, ProcessParamService processParamService) {
        this.jdbcTemplate4Tenant = jdbcTemplate4Tenant;
        this.runtimeManager = runtimeManager;
        this.taskManager = taskManager;
        this.repositoryManager = repositoryManager;
        this.positionApi = positionApi;
        this.processParamService = processParamService;
    }

    @Override
    public Y9Result<String> dataTransfer(String processDefinitionId, String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ProcessDefinitionModel processDefinition = (ProcessDefinitionModel)this.repositoryManager.getLatestProcessDefinitionByKey(tenantId, processDefinitionId.split(":")[0]).getData();
        String latestProcessDefinitionId = processDefinition.getId();
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            this.executeSql0(latestProcessDefinitionId, processDefinitionId);
        } else {
            this.executeSql(latestProcessDefinitionId, processInstanceId);
        }
        return Y9Result.successMsg((String)"\u8fc1\u79fb\u6210\u529f");
    }

    private final void executeSql(String latestProcessDefinitionId, String processInstanceId) {
        String sql1 = "UPDATE ACT_HI_ACTINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_INST_ID_ = '" + processInstanceId + "';";
        this.jdbcTemplate4Tenant.execute(sql1);
        String sql2 = "UPDATE ACT_HI_PROCINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_INST_ID_ = '" + processInstanceId + "';";
        this.jdbcTemplate4Tenant.execute(sql2);
        String sql3 = "UPDATE ACT_HI_TASKINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_INST_ID_ = '" + processInstanceId + "';";
        this.jdbcTemplate4Tenant.execute(sql3);
        String sql4 = "UPDATE ACT_RU_ACTINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_INST_ID_ = '" + processInstanceId + "';";
        this.jdbcTemplate4Tenant.execute(sql4);
        String sql5 = "UPDATE ACT_RU_EXECUTION SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_INST_ID_ = '" + processInstanceId + "';";
        this.jdbcTemplate4Tenant.execute(sql5);
        String sql6 = "UPDATE ACT_RU_TASK SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_INST_ID_ = '" + processInstanceId + "';";
        this.jdbcTemplate4Tenant.execute(sql6);
    }

    private final void executeSql0(String latestProcessDefinitionId, String processDefinitionId) {
        String sql1 = "UPDATE ACT_HI_ACTINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_DEF_ID_ = '" + processDefinitionId + "';";
        this.jdbcTemplate4Tenant.execute(sql1);
        String sql2 = "UPDATE ACT_HI_PROCINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_DEF_ID_ = '" + processDefinitionId + "';";
        this.jdbcTemplate4Tenant.execute(sql2);
        String sql3 = "UPDATE ACT_HI_TASKINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_DEF_ID_ = '" + processDefinitionId + "';";
        this.jdbcTemplate4Tenant.execute(sql3);
        String sql4 = "UPDATE ACT_RU_ACTINST SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_DEF_ID_ = '" + processDefinitionId + "';";
        this.jdbcTemplate4Tenant.execute(sql4);
        String sql5 = "UPDATE ACT_RU_EXECUTION SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_DEF_ID_ = '" + processDefinitionId + "';";
        this.jdbcTemplate4Tenant.execute(sql5);
        String sql6 = "UPDATE ACT_RU_TASK SET PROC_DEF_ID_ = '" + latestProcessDefinitionId + "' WHERE PROC_DEF_ID_ = '" + processDefinitionId + "';";
        this.jdbcTemplate4Tenant.execute(sql6);
    }

    private final String getAssigneeIdsAndAssigneeNames(List<TaskModel> taskList) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String assigneeNames = "";
        int i = 0;
        if (taskList.size() > 0) {
            boolean b;
            for (TaskModel task : taskList) {
                Position personTemp;
                String assignee = task.getAssignee();
                if (i >= 5 || !StringUtils.isNotBlank((CharSequence)assignee) || (personTemp = (Position)this.positionApi.get(tenantId, assignee).getData()) == null) continue;
                assigneeNames = Y9Util.genCustomStr((String)assigneeNames, (String)personTemp.getName(), (String)"\u3001");
                ++i;
            }
            boolean bl = b = taskList.size() > 5;
            if (b) {
                assigneeNames = assigneeNames + "\u7b49\uff0c\u5171" + taskList.size() + "\u4eba";
            }
        }
        return assigneeNames;
    }

    @Override
    public Y9Page<Map<String, Object>> pageByItemIdAndProcessDefinitionId(String itemId, String processDefinitionId, Integer page, Integer rows) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList items = new ArrayList();
        Y9Page piPage = this.runtimeManager.getProcessInstancesByDefId(tenantId, processDefinitionId, page, rows);
        List list = piPage.getRows();
        ObjectMapper objectMapper = new ObjectMapper();
        List pList = (List)objectMapper.convertValue((Object)list, (TypeReference)new TypeReference<List<ProcessInstanceModel>>(){});
        ProcessParam processParam = null;
        HashMap<String, String> mapTemp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (ProcessInstanceModel processInstance : pList) {
            mapTemp = new HashMap<String, String>(16);
            try {
                String processInstanceId = processInstance.getId();
                mapTemp.put("processInstanceId", processInstanceId);
                mapTemp.put("startTime", sdf.format(processInstance.getStartTime()));
                processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
                mapTemp.put("title", StringUtils.isBlank((CharSequence)processParam.getTitle()) ? "\u672a\u5b9a\u4e49\u6807\u9898" : processParam.getTitle());
                mapTemp.put("number", StringUtils.isBlank((CharSequence)processParam.getCustomNumber()) ? "" : processParam.getCustomNumber());
                mapTemp.put("startorName", processParam.getStartorName());
                List taskList = (List)this.taskManager.findByProcessInstanceId(tenantId, processInstanceId).getData();
                String assigneeNames = this.getAssigneeIdsAndAssigneeNames(taskList);
                mapTemp.put("assigneeNames", assigneeNames);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            items.add(mapTemp);
        }
        return Y9Page.success((int)page, (int)piPage.getTotalPages(), (long)piPage.getTotal(), items, (String)"\u83b7\u53d6\u5217\u8868\u6210\u529f");
    }
}

