/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.risesoft.api.platform.customgroup.CustomGroupApi;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.platform.permission.PositionResourceApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.api.platform.permission.RoleApi;
import net.risesoft.api.processadmin.ConditionParserApi;
import net.risesoft.api.processadmin.HistoricProcessApi;
import net.risesoft.api.processadmin.HistoricTaskApi;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.api.processadmin.ProcessTodoApi;
import net.risesoft.api.processadmin.RepositoryApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.api.processadmin.VariableApi;
import net.risesoft.api.todo.TodoTaskApi;
import net.risesoft.entity.ErrorLog;
import net.risesoft.entity.ItemButtonBind;
import net.risesoft.entity.ItemPermission;
import net.risesoft.entity.ItemPrintTemplateBind;
import net.risesoft.entity.ItemTaskConf;
import net.risesoft.entity.ProcessParam;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.entity.TaskVariable;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.Y9FormItemMobileBind;
import net.risesoft.entity.form.Y9Form;
import net.risesoft.enums.ItemBoxTypeEnum;
import net.risesoft.enums.ItemButtonTypeEnum;
import net.risesoft.enums.ItemPermissionEnum;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.itemadmin.DocUserChoiseModel;
import net.risesoft.model.itemadmin.ItemListModel;
import net.risesoft.model.itemadmin.OpenDataModel;
import net.risesoft.model.itemadmin.SignTaskConfigModel;
import net.risesoft.model.itemadmin.StartProcessResultModel;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.model.platform.Resource;
import net.risesoft.model.processadmin.HistoricProcessInstanceModel;
import net.risesoft.model.processadmin.HistoricTaskInstanceModel;
import net.risesoft.model.processadmin.ProcessDefinitionModel;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.nosql.elastic.entity.OfficeDoneInfo;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.form.Y9FormRepository;
import net.risesoft.repository.jpa.ItemTaskConfRepository;
import net.risesoft.repository.jpa.PrintTemplateItemBindRepository;
import net.risesoft.repository.jpa.SpmApproveItemRepository;
import net.risesoft.repository.jpa.TaskVariableRepository;
import net.risesoft.service.AsyncHandleService;
import net.risesoft.service.DocumentService;
import net.risesoft.service.DynamicRoleMemberService;
import net.risesoft.service.ErrorLogService;
import net.risesoft.service.OfficeDoneInfoService;
import net.risesoft.service.Process4SearchService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.service.RoleService;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemButtonBindService;
import net.risesoft.service.config.ItemPermissionService;
import net.risesoft.service.config.ItemStartNodeRoleService;
import net.risesoft.service.config.ItemTaskConfService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.service.form.Y9FormService;
import net.risesoft.service.impl.ActivitiOptServiceImpl;
import net.risesoft.util.ButtonUtil;
import net.risesoft.util.CommonOpt;
import net.risesoft.util.ListUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.util.Y9Util;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements DocumentService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentServiceImpl.class);
    private final ActivitiOptServiceImpl activitiOptService;
    private final SpmApproveItemService spmApproveitemService;
    private final SpmApproveItemRepository spmApproveitemRepository;
    private final ItemTaskConfService taskConfService;
    private final ItemPermissionService itemPermissionService;
    private final Y9FormItemBindService y9FormItemBindService;
    private final ItemButtonBindService buttonItemBindService;
    private final TodoTaskApi rpcTodoTaskManager;
    private final TaskApi taskManager;
    private final CustomGroupApi customGroupApi;
    private final ProcessDefinitionApi processDefinitionManager;
    private final VariableApi variableManager;
    private final OrgUnitApi orgUnitManager;
    private final RepositoryApi repositoryManager;
    private final PositionApi positionManager;
    private final RoleApi roleManager;
    private final PositionRoleApi positionRoleApi;
    private final DepartmentApi departmentManager;
    private final PositionResourceApi positionResourceApi;
    private final HistoricProcessApi historicProcessManager;
    private final HistoricTaskApi historicTaskManager;
    private final RuntimeApi runtimeManager;
    private final ProcessParamService processParamService;
    private final ProcessTodoApi todoManager;
    private final PrintTemplateItemBindRepository printTemplateItemBindRepository;
    private final OfficeDoneInfoService officeDoneInfoService;
    private final TaskVariableRepository taskVariableRepository;
    private final AsyncHandleService asyncHandleService;
    private final Y9FormRepository y9FormRepository;
    private final Process4SearchService process4SearchService;
    private final ErrorLogService errorLogService;
    private final ItemStartNodeRoleService itemStartNodeRoleService;
    private final ItemTaskConfRepository taskConfRepository;
    private final DynamicRoleMemberService dynamicRoleMemberService;
    private final ConditionParserApi conditionParserApi;
    private final Y9FormService y9FormService;
    private final RoleService roleService;

    @Override
    public OpenDataModel add(String itemId, boolean mobile) {
        String userId = Y9LoginUserHolder.getPositionId();
        String tenantId = Y9LoginUserHolder.getTenantId();
        OpenDataModel model = new OpenDataModel();
        if (StringUtils.isNotBlank((CharSequence)itemId)) {
            SpmApproveItem item = this.spmApproveitemService.findById(itemId);
            model.setItemId(itemId);
            model.setProcessDefinitionKey(item.getWorkflowGuid());
            String processDefinitionKey = item.getWorkflowGuid();
            ProcessDefinitionModel pdModel = (ProcessDefinitionModel)this.repositoryManager.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
            String processDefinitionId = pdModel.getId();
            String taskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            model = this.genDocumentModel(itemId, processDefinitionKey, "", taskDefKey, mobile, model);
            model = this.menuControl(itemId, processDefinitionId, taskDefKey, "", model, ItemBoxTypeEnum.ADD.getValue());
            model.setProcessDefinitionId(processDefinitionId);
            model.setTaskDefKey(taskDefKey);
            model.setActivitiUser(userId);
            model.setCurrentUser(Y9LoginUserHolder.getPosition().getName());
            model.setItembox(ItemBoxTypeEnum.ADD.getValue());
            model.setProcessSerialNumber(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            model.setProcessInstanceId("");
        }
        return model;
    }

    private String addUserId(String userIds, String userId) {
        if (StringUtils.isNotBlank((CharSequence)userIds)) {
            if (!userIds.contains(userId)) {
                userIds = userIds + ";" + userId;
            }
        } else {
            userIds = userId;
        }
        return userIds;
    }

    @Override
    public void complete(String taskId) throws Exception {
        String tenantId = Y9LoginUserHolder.getTenantId();
        TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
        String processInstanceId = task.getProcessInstanceId();
        this.runtimeManager.complete4Position(tenantId, Y9LoginUserHolder.getPositionId(), processInstanceId, taskId);
    }

    @Override
    public DocUserChoiseModel docUserChoise(String itemId, String processDefinitionKey, String processDefinitionId, String taskId, String taskDefKey, String processInstanceId) {
        DocUserChoiseModel model = new DocUserChoiseModel();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String multiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, processDefinitionId, taskDefKey).getData();
        Map<String, Object> tabMap = this.itemPermissionService.getTabMap(itemId, processDefinitionId, taskDefKey, processInstanceId);
        model.setExistDepartment(((Boolean)tabMap.get("existDepartment")).booleanValue());
        model.setExistPosition(((Boolean)tabMap.get("existPosition")).booleanValue());
        Y9Page pagelist = this.customGroupApi.pageCustomGroupByPersonId(tenantId, Y9LoginUserHolder.getPersonId(), new Y9PageQuery(Integer.valueOf(1), Integer.valueOf(1)));
        model.setExistCustomGroup(pagelist != null && pagelist.getTotal() > 0L);
        model.setMultiInstance(multiInstance);
        model.setProcessDefinitionId(processDefinitionId);
        model.setTenantId(tenantId);
        model.setItemId(itemId);
        model.setRouteToTask(taskDefKey);
        boolean sponsorStatus = this.taskConfService.getSponserStatus(itemId, processDefinitionId, taskDefKey);
        model.setSponsorStatus(sponsorStatus);
        return model;
    }

    @Override
    public OpenDataModel edit(String itembox, String taskId, String processInstanceId, String itemId, boolean mobile) {
        OpenDataModel model = new OpenDataModel();
        String processSerialNumber = "";
        String processDefinitionId = "";
        String taskDefinitionKey = "";
        String processDefinitionKey = "";
        String activitiUser = "";
        String itemboxStr = itembox;
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (ItemBoxTypeEnum.MONITORDOING.getValue().equals(itembox)) {
            itembox = ItemBoxTypeEnum.DOING.getValue();
        }
        model.setMeeting(false);
        ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
        String startor = processParam.getStartor();
        if (itembox.equalsIgnoreCase(ItemBoxTypeEnum.TODO.getValue())) {
            TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            processInstanceId = task.getProcessInstanceId();
            processSerialNumber = processParam.getProcessSerialNumber();
            processDefinitionId = task.getProcessDefinitionId();
            taskDefinitionKey = task.getTaskDefinitionKey();
            processDefinitionKey = processDefinitionId.split(":")[0];
            activitiUser = task.getAssignee();
            if (StringUtils.isBlank((CharSequence)itemId)) {
                itemId = processParam.getItemId();
            }
            if (StringUtils.isBlank((CharSequence)task.getFormKey())) {
                task.setFormKey("0");
                this.taskManager.saveTask(tenantId, task);
                try {
                    this.rpcTodoTaskManager.setIsNewTodo(tenantId, taskId, "0");
                }
                catch (Exception e) {
                    LOGGER.error("setIsNewTodo error", (Throwable)e);
                }
            }
            String startTaskDefKey = "";
            String startNode = (String)this.processDefinitionManager.getStartNodeKeyByProcessDefinitionId(tenantId, processDefinitionId).getData();
            List nodeList = (List)this.processDefinitionManager.getTargetNodes(tenantId, processDefinitionId, startNode).getData();
            for (TargetModel map : nodeList) {
                startTaskDefKey = Y9Util.genCustomStr((String)startTaskDefKey, (String)map.getTaskDefKey());
            }
            model.setStartTaskDefKey(startTaskDefKey);
            OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
            model.setMeeting(officeDoneInfo.getMeeting() != null && officeDoneInfo.getMeeting().equals("1"));
        } else if (itembox.equalsIgnoreCase(ItemBoxTypeEnum.DOING.getValue()) || itembox.equalsIgnoreCase(ItemBoxTypeEnum.DONE.getValue())) {
            HistoricProcessInstanceModel hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getById(tenantId, processInstanceId).getData();
            OfficeDoneInfo officeDoneInfo = this.officeDoneInfoService.findByProcessInstanceId(processInstanceId);
            if (hpi == null) {
                if (officeDoneInfo == null) {
                    String year = processParam.getCreateTime().substring(0, 4);
                    hpi = (HistoricProcessInstanceModel)this.historicProcessManager.getByIdAndYear(tenantId, processInstanceId, year).getData();
                    processDefinitionId = hpi.getProcessDefinitionId();
                    processDefinitionKey = processDefinitionId.split(":")[0];
                } else {
                    processDefinitionId = officeDoneInfo.getProcessDefinitionId();
                    processDefinitionKey = officeDoneInfo.getProcessDefinitionKey();
                }
            } else {
                processDefinitionId = hpi.getProcessDefinitionId();
                processDefinitionKey = processDefinitionId.split(":")[0];
            }
            assert (officeDoneInfo != null);
            model.setMeeting(officeDoneInfo.getMeeting() != null && officeDoneInfo.getMeeting().equals("1"));
            processSerialNumber = processParam.getProcessSerialNumber();
            if (StringUtils.isNotEmpty((CharSequence)taskId)) {
                if (taskId.contains(",")) {
                    taskId = taskId.split(",")[0];
                }
                TaskModel taskTemp = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
                taskDefinitionKey = taskTemp.getTaskDefinitionKey();
            }
        }
        model.setTitle(processParam.getTitle());
        model.setStartor(startor);
        model.setItembox(itembox);
        model.setCurrentUser(Y9LoginUserHolder.getPosition().getName());
        model.setProcessSerialNumber(processSerialNumber);
        model.setProcessDefinitionKey(processDefinitionKey);
        model.setProcessDefinitionId(processDefinitionId);
        model.setProcessInstanceId(processInstanceId);
        model.setTaskDefKey(taskDefinitionKey);
        model.setTaskId(taskId);
        model.setActivitiUser(activitiUser);
        model.setItemId(itemId);
        model = this.genDocumentModel(itemId, processDefinitionKey, processDefinitionId, taskDefinitionKey, mobile, model);
        model = this.menuControl(itemId, processDefinitionId, taskDefinitionKey, taskId, model, itemboxStr);
        return model;
    }

    @Override
    public Y9Result<String> forwarding(String taskId, String sponsorHandle, String userChoice, String routeToTaskId, String sponsorGuid) {
        String processInstanceId = "";
        try {
            boolean tooMuch;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String positionId = Y9LoginUserHolder.getPositionId();
            TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            processInstanceId = task.getProcessInstanceId();
            ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
            ArrayList<String> userList = new ArrayList<String>(this.parseUserChoice(userChoice));
            int num = userList.size();
            boolean bl = tooMuch = num > 100;
            if (tooMuch) {
                return Y9Result.failure((String)"\u53d1\u9001\u4eba\u6570\u8fc7\u591a");
            }
            Position position = Y9LoginUserHolder.getPosition();
            String multiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, task.getProcessDefinitionId(), routeToTaskId).getData();
            Map<String, Object> variables = CommonOpt.setVariables(positionId, position.getName(), routeToTaskId, userList, multiInstance);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            boolean bl2 = tooMuch = num > 20;
            if ("parallel".equals(multiInstance) && tooMuch) {
                TaskVariable taskVariable = this.taskVariableRepository.findByTaskIdAndKeyName(taskId, "isForwarding");
                Date date = new Date();
                if (taskVariable == null) {
                    taskVariable = new TaskVariable();
                    taskVariable.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    taskVariable.setProcessInstanceId(processInstanceId);
                    taskVariable.setTaskId(taskId);
                    taskVariable.setKeyName("isForwarding");
                    taskVariable.setCreateTime(sdf.format(date));
                }
                taskVariable.setUpdateTime(sdf.format(date));
                taskVariable.setText("true:" + num);
                this.taskVariableRepository.save((Object)taskVariable);
                this.asyncHandleService.forwarding(tenantId, position, processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, multiInstance, variables, userList);
            } else if ("subProcess".equals(multiInstance)) {
                HashMap<String, String> vars = new HashMap<String, String>(16);
                vars.put("parentTaskId", taskId);
                this.taskManager.createWithVariables(tenantId, positionId, routeToTaskId, vars, userList);
            } else if (StringUtils.isNotBlank((CharSequence)sponsorHandle) && "true".equals(sponsorHandle)) {
                List taskNextList1 = (List)this.taskManager.findByProcessInstanceId(tenantId, processInstanceId).getData();
                boolean bl3 = tooMuch = taskNextList1.size() > 10;
                if (tooMuch) {
                    TaskVariable taskVariable = this.taskVariableRepository.findByTaskIdAndKeyName(taskId, "isForwarding");
                    Date date = new Date();
                    if (taskVariable == null) {
                        taskVariable = new TaskVariable();
                        taskVariable.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                        taskVariable.setProcessInstanceId(processInstanceId);
                        taskVariable.setTaskId(taskId);
                        taskVariable.setKeyName("isForwarding");
                        taskVariable.setCreateTime(sdf.format(date));
                    }
                    taskVariable.setUpdateTime(sdf.format(date));
                    taskVariable.setText("true:" + num);
                    this.taskVariableRepository.save((Object)taskVariable);
                    this.asyncHandleService.forwarding(tenantId, position, processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, multiInstance, variables, userList);
                } else {
                    this.asyncHandleService.forwarding4Task(processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, multiInstance, variables, userList);
                }
            } else {
                this.asyncHandleService.forwarding4Task(processInstanceId, processParam, sponsorHandle, sponsorGuid, taskId, multiInstance, variables, userList);
            }
            return Y9Result.success((Object)processInstanceId, (String)"\u53d1\u9001\u6210\u529f!");
        }
        catch (Exception e) {
            LOGGER.error("\u516c\u6587\u53d1\u9001\u5931\u8d25\uff01");
            try {
                StringWriter result = new StringWriter();
                PrintWriter print = new PrintWriter(result);
                e.printStackTrace(print);
                String msg = ((Object)result).toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(new Date());
                ErrorLog errorLog = new ErrorLog();
                errorLog.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                errorLog.setCreateTime(time);
                errorLog.setErrorFlag("forwarding");
                errorLog.setErrorType("taskError");
                errorLog.setExtendField("\u53d1\u9001\u5c11\u6570\u4eba\u5931\u8d25");
                errorLog.setProcessInstanceId(processInstanceId);
                errorLog.setTaskId(taskId);
                errorLog.setText(msg);
                errorLog.setUpdateTime(time);
                this.errorLogService.saveErrorLog(errorLog);
            }
            catch (Exception e2) {
                LOGGER.error("\u4fdd\u5b58\u4efb\u52a1\u53d1\u9001\u9519\u8bef\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e2);
            }
            return Y9Result.failure((String)"\u53d1\u9001\u5931\u8d25!");
        }
    }

    @Override
    public OpenDataModel genDocumentModel(String itemId, String processDefinitionKey, String processDefinitionId, String taskDefinitionKey, boolean mobile, OpenDataModel model) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isBlank((CharSequence)processDefinitionId)) {
            processDefinitionId = ((ProcessDefinitionModel)this.repositoryManager.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData()).getId();
        }
        String formIds = "";
        String showOtherFlag = "";
        String formNames = "";
        if (mobile) {
            List<Y9FormItemMobileBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey4Mobile(itemId, processDefinitionId, taskDefinitionKey);
            model.setFormId("");
            model.setFormName("");
            model.setFormJson("");
            if (!eformTaskBinds.isEmpty()) {
                Y9FormItemMobileBind eftb = eformTaskBinds.get(0);
                model.setFormId(eftb.getFormId());
                String formName = eftb.getFormName();
                boolean b = formName.contains("(");
                if (b) {
                    formName = formName.substring(0, formName.indexOf("("));
                }
                model.setFormName(formName);
                Y9Form y9Form = this.y9FormRepository.findById((Object)eftb.getFormId()).orElse(null);
                assert (y9Form != null);
                model.setFormJson(y9Form.getFormJson());
            }
            return model;
        }
        List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, taskDefinitionKey);
        ArrayList list = new ArrayList();
        if (!eformTaskBinds.isEmpty()) {
            for (Y9FormItemBind eftb : eformTaskBinds) {
                formIds = Y9Util.genCustomStr((String)formIds, (String)eftb.getFormId());
                String formName = eftb.getFormName();
                if (formName.contains("(")) {
                    formName = formName.substring(0, formName.indexOf("("));
                }
                formNames = Y9Util.genCustomStr((String)formNames, (String)formName);
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("formId", eftb.getFormId());
                map.put("formName", formName);
                list.add(map);
            }
            showOtherFlag = this.y9FormItemBindService.getShowOther(eformTaskBinds);
        }
        model.setFormList(list);
        model.setFormIds(formIds);
        model.setFormNames(formNames);
        model.setShowOtherFlag(showOtherFlag);
        String printFormId = "";
        String printFormType = "";
        ItemPrintTemplateBind bind = this.printTemplateItemBindRepository.findByItemId(itemId);
        if (bind != null) {
            printFormId = bind.getTemplateId();
            printFormType = bind.getTemplateType();
        }
        model.setPrintFormId(printFormId);
        model.setPrintFormType(printFormType);
        return model;
    }

    private void getAllPosition(List<Position> list, String deptId) {
        List deptList = (List)this.departmentManager.listByParentId(Y9LoginUserHolder.getTenantId(), deptId).getData();
        List list0 = (List)this.positionManager.listByParentId(Y9LoginUserHolder.getTenantId(), deptId).getData();
        if (!list0.isEmpty()) {
            list.addAll(list0);
        }
        for (Department dept : deptList) {
            this.getAllPosition(list, dept.getId());
        }
    }

    @Override
    public String getFirstItem() {
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            String positionId = Y9LoginUserHolder.getPositionId();
            String resourceId = "";
            List list = (List)this.positionResourceApi.listSubResources(tenantId, positionId, AuthorityEnum.BROWSE, resourceId).getData();
            for (Resource r : list) {
                String url = r.getUrl();
                if (StringUtils.isBlank((CharSequence)url) || !url.contains("itemId=")) continue;
                return url.split("itemId=")[1];
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7b2c\u4e00\u4e2a\u4efb\u52a1\u5931\u8d25\uff01", (Throwable)e);
        }
        return "";
    }

    @Override
    public String getFormIdByItemId(String itemId, String processDefinitionKey) {
        String formIds = "";
        String processDefinitionId = ((ProcessDefinitionModel)this.repositoryManager.getLatestProcessDefinitionByKey(Y9LoginUserHolder.getTenantId(), processDefinitionKey).getData()).getId();
        List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, "");
        if (!eformTaskBinds.isEmpty()) {
            for (Y9FormItemBind eftb : eformTaskBinds) {
                formIds = Y9Util.genCustomStr((String)formIds, (String)eftb.getFormId());
            }
        }
        return formIds;
    }

    public List<OrgUnit> getUserChoice(String itemId, String processDefinitionId, String taskDefinitionKey, String processSerialNumber) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<ItemPermission> list = this.itemPermissionService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyExtra(itemId, processDefinitionId, taskDefinitionKey);
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        for (ItemPermission o : list) {
            if (Objects.equals(o.getRoleType(), ItemPermissionEnum.DEPARTMENT.getValue()) || Objects.equals(o.getRoleType(), ItemPermissionEnum.POSITION.getValue()) || Objects.equals(o.getRoleType(), ItemPermissionEnum.USER.getValue())) {
                OrgUnit orgUnit = (OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, o.getRoleId()).getData();
                if (null == orgUnit) continue;
                orgUnitList.add(orgUnit);
                continue;
            }
            if (Objects.equals(o.getRoleType(), ItemPermissionEnum.ROLE.getValue())) {
                List deptList = (List)this.roleManager.listOrgUnitsById(tenantId, o.getRoleId(), OrgTypeEnum.DEPARTMENT).getData();
                List personList = (List)this.roleManager.listOrgUnitsById(tenantId, o.getRoleId(), OrgTypeEnum.POSITION).getData();
                orgUnitList.addAll(deptList);
                orgUnitList.addAll(personList);
                continue;
            }
            if (!Objects.equals(o.getRoleType(), ItemPermissionEnum.DYNAMICROLE.getValue())) continue;
            List<OrgUnit> ouList = this.dynamicRoleMemberService.listByDynamicRoleIdAndProcessInstanceId(o.getRoleId(), processSerialNumber);
            for (OrgUnit orgUnit : ouList) {
                if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                    Position position = (Position)this.positionManager.get(tenantId, orgUnit.getId()).getData();
                    if (position == null || position.getDisabled().booleanValue()) continue;
                    orgUnitList.add(orgUnit);
                    continue;
                }
                orgUnitList.add(orgUnit);
            }
        }
        return orgUnitList;
    }

    @Override
    public List<ItemListModel> listItems() {
        ArrayList<ItemListModel> listMap = new ArrayList<ItemListModel>();
        try {
            String positionId = Y9LoginUserHolder.getPositionId();
            String tenantId = Y9LoginUserHolder.getTenantId();
            String resourceId = "";
            List list = (List)this.positionResourceApi.listSubResources(tenantId, positionId, AuthorityEnum.BROWSE, resourceId).getData();
            for (Resource r : list) {
                ItemListModel model = new ItemListModel();
                String url = r.getUrl();
                if (StringUtils.isBlank((CharSequence)url) || !url.contains("itemId=")) continue;
                String itemId = url.split("itemId=")[1];
                model.setId(r.getId());
                model.setUrl(itemId);
                model.setItemId(itemId);
                model.setAppIcon("");
                model.setTodoCount(Integer.valueOf(0));
                SpmApproveItem spmApproveitem = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
                model.setName(r.getName());
                model.setItemName(r.getName());
                if (spmApproveitem == null || spmApproveitem.getId() == null) continue;
                model.setName(spmApproveitem.getName());
                model.setItemName(spmApproveitem.getName());
                long todoCount = (Long)this.todoManager.getTodoCountByPositionIdAndProcessDefinitionKey(tenantId, positionId, spmApproveitem.getWorkflowGuid()).getData();
                model.setTodoCount(Integer.valueOf((int)todoCount));
                model.setAppIcon(StringUtils.isBlank((CharSequence)spmApproveitem.getIconData()) ? "" : spmApproveitem.getIconData());
                model.setProcessDefinitionKey(spmApproveitem.getWorkflowGuid());
                listMap.add(model);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff01", (Throwable)e);
        }
        return listMap;
    }

    @Override
    public List<ItemListModel> listMyItems() {
        ArrayList<ItemListModel> listMap = new ArrayList<ItemListModel>();
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            String positionId = Y9LoginUserHolder.getPositionId();
            String resourceId = "";
            List list = (List)this.positionResourceApi.listSubResources(tenantId, positionId, AuthorityEnum.BROWSE, resourceId).getData();
            for (Resource r : list) {
                ItemListModel model = new ItemListModel();
                String url = r.getUrl();
                if (StringUtils.isBlank((CharSequence)url) || !url.contains("itemId=")) continue;
                String itemId = url.split("itemId=")[1];
                model.setId(r.getId());
                model.setItemId(itemId);
                model.setAppIcon("");
                SpmApproveItem spmApproveitem = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
                model.setName(r.getName());
                model.setItemName(r.getName());
                if (spmApproveitem == null || spmApproveitem.getId() == null) continue;
                model.setName(spmApproveitem.getName());
                model.setItemName(spmApproveitem.getName());
                model.setAppIcon(StringUtils.isBlank((CharSequence)spmApproveitem.getIconData()) ? "" : spmApproveitem.getIconData());
                model.setProcessDefinitionKey(spmApproveitem.getWorkflowGuid());
                listMap.add(model);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6211\u7684\u4efb\u52a1\u5217\u8868\u5931\u8d25\uff01", (Throwable)e);
        }
        return listMap;
    }

    @Override
    public OpenDataModel menuControl(String itemId, String processDefinitionId, String taskDefKey, String taskId, OpenDataModel model, String itembox) {
        ButtonUtil buttonUtil = new ButtonUtil();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String positionId = Y9LoginUserHolder.getPositionId();
        Map<String, Object> map = buttonUtil.showButton(itemId, taskId, itembox);
        String[] buttonIds = (String[])map.get("buttonIds");
        String[] buttonNames = (String[])map.get("buttonNames");
        String sponsorHandle = (String)map.get("sponsorHandle");
        int[] buttonOrders = (int[])map.get("buttonOrders");
        boolean[] isButtonShow = (boolean[])map.get("isButtonShow");
        String menuName = "";
        String menuKey = "";
        String sendName = "";
        String sendKey = "";
        String repositionName = "";
        String repositionKey = "";
        ArrayList sendMap = new ArrayList();
        ArrayList<Object> menuMap = new ArrayList<Object>();
        ArrayList repositionMap = new ArrayList();
        for (int i = buttonOrders.length - 1; i >= 0; --i) {
            HashMap<String, String> mapTemp;
            List<ItemButtonBind> bibList;
            int k = buttonOrders[i] - 1;
            if (k == 0 && isButtonShow[0]) {
                bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, taskDefKey);
                block3: for (ItemButtonBind itemButtonBind : bibList) {
                    String buttonName = itemButtonBind.getButtonName();
                    String buttonCustomId = itemButtonBind.getButtonCustomId();
                    if ("\u53d1\u9001".equals(buttonName)) continue;
                    List roleIds = itemButtonBind.getRoleIds();
                    if (roleIds.isEmpty()) {
                        HashMap mapTemp2 = new HashMap(16);
                        mapTemp2.put("menuName", buttonName);
                        mapTemp2.put("menuKey", buttonCustomId);
                        menuName = Y9Util.genCustomStr((String)menuName, (String)buttonName);
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonCustomId);
                        menuMap.add(mapTemp2);
                        continue;
                    }
                    for (String roleId : roleIds) {
                        boolean hasRole = (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, positionId).getData();
                        if (!hasRole) continue;
                        mapTemp = new HashMap<String, String>(16);
                        mapTemp.put("menuName", buttonName);
                        mapTemp.put("menuKey", buttonCustomId);
                        menuName = Y9Util.genCustomStr((String)menuName, (String)buttonName);
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonCustomId);
                        menuMap.add(mapTemp);
                        continue block3;
                    }
                }
            }
            if (k == 1 && isButtonShow[1] && StringUtils.isNotBlank((CharSequence)taskDefKey)) {
                Object roleIds;
                boolean haveSendButton = false;
                bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.COMMON.getValue(), processDefinitionId, taskDefKey);
                block5: for (ItemButtonBind bib : bibList) {
                    Object mapTemp3;
                    if (!"\u53d1\u9001".equals(bib.getButtonName())) continue;
                    roleIds = bib.getRoleIds();
                    if (roleIds.isEmpty()) {
                        mapTemp3 = new HashMap(16);
                        mapTemp3.put("menuName", bib.getButtonName());
                        mapTemp3.put("menuKey", bib.getButtonCustomId());
                        menuName = Y9Util.genCustomStr((String)menuName, (String)bib.getButtonName());
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)bib.getButtonCustomId());
                        menuMap.add(mapTemp3);
                        haveSendButton = true;
                        break;
                    }
                    mapTemp3 = roleIds.iterator();
                    while (mapTemp3.hasNext()) {
                        String roleId = (String)mapTemp3.next();
                        boolean hasrole = (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, positionId).getData();
                        if (!hasrole) continue;
                        HashMap<String, String> mapTemp4 = new HashMap<String, String>(16);
                        mapTemp4.put("menuName", bib.getButtonName());
                        mapTemp4.put("menuKey", bib.getButtonCustomId());
                        menuName = Y9Util.genCustomStr((String)menuName, (String)bib.getButtonName());
                        menuKey = Y9Util.genCustomStr((String)menuKey, (String)bib.getButtonCustomId());
                        menuMap.add(mapTemp4);
                        haveSendButton = true;
                        break block5;
                    }
                }
                if (!haveSendButton) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(16);
                    hashMap.put("menuName", buttonNames[k]);
                    hashMap.put("menuKey", buttonIds[k]);
                    menuName = Y9Util.genCustomStr((String)menuName, (String)buttonNames[k]);
                    menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonIds[k]);
                    menuMap.add(hashMap);
                    List routeToTasks = (List)this.processDefinitionManager.getTargetNodes(tenantId, processDefinitionId, taskDefKey).getData();
                    roleIds = routeToTasks.iterator();
                    while (roleIds.hasNext()) {
                        TargetModel m = (TargetModel)roleIds.next();
                        HashMap<String, String> map2 = new HashMap<String, String>(16);
                        if ("\u9000\u56de".equals(m.getTaskDefName()) || "Exclusive Gateway".equals(m.getTaskDefName())) continue;
                        sendName = Y9Util.genCustomStr((String)sendName, (String)m.getTaskDefName());
                        sendKey = Y9Util.genCustomStr((String)sendKey, (String)m.getTaskDefKey());
                        map2.put("sendName", m.getTaskDefName());
                        map2.put("sendKey", m.getTaskDefKey());
                        sendMap.add(map2);
                    }
                    bibList = this.buttonItemBindService.listContainRoleId(itemId, ItemButtonTypeEnum.SEND.getValue(), processDefinitionId, taskDefKey);
                    block8: for (ItemButtonBind bind2 : bibList) {
                        List roleIds2 = bind2.getRoleIds();
                        String buttonName = bind2.getButtonName();
                        String buttonCustomId = bind2.getButtonCustomId();
                        if (roleIds2.isEmpty()) {
                            mapTemp = new HashMap(16);
                            sendName = Y9Util.genCustomStr((String)sendName, (String)buttonName);
                            sendKey = Y9Util.genCustomStr((String)sendKey, (String)buttonCustomId);
                            mapTemp.put("sendName", buttonName);
                            mapTemp.put("sendKey", buttonCustomId);
                            sendMap.add(mapTemp);
                            continue;
                        }
                        for (String roleId : roleIds2) {
                            boolean hasrole = (Boolean)this.positionRoleApi.hasRole(tenantId, roleId, positionId).getData();
                            if (!hasrole) continue;
                            HashMap<String, String> mapTemp5 = new HashMap<String, String>(16);
                            sendName = Y9Util.genCustomStr((String)sendName, (String)buttonName);
                            sendKey = Y9Util.genCustomStr((String)sendKey, (String)buttonCustomId);
                            mapTemp5.put("sendName", buttonName);
                            mapTemp5.put("sendKey", buttonCustomId);
                            sendMap.add(mapTemp5);
                            continue block8;
                        }
                    }
                }
            }
            if (k == 15 && isButtonShow[15]) {
                String taskDefNameJson;
                List list = (List)this.processDefinitionManager.getNodes(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
                for (TargetModel node : list) {
                    HashMap<String, String> map3 = new HashMap<String, String>(16);
                    if ("\u6d41\u7a0b".equals(node.getTaskDefName())) continue;
                    repositionName = Y9Util.genCustomStr((String)repositionName, (String)node.getTaskDefName());
                    repositionKey = Y9Util.genCustomStr((String)repositionKey, (String)node.getTaskDefKey());
                    map3.put("repositionName", node.getTaskDefName());
                    map3.put("repositionKey", node.getTaskDefKey());
                    repositionMap.add(map3);
                }
                model.setRepositionMap(repositionMap);
                ObjectMapper mapper = new ObjectMapper();
                try {
                    taskDefNameJson = mapper.writeValueAsString(repositionMap);
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("\u89e3\u6790\u91cd\u5b9a\u5411\u6309\u94ae\u5931\u8d25\uff01", (Throwable)e);
                    taskDefNameJson = "[]";
                }
                model.setTaskDefNameJson(taskDefNameJson);
            }
            if (k == 1 || !isButtonShow[k]) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>(16);
            hashMap.put("menuName", buttonNames[k]);
            hashMap.put("menuKey", buttonIds[k]);
            menuName = Y9Util.genCustomStr((String)menuName, (String)buttonNames[k]);
            menuKey = Y9Util.genCustomStr((String)menuKey, (String)buttonIds[k]);
            menuMap.add(hashMap);
        }
        model.setSendMap(sendMap);
        model.setMenuMap(menuMap);
        model.setSendName(sendName);
        model.setSendKey(sendKey);
        model.setMenuName(menuName);
        model.setMenuKey(menuKey);
        model.setSponsorHandle(sponsorHandle);
        model.setLastPerson4RefuseClaim(map.get("isLastPerson4RefuseClaim") != null ? (Boolean)map.get("isLastPerson4RefuseClaim") : false);
        model.setMultiInstance(map.get("multiInstance") != null ? (String)map.get("multiInstance") : "");
        model.setNextNode(map.get("nextNode") != null ? (Boolean)map.get("nextNode") : false);
        return model;
    }

    @Override
    public List<String> parseUserChoice(String userChoice) {
        String users = "";
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)userChoice)) {
            String[] userChoices;
            for (String s : userChoices = userChoice.split(";")) {
                String[] s2 = s.split(":");
                int principalType = Integer.parseInt(s2[0]);
                String userIdTemp = s2[1];
                if (principalType == ItemPermissionEnum.POSITION.getValue()) {
                    Position position = (Position)this.positionManager.get(tenantId, s2[1]).getData();
                    if (null == position) continue;
                    users = this.addUserId(users, userIdTemp);
                    continue;
                }
                if (principalType == ItemPermissionEnum.DEPARTMENT.getValue()) {
                    ArrayList<Position> employeeList = new ArrayList<Position>();
                    this.getAllPosition(employeeList, s2[1]);
                    for (Position pTemp : employeeList) {
                        users = this.addUserId(users, pTemp.getId());
                    }
                    continue;
                }
                if (principalType != ItemPermissionEnum.CUSTOMGROUP.getValue()) continue;
                List list = (List)this.customGroupApi.listCustomGroupMemberByGroupIdAndMemberType(tenantId, Y9LoginUserHolder.getPersonId(), s2[1], OrgTypeEnum.POSITION).getData();
                for (Position pTemp : list) {
                    Position position = (Position)this.positionManager.get(tenantId, pTemp.getMemberId()).getData();
                    if (position == null || !StringUtils.isNotBlank((CharSequence)position.getId())) continue;
                    users = this.addUserId(users, position.getId());
                }
            }
        }
        List result = Y9Util.stringToList((String)users, (String)";");
        ListUtil.removeDuplicateWithOrder(result);
        return result;
    }

    public Y9Result<TargetModel> parserRouteToTaskId(String itemId, String processSerialNumber, String processDefinitionId, String taskDefKey, String taskId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        Y9Result result = Y9Result.failure((String)"\u89e3\u6790\u76ee\u6807\u8def\u7531\u5931\u8d25");
        try {
            List targetNodes = (List)this.processDefinitionManager.getTargetNodes(tenantId, processDefinitionId, taskDefKey).getData();
            if (targetNodes.isEmpty()) {
                return Y9Result.failure((String)"\u76ee\u6807\u8def\u7531\u4e0d\u5b58\u5728");
            }
            if (1 == targetNodes.size()) {
                result.setData((Object)((TargetModel)targetNodes.get(0)));
                result.setSuccess(true);
                return result;
            }
            List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, taskDefKey);
            Map<String, Object> variables = this.y9FormService.getFormData4Var(eformTaskBinds.get(0).getFormId(), processSerialNumber);
            ArrayList<TargetModel> targetNodesTemp = new ArrayList<TargetModel>();
            for (TargetModel targetNode : targetNodes) {
                for (String columnName : variables.keySet()) {
                    String str = StringUtils.replace((String)variables.get(columnName).toString(), (String)".", (String)"");
                    if (!StringUtils.isNumeric((CharSequence)str)) continue;
                    if (variables.get(columnName).toString().contains(".")) {
                        LOGGER.info("*************************Double:" + variables.get(columnName).toString());
                        variables.put(columnName, Double.valueOf(variables.get(columnName).toString()));
                        continue;
                    }
                    LOGGER.info("*************************Integer:" + variables.get(columnName).toString());
                    variables.put(columnName, Integer.parseInt(variables.get(columnName).toString()));
                }
                LOGGER.info("*************************Y9JsonUtil:" + Y9JsonUtil.writeValueAsString(variables));
                boolean b = (Boolean)this.conditionParserApi.parser(tenantId, targetNode.getConditionExpression(), variables).getData();
                if (!b) continue;
                targetNodesTemp.add(targetNode);
            }
            if (targetNodesTemp.isEmpty()) {
                result.setMsg("\u672a\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u76ee\u6807\u8def\u7531");
                return result;
            }
            if (targetNodesTemp.size() > 1) {
                result.setMsg("\u7b26\u5408\u8981\u6c42\u7684\u76ee\u6807\u8def\u7531\u8fc7\u591a");
                return result;
            }
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                this.variableManager.setVariables(tenantId, taskId, variables);
            }
            result.setData((Object)((TargetModel)targetNodesTemp.get(0)));
            result.setMsg("\u89e3\u6790\u76ee\u6807\u8def\u7531\u6210\u529f");
            result.setSuccess(true);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u76ee\u6807\u8def\u7531\u5931\u8d25\uff01", (Throwable)e);
        }
        return result;
    }

    @Override
    public Y9Result<List<String>> parserUser(String itemId, String processDefinitionId, String routeToTaskId, String routeToTaskName, String processInstanceId, String multiInstance) {
        Y9Result result = Y9Result.failure((String)"\u89e3\u6790\u4eba\u5458\u5931\u8d25");
        List<OrgUnit> orgUnitList = this.roleService.listPermUser4SUbmitTo(itemId, processDefinitionId, routeToTaskId, processInstanceId);
        if (orgUnitList.isEmpty()) {
            result.setMsg("\u76ee\u6807\u8def\u7531\u3010" + routeToTaskName + "\u3011\u672a\u6388\u6743\u4eba\u5458");
            return result;
        }
        if ("common".equals(multiInstance) && orgUnitList.size() > 1) {
            result.setMsg("\u76ee\u6807\u8def\u7531\u3010" + routeToTaskName + "\u3011\u6388\u6743\u4eba\u5458\u8fc7\u591a");
            return result;
        }
        ArrayList<String> userList = new ArrayList<String>();
        for (OrgUnit orgUnit : orgUnitList) {
            userList.add(orgUnit.getId());
        }
        result.setData(userList);
        result.setSuccess(true);
        return result;
    }

    @Override
    public Y9Result<String> reposition(String taskId, String userChoice) {
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            String processInstanceId = task.getProcessInstanceId();
            ArrayList<String> userAndDeptIdList = new ArrayList<String>();
            userChoice = userChoice.substring(2);
            userAndDeptIdList.add(userChoice);
            String multiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, task.getProcessDefinitionId(), task.getTaskDefinitionKey()).getData();
            HashMap<String, String> variables = new HashMap<String, String>(16);
            variables.put("user", userChoice);
            if ("parallel".equals(multiInstance)) {
                List taskNextList = (List)this.taskManager.findByProcessInstanceId(tenantId, processInstanceId).getData();
                for (TaskModel taskNext : taskNextList) {
                    if (!StringUtils.isBlank((CharSequence)taskNext.getFormKey()) && !taskNext.getFormKey().equals("1")) continue;
                    taskId = taskNext.getId();
                    break;
                }
                for (TaskModel taskNext : taskNextList) {
                    if (taskId.equals(taskNext.getId())) continue;
                    if (StringUtils.isBlank((CharSequence)taskNext.getFormKey()) || taskNext.getFormKey().equals("1")) {
                        HashMap<String, String> val = new HashMap<String, String>();
                        val.put("val", "reposition");
                        this.variableManager.setVariableLocal(tenantId, taskNext.getId(), "reposition", val);
                        this.taskManager.complete(tenantId, taskNext.getId());
                        continue;
                    }
                    this.taskManager.complete(tenantId, taskNext.getId());
                }
                TaskModel task1 = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
                task1.setAssignee(userChoice);
                this.taskManager.saveTask(tenantId, task1);
                HashMap<String, String> val = new HashMap<String, String>();
                val.put("val", userChoice.split(":")[0]);
                this.variableManager.setVariableLocal(tenantId, task1.getId(), "parallelSponsor", val);
            } else if ("sequential".equals(multiInstance)) {
                task.setAssignee(userChoice);
                this.taskManager.saveTask(tenantId, task);
            } else {
                task.setAssignee(userChoice);
                this.taskManager.saveTask(tenantId, task);
            }
            return Y9Result.successMsg((String)"\u91cd\u5b9a\u4f4d\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u5b9a\u4f4d\u5931\u8d25\uff01", (Throwable)e);
            return Y9Result.failure((String)"\u91cd\u5b9a\u4f4d\u5931\u8d25\uff01");
        }
    }

    @Override
    public Y9Result<String> saveAndForwarding(String itemId, String processSerialNumber, String processDefinitionKey, String userChoice, String sponsorGuid, String routeToTaskId, Map<String, Object> variables) {
        boolean tooMuch;
        ArrayList<String> userList = new ArrayList<String>(this.parseUserChoice(userChoice));
        int num = userList.size();
        boolean bl = tooMuch = num > 100;
        if (tooMuch) {
            return Y9Result.failure((String)"\u53d1\u9001\u4eba\u6570\u8fc7\u591a");
        }
        StartProcessResultModel model = this.startProcess(itemId, processSerialNumber, processDefinitionKey);
        String taskId = model.getTaskId();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (!variables.isEmpty()) {
            this.variableManager.setVariables(tenantId, taskId, variables);
        }
        return this.start4Forwarding(taskId, routeToTaskId, sponsorGuid, userList);
    }

    @Override
    public Y9Result<String> saveAndForwardingByTaskKey(String itemId, String processSerialNumber, String processDefinitionKey, String userChoice, String sponsorGuid, String routeToTaskId, String startRouteToTaskId, Map<String, Object> variables) {
        boolean tooMuch;
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<String> userList = new ArrayList<String>(this.parseUserChoice(userChoice));
        int num = userList.size();
        boolean bl = tooMuch = num > 100;
        if (tooMuch) {
            return Y9Result.failure((String)"\u53d1\u9001\u4eba\u6570\u8fc7\u591a");
        }
        Map<String, Object> map1 = this.startProcessByTaskKey(itemId, processSerialNumber, processDefinitionKey, startRouteToTaskId);
        String taskId = (String)map1.get("taskId");
        if (!variables.isEmpty()) {
            this.variableManager.setVariables(tenantId, taskId, variables);
        }
        return this.start4Forwarding(taskId, routeToTaskId, sponsorGuid, userList);
    }

    @Override
    public Y9Result<Object> saveAndSubmitTo(String itemId, String processSerialNumber) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String positionId = Y9LoginUserHolder.getPositionId();
        Position position = Y9LoginUserHolder.getPosition();
        try {
            String multiInstance;
            String routeToTaskName;
            SpmApproveItem item = this.spmApproveitemService.findById(itemId);
            String processDefinitionKey = item.getWorkflowGuid();
            ProcessDefinitionModel processDefinitionModel = (ProcessDefinitionModel)this.repositoryManager.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
            String processDefinitionId = processDefinitionModel.getId();
            String taskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            Y9Result<TargetModel> routeToTaskIdResult = this.parserRouteToTaskId(itemId, processSerialNumber, processDefinitionId, taskDefKey, "");
            if (!routeToTaskIdResult.isSuccess()) {
                return Y9Result.failure((String)routeToTaskIdResult.getMsg());
            }
            String routeToTaskId = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefKey();
            Y9Result<List<String>> userResult = this.parserUser(itemId, processDefinitionId, routeToTaskId, routeToTaskName = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefName(), "", multiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, processDefinitionId, routeToTaskId).getData());
            if (!userResult.isSuccess()) {
                return Y9Result.failure((String)userResult.getMsg());
            }
            StartProcessResultModel model = this.startProcess(itemId, processSerialNumber, processDefinitionKey);
            String taskId = model.getTaskId();
            String processInstanceId = model.getProcessInstanceId();
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            List userList = (List)userResult.getData();
            Map<String, Object> variables = CommonOpt.setVariables(positionId, position.getName(), routeToTaskId, userList, multiInstance);
            this.asyncHandleService.forwarding4Task(processInstanceId, processParam, "", "", taskId, multiInstance, variables, userList);
            return Y9Result.successMsg((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u63d0\u4ea4\u5931\u8d25\uff01", (Throwable)e);
            return Y9Result.failure((String)"\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }

    @Override
    public SignTaskConfigModel signTaskConfig(String itemId, String processDefinitionId, String taskDefinitionKey, String processSerialNumber) {
        SignTaskConfigModel model = new SignTaskConfigModel();
        try {
            model.setSignTask(false);
            model.setUserChoice("");
            model.setOnePerson(false);
            boolean searchPerson = true;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String multiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, processDefinitionId, taskDefinitionKey).getData();
            if ("common".equals(multiInstance)) {
                ItemTaskConf itemTaskConf = this.taskConfRepository.findByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, taskDefinitionKey);
                ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
                if (itemTaskConf != null && itemTaskConf.getSignTask().booleanValue()) {
                    model.setSignTask(true);
                    if (processParam != null && StringUtils.isNotBlank((CharSequence)processParam.getProcessInstanceId())) {
                        List hisTaskList = (List)this.historicTaskManager.findTaskByProcessInstanceIdOrByEndTimeAsc(tenantId, processParam.getProcessInstanceId(), "").getData();
                        for (HistoricTaskInstanceModel hisTask : hisTaskList) {
                            if (!hisTask.getTaskDefinitionKey().equals(taskDefinitionKey)) continue;
                            searchPerson = false;
                            model.setUserChoice("6:" + hisTask.getAssignee());
                            break;
                        }
                    }
                    if (searchPerson) {
                        List<OrgUnit> orgUnitList = this.getUserChoice(itemId, processDefinitionId, taskDefinitionKey, processParam != null ? processParam.getProcessInstanceId() : "");
                        if (orgUnitList.isEmpty()) {
                            model.setSignTask(false);
                        } else {
                            String userChoice = "";
                            for (OrgUnit orgUnit : orgUnitList) {
                                int type = 0;
                                if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
                                    type = 2;
                                } else if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                                    type = 6;
                                }
                                if (StringUtils.isEmpty((CharSequence)userChoice)) {
                                    userChoice = type + ":" + orgUnit.getId();
                                    continue;
                                }
                                userChoice = userChoice + ";" + type + ":" + orgUnit.getId();
                            }
                            model.setUserChoice(userChoice);
                        }
                    }
                } else {
                    List<OrgUnit> orgUnitList = this.getUserChoice(itemId, processDefinitionId, taskDefinitionKey, processParam != null ? processParam.getProcessInstanceId() : "");
                    if (orgUnitList.size() == 1 && orgUnitList.get(0).getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                        model.setOnePerson(true);
                        model.setUserChoice("6:" + orgUnitList.get(0).getId());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5931\u8d25\uff01", (Throwable)e);
        }
        return model;
    }

    public Y9Result<String> start4Forwarding(String taskId, String routeToTaskId, String sponsorGuid, List<String> userList) {
        String processInstanceId = "";
        try {
            boolean tooMuch;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String positionId = Y9LoginUserHolder.getPositionId();
            Position position = Y9LoginUserHolder.getPosition();
            TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            processInstanceId = task.getProcessInstanceId();
            ProcessParam processParam = this.processParamService.findByProcessInstanceId(processInstanceId);
            String multiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, task.getProcessDefinitionId(), routeToTaskId).getData();
            Map<String, Object> variables = CommonOpt.setVariables(positionId, position.getName(), routeToTaskId, userList, multiInstance);
            if (multiInstance.equals("callActivity")) {
                HashMap<String, String> initDataMap = new HashMap<String, String>(16);
                initDataMap.put("parentProcessSerialNumber", processParam != null ? processParam.getProcessSerialNumber() : "");
                variables.put("initDataMap", initDataMap);
            }
            int num = userList.size();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            boolean bl = tooMuch = num > 20;
            if ("parallel".equals(multiInstance) && tooMuch) {
                TaskVariable taskVariable = this.taskVariableRepository.findByTaskIdAndKeyName(taskId, "isForwarding");
                Date date = new Date();
                if (taskVariable == null) {
                    taskVariable = new TaskVariable();
                    taskVariable.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                    taskVariable.setProcessInstanceId(processInstanceId);
                    taskVariable.setTaskId(taskId);
                    taskVariable.setKeyName("isForwarding");
                    taskVariable.setCreateTime(sdf.format(date));
                }
                taskVariable.setUpdateTime(sdf.format(date));
                taskVariable.setText("true:" + num);
                this.taskVariableRepository.save((Object)taskVariable);
                this.asyncHandleService.forwarding(tenantId, position, processInstanceId, processParam, "", sponsorGuid, taskId, multiInstance, variables, userList);
            } else if ("subProcess".equals(multiInstance)) {
                HashMap<String, String> vars = new HashMap<String, String>(16);
                vars.put("parentTaskId", taskId);
                this.taskManager.createWithVariables4Position(tenantId, position.getId(), Y9LoginUserHolder.getPersonId(), routeToTaskId, vars, userList);
            } else {
                assert (processParam != null);
                this.asyncHandleService.forwarding4Task(processInstanceId, processParam, "", sponsorGuid, taskId, multiInstance, variables, userList);
            }
            return Y9Result.success((Object)processInstanceId, (String)"\u53d1\u9001\u6210\u529f!");
        }
        catch (Exception e) {
            LOGGER.error("\u516c\u6587\u53d1\u9001\u5931\u8d25\uff01");
            try {
                StringWriter result = new StringWriter();
                PrintWriter print = new PrintWriter(result);
                e.printStackTrace(print);
                String msg = ((Object)result).toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(new Date());
                ErrorLog errorLog = new ErrorLog();
                errorLog.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
                errorLog.setCreateTime(time);
                errorLog.setErrorFlag("forwarding");
                errorLog.setErrorType("taskError");
                errorLog.setExtendField("\u542f\u52a8\u6d41\u7a0b\u53d1\u9001\u5c11\u6570\u4eba\u5931\u8d25");
                errorLog.setProcessInstanceId(processInstanceId);
                errorLog.setTaskId(taskId);
                errorLog.setText(msg);
                errorLog.setUpdateTime(time);
                this.errorLogService.saveErrorLog(errorLog);
            }
            catch (Exception e2) {
                LOGGER.error("\u4fdd\u5b58\u4efb\u52a1\u53d1\u9001\u9519\u8bef\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e2);
            }
            return Y9Result.failure((String)"\u53d1\u9001\u5931\u8d25!");
        }
    }

    @Override
    public StartProcessResultModel startProcess(String itemId, String processSerialNumber, String processDefinitionKey) {
        StartProcessResultModel model = null;
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            HashMap<String, Object> vars = new HashMap<String, Object>(16);
            SpmApproveItem item = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
            vars.put("tenantId", tenantId);
            String startTaskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            vars.put("routeToTaskId", startTaskDefKey);
            vars.put("_FLOWABLE_SKIP_EXPRESSION_ENABLED", true);
            assert (item != null);
            if (item.isShowSubmitButton()) {
                ProcessDefinitionModel processDefinitionModel = (ProcessDefinitionModel)this.repositoryManager.getLatestProcessDefinitionByKey(tenantId, processDefinitionKey).getData();
                List<Y9FormItemBind> eformTaskBinds = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionModel.getId(), "");
                Map<String, Object> variables = this.y9FormService.getFormData4Var(eformTaskBinds.get(0).getFormId(), processSerialNumber);
                for (String columnName : variables.keySet()) {
                    String str = StringUtils.replace((String)variables.get(columnName).toString(), (String)".", (String)"");
                    if (!StringUtils.isNumeric((CharSequence)str)) continue;
                    if (variables.get(columnName).toString().contains(".")) {
                        LOGGER.info("*************************startProcess_Double:" + variables.get(columnName).toString());
                        variables.put(columnName, Double.valueOf(variables.get(columnName).toString()));
                        continue;
                    }
                    LOGGER.info("*************************startProcess_Integer:" + variables.get(columnName).toString());
                    variables.put(columnName, Integer.parseInt(variables.get(columnName).toString()));
                }
                vars.putAll(variables);
            }
            TaskModel task = this.activitiOptService.startProcess(processSerialNumber, processDefinitionKey, item.getSystemName(), vars);
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            processParam.setProcessInstanceId(task.getProcessInstanceId());
            processParam.setStartor(Y9LoginUserHolder.getPositionId());
            processParam.setStartorName(Y9LoginUserHolder.getPosition().getName());
            processParam.setSended("true");
            this.process4SearchService.saveToDataCenter(tenantId, processParam, Y9LoginUserHolder.getPosition());
            this.processParamService.saveOrUpdate(processParam);
            this.asyncHandleService.startProcessHandle(tenantId, processSerialNumber, task.getId(), task.getProcessInstanceId(), processParam.getSearchTerm());
            model = new StartProcessResultModel();
            model.setProcessDefinitionId(task.getProcessDefinitionId());
            model.setProcessInstanceId(task.getProcessInstanceId());
            model.setProcessSerialNumber(processSerialNumber);
            model.setTaskId(task.getId());
            model.setTaskDefKey(task.getTaskDefinitionKey());
        }
        catch (Exception e) {
            LOGGER.error("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25\uff01", (Throwable)e);
        }
        return model;
    }

    @Override
    public StartProcessResultModel startProcess(String itemId, String processSerialNumber, String processDefinitionKey, String positionIds) {
        StartProcessResultModel model = null;
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            Position position = Y9LoginUserHolder.getPosition();
            Map<String, Object> vars = new HashMap<String, Object>(16);
            SpmApproveItem item = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
            vars.put("tenantId", tenantId);
            String startTaskDefKey = this.itemStartNodeRoleService.getStartTaskDefKey(itemId);
            vars.put("routeToTaskId", startTaskDefKey);
            vars = CommonOpt.setVariables(position.getId(), position.getName(), "", Arrays.asList(positionIds.split(",")), processSerialNumber, "", vars);
            assert (item != null);
            ProcessInstanceModel piModel = (ProcessInstanceModel)this.runtimeManager.startProcessInstanceByKey(tenantId, position.getId(), processDefinitionKey, item.getSystemName(), vars).getData();
            String processInstanceId = piModel.getId();
            TaskModel task = (TaskModel)((List)this.taskManager.findByProcessInstanceId(tenantId, processInstanceId).getData()).get(0);
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            processParam.setProcessInstanceId(task.getProcessInstanceId());
            processParam.setStartor(Y9LoginUserHolder.getPositionId());
            processParam.setStartorName(Y9LoginUserHolder.getPosition().getName());
            processParam.setSended("true");
            this.process4SearchService.saveToDataCenter(tenantId, processParam, Y9LoginUserHolder.getPosition());
            this.processParamService.saveOrUpdate(processParam);
            this.asyncHandleService.startProcessHandle(tenantId, processSerialNumber, task.getId(), task.getProcessInstanceId(), processParam.getSearchTerm());
            model = new StartProcessResultModel();
            model.setProcessDefinitionId(task.getProcessDefinitionId());
            model.setProcessInstanceId(task.getProcessInstanceId());
            model.setProcessSerialNumber(processSerialNumber);
            model.setTaskId(task.getId());
            model.setTaskDefKey(task.getTaskDefinitionKey());
            return model;
        }
        catch (Exception e) {
            LOGGER.error("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25\uff01", (Throwable)e);
            return model;
        }
    }

    @Override
    public Map<String, Object> startProcessByTaskKey(String itemId, String processSerialNumber, String processDefinitionKey, String startRouteToTaskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("success", false);
        try {
            String tenantId = Y9LoginUserHolder.getTenantId();
            HashMap<String, Object> vars = new HashMap<String, Object>(16);
            SpmApproveItem item = this.spmApproveitemRepository.findById((Object)itemId).orElse(null);
            vars.put("tenantId", tenantId);
            vars.put("routeToTaskId", startRouteToTaskId);
            assert (item != null);
            TaskModel task = this.activitiOptService.startProcess(processSerialNumber, processDefinitionKey, item.getSystemName(), vars);
            map.put("processInstanceId", task.getProcessInstanceId());
            map.put("processSerialNumber", processSerialNumber);
            map.put("processDefinitionId", task.getProcessDefinitionId());
            map.put("taskId", task.getId());
            map.put("taskDefKey", task.getTaskDefinitionKey());
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            processParam.setProcessInstanceId(task.getProcessInstanceId());
            processParam.setStartor(Y9LoginUserHolder.getPositionId());
            processParam.setStartorName(Y9LoginUserHolder.getPosition().getName());
            processParam.setSended("true");
            this.process4SearchService.saveToDataCenter(tenantId, processParam, Y9LoginUserHolder.getPosition());
            this.processParamService.saveOrUpdate(processParam);
            this.asyncHandleService.startProcessHandle(tenantId, processSerialNumber, task.getId(), task.getProcessInstanceId(), processParam.getSearchTerm());
            map.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25\uff01", (Throwable)e);
        }
        return map;
    }

    @Override
    public Y9Result<Object> submitTo(String processSerialNumber, String taskId) {
        try {
            String multiInstance;
            String routeToTaskName;
            String tenantId = Y9LoginUserHolder.getTenantId();
            String positionId = Y9LoginUserHolder.getPositionId();
            Position position = Y9LoginUserHolder.getPosition();
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            String itemId = processParam.getItemId();
            TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            if (null == task || null == task.getId()) {
                return Y9Result.failure((String)"\u8be5\u4ef6\u5df2\u88ab\u5904\u7406\u3002");
            }
            String processDefinitionId = task.getProcessDefinitionId();
            String taskDefKey = task.getTaskDefinitionKey();
            String processInstanceId = task.getProcessInstanceId();
            Y9Result<TargetModel> routeToTaskIdResult = this.parserRouteToTaskId(itemId, processSerialNumber, processDefinitionId, taskDefKey, taskId);
            if (!routeToTaskIdResult.isSuccess()) {
                return Y9Result.failure((String)routeToTaskIdResult.getMsg());
            }
            String routeToTaskId = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefKey();
            Y9Result<List<String>> userResult = this.parserUser(itemId, processDefinitionId, routeToTaskId, routeToTaskName = ((TargetModel)routeToTaskIdResult.getData()).getTaskDefName(), processInstanceId, multiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, processDefinitionId, routeToTaskId).getData());
            if (!userResult.isSuccess()) {
                return Y9Result.failure((String)userResult.getMsg());
            }
            List userList = (List)userResult.getData();
            Map<String, Object> variables = CommonOpt.setVariables(positionId, position.getName(), routeToTaskId, userList, multiInstance);
            this.asyncHandleService.forwarding4Task(processInstanceId, processParam, "", "", taskId, multiInstance, variables, userList);
            return Y9Result.successMsg((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u63d0\u4ea4\u5931\u8d25\uff01", (Throwable)e);
            return Y9Result.failure((String)"\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }

    @Generated
    public DocumentServiceImpl(ActivitiOptServiceImpl activitiOptService, SpmApproveItemService spmApproveitemService, SpmApproveItemRepository spmApproveitemRepository, ItemTaskConfService taskConfService, ItemPermissionService itemPermissionService, Y9FormItemBindService y9FormItemBindService, ItemButtonBindService buttonItemBindService, TodoTaskApi rpcTodoTaskManager, TaskApi taskManager, CustomGroupApi customGroupApi, ProcessDefinitionApi processDefinitionManager, VariableApi variableManager, OrgUnitApi orgUnitManager, RepositoryApi repositoryManager, PositionApi positionManager, RoleApi roleManager, PositionRoleApi positionRoleApi, DepartmentApi departmentManager, PositionResourceApi positionResourceApi, HistoricProcessApi historicProcessManager, HistoricTaskApi historicTaskManager, RuntimeApi runtimeManager, ProcessParamService processParamService, ProcessTodoApi todoManager, PrintTemplateItemBindRepository printTemplateItemBindRepository, OfficeDoneInfoService officeDoneInfoService, TaskVariableRepository taskVariableRepository, AsyncHandleService asyncHandleService, Y9FormRepository y9FormRepository, Process4SearchService process4SearchService, ErrorLogService errorLogService, ItemStartNodeRoleService itemStartNodeRoleService, ItemTaskConfRepository taskConfRepository, DynamicRoleMemberService dynamicRoleMemberService, ConditionParserApi conditionParserApi, Y9FormService y9FormService, RoleService roleService) {
        this.activitiOptService = activitiOptService;
        this.spmApproveitemService = spmApproveitemService;
        this.spmApproveitemRepository = spmApproveitemRepository;
        this.taskConfService = taskConfService;
        this.itemPermissionService = itemPermissionService;
        this.y9FormItemBindService = y9FormItemBindService;
        this.buttonItemBindService = buttonItemBindService;
        this.rpcTodoTaskManager = rpcTodoTaskManager;
        this.taskManager = taskManager;
        this.customGroupApi = customGroupApi;
        this.processDefinitionManager = processDefinitionManager;
        this.variableManager = variableManager;
        this.orgUnitManager = orgUnitManager;
        this.repositoryManager = repositoryManager;
        this.positionManager = positionManager;
        this.roleManager = roleManager;
        this.positionRoleApi = positionRoleApi;
        this.departmentManager = departmentManager;
        this.positionResourceApi = positionResourceApi;
        this.historicProcessManager = historicProcessManager;
        this.historicTaskManager = historicTaskManager;
        this.runtimeManager = runtimeManager;
        this.processParamService = processParamService;
        this.todoManager = todoManager;
        this.printTemplateItemBindRepository = printTemplateItemBindRepository;
        this.officeDoneInfoService = officeDoneInfoService;
        this.taskVariableRepository = taskVariableRepository;
        this.asyncHandleService = asyncHandleService;
        this.y9FormRepository = y9FormRepository;
        this.process4SearchService = process4SearchService;
        this.errorLogService = errorLogService;
        this.itemStartNodeRoleService = itemStartNodeRoleService;
        this.taskConfRepository = taskConfRepository;
        this.dynamicRoleMemberService = dynamicRoleMemberService;
        this.conditionParserApi = conditionParserApi;
        this.y9FormService = y9FormService;
        this.roleService = roleService;
    }
}

