/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.form;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.entity.form.Y9Table;
import net.risesoft.entity.form.Y9TableField;
import net.risesoft.enums.DialectEnum;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.form.Y9TableFieldRepository;
import net.risesoft.repository.form.Y9TableRepository;
import net.risesoft.util.form.DdlKingbase;
import net.risesoft.util.form.DdlMysql;
import net.risesoft.util.form.DdlOracle;
import net.risesoft.util.form.Y9FormDbMetaDataUtil;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.sqlddl.pojo.DbColumn;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TableManagerService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TableManagerService.class);
    private final JdbcTemplate jdbcTemplate4Tenant;
    private final Y9TableRepository y9TableRepository;
    private final Y9TableFieldRepository y9TableFieldRepository;
    private String[] allFieldName = null;

    public TableManagerService(@Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate4Tenant, Y9TableRepository y9TableRepository, Y9TableFieldRepository y9TableFieldRepository) {
        this.jdbcTemplate4Tenant = jdbcTemplate4Tenant;
        this.y9TableRepository = y9TableRepository;
        this.y9TableFieldRepository = y9TableFieldRepository;
    }

    public Y9Result<Object> addFieldToTable(Y9Table td, List<DbColumn> dbcs) {
        try {
            String tableName = td.getTableName();
            String tableId = td.getId();
            DataSource dataSource = this.jdbcTemplate4Tenant.getDataSource();
            String dialect = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
            if (DialectEnum.MYSQL.getValue().equals(dialect)) {
                DdlMysql ddLmysql = new DdlMysql();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName()) && !td.getOldTableName().equalsIgnoreCase(tableName)) {
                    ddLmysql.renameTable(dataSource, td.getOldTableName(), tableName);
                    td.setOldTableName(td.getTableName());
                    this.saveOrUpdate(td);
                    LOGGER.info("\u4fee\u6539\u8868\u6b63\u5e38");
                }
                ddLmysql.addTableColumn(dataSource, tableName, dbcs);
            } else if (DialectEnum.ORACLE.getValue().equals(dialect)) {
                DdlOracle ddLoracle = new DdlOracle();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName()) && !td.getOldTableName().equalsIgnoreCase(tableName)) {
                    ddLoracle.renameTable(dataSource, td.getOldTableName(), tableName);
                    td.setOldTableName(td.getTableName());
                    this.saveOrUpdate(td);
                    LOGGER.info("\u4fee\u6539\u8868\u6b63\u5e38");
                }
                ddLoracle.addTableColumn(dataSource, tableName, dbcs);
            } else if (DialectEnum.DM.getValue().equals(dialect)) {
                DdlOracle ddLoracle = new DdlOracle();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName()) && !td.getOldTableName().equalsIgnoreCase(tableName)) {
                    ddLoracle.renameTable(dataSource, td.getOldTableName(), tableName);
                    td.setOldTableName(td.getTableName());
                    this.saveOrUpdate(td);
                    LOGGER.info("\u4fee\u6539\u8868\u6b63\u5e38");
                }
                ddLoracle.addTableColumn(dataSource, tableName, dbcs);
            } else if (DialectEnum.KINGBASE.getValue().equals(dialect)) {
                DdlKingbase ddLkingbase = new DdlKingbase();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName()) && !td.getOldTableName().equalsIgnoreCase(tableName)) {
                    ddLkingbase.renameTable(dataSource, td.getOldTableName(), tableName);
                    td.setOldTableName(td.getTableName());
                    this.saveOrUpdate(td);
                    LOGGER.info("\u4fee\u6539\u8868\u6b63\u5e38");
                }
                ddLkingbase.addTableColumn(dataSource, tableName, dbcs);
            }
            this.y9TableFieldRepository.updateState(tableId);
            LOGGER.info("\u4fee\u6539\u5b57\u6bb5\u6b63\u5e38");
            return Y9Result.successMsg((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception ex) {
            LOGGER.warn("\u64cd\u4f5c\u5931\u8d25\uff1a{}", (Throwable)ex);
            return Y9Result.failure((String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public Y9Result<Object> buildTable(Y9Table td, List<DbColumn> dbcs) {
        StringBuilder createSql = new StringBuilder();
        try {
            DdlOracle ddLoracle;
            DataSource dataSource = this.jdbcTemplate4Tenant.getDataSource();
            String dialect = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)dataSource);
            String jsonDbColumns = Y9JsonUtil.writeValueAsString(dbcs);
            if (DialectEnum.MYSQL.getValue().equals(dialect)) {
                DdlMysql ddLmysql = new DdlMysql();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName())) {
                    ddLmysql.dropTable(dataSource, td.getOldTableName());
                }
                ddLmysql.dropTable(dataSource, td.getTableName());
                ddLmysql.createTable(dataSource, td.getTableName(), jsonDbColumns);
            } else if (DialectEnum.ORACLE.getValue().equals(dialect)) {
                ddLoracle = new DdlOracle();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName())) {
                    ddLoracle.dropTable(dataSource, td.getOldTableName());
                }
                ddLoracle.dropTable(dataSource, td.getTableName());
                ddLoracle.createTable(dataSource, td.getTableName(), jsonDbColumns);
            } else if (DialectEnum.DM.getValue().equals(dialect)) {
                ddLoracle = new DdlOracle();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName())) {
                    ddLoracle.dropTable(dataSource, td.getOldTableName());
                }
                ddLoracle.dropTable(dataSource, td.getTableName());
                ddLoracle.createTable(dataSource, td.getTableName(), jsonDbColumns);
            } else if (DialectEnum.KINGBASE.getValue().equals(dialect)) {
                DdlKingbase ddLkingbase = new DdlKingbase();
                if (StringUtils.isNotBlank((CharSequence)td.getOldTableName())) {
                    ddLkingbase.dropTable(dataSource, td.getOldTableName());
                }
                ddLkingbase.dropTable(dataSource, td.getTableName());
                ddLkingbase.createTable(dataSource, td.getTableName(), jsonDbColumns);
            }
            LOGGER.info("\u521b\u5efa\u8868\u6b63\u5e38");
            td.setOldTableName(td.getTableName());
            this.saveOrUpdate(td);
            this.y9TableFieldRepository.updateState(td.getId());
            List fds = this.y9TableFieldRepository.findByTableIdOrderByDisplayOrderAsc(td.getId());
            for (Y9TableField y9TableField : fds) {
                y9TableField.setOldFieldName(y9TableField.getFieldName());
                this.y9TableFieldRepository.save((Object)y9TableField);
            }
            LOGGER.info("\u521b\u5efa\u8868\u53ca\u5b57\u6bb5\u6b63\u5e38");
            return Y9Result.successMsg((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception ex) {
            LOGGER.warn("\u5931\u8d25\u64cd\u4f5c\u8bed\u53e5\uff1a{} ,\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)createSql, (Object)ex);
            return Y9Result.failure((String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void getAllFieldName(String tableId) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.allFieldName != null) {
            return;
        }
        List list1 = this.y9TableFieldRepository.findByTableIdOrderByDisplayOrderAsc(tableId);
        for (Y9TableField y9TableField : list1) {
            list.add(y9TableField.getFieldName());
        }
        if (!list.isEmpty()) {
            this.allFieldName = new String[list.size()];
            this.allFieldName = list.toArray(this.allFieldName);
        }
    }

    protected String getAllPrimaryKeyFields(String tableId) throws Exception {
        StringBuilder primaryKey = new StringBuilder();
        List list = this.y9TableFieldRepository.findByTableIdAndIsSystemFieldOrderByDisplayOrderAsc(tableId, Integer.valueOf(1));
        for (Y9TableField y9TableField : list) {
            String filedName = y9TableField.getFieldName();
            if (!StringUtils.isNotBlank((CharSequence)filedName)) continue;
            if (StringUtils.isEmpty((CharSequence)primaryKey.toString())) {
                primaryKey.append(filedName);
                continue;
            }
            primaryKey.append("," + filedName);
        }
        return primaryKey.toString();
    }

    public Map<String, Object> getDataSourceTableNames() {
        HashMap<String, Object> allNames = new HashMap(16);
        try {
            allNames = Y9FormDbMetaDataUtil.listAllTableNames(this.jdbcTemplate4Tenant.getDataSource());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return allNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getExistTableFields(String tableId) {
        HashMap<String, Object> al = new HashMap<String, Object>(16);
        String tableName = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Y9Table y9Table = this.y9TableRepository.findById((Object)tableId).orElse(null);
            if (y9Table == null) {
                HashMap<String, Object> hashMap = al;
                return hashMap;
            }
            tableName = y9Table.getTableName();
            conn = this.jdbcTemplate4Tenant.getDataSource().getConnection();
            String sql = "show tables like '" + tableName + "'";
            String dialect = Y9FormDbMetaDataUtil.getDatabaseDialectNameByConnection((Connection)conn);
            if (DialectEnum.ORACLE.getValue().equals(dialect)) {
                sql = "SELECT table_name FROM all_tables where table_name = '" + tableName + "'";
            } else if (DialectEnum.DM.getValue().equals(dialect)) {
                sql = "SELECT table_name FROM all_tables where table_name = '" + tableName + "'";
            } else if (DialectEnum.KINGBASE.getValue().equals(dialect)) {
                sql = "SELECT table_name FROM all_tables where table_name = '" + tableName + "'";
            }
            List list = this.jdbcTemplate4Tenant.queryForList(sql);
            if (list == null || list.size() == 0) {
                HashMap<String, Object> hashMap = al;
                return hashMap;
            }
            sql = "Select * from " + tableName + " limit 0,0";
            if (DialectEnum.ORACLE.getValue().equals(dialect)) {
                sql = "Select * from \"" + tableName + "\"  where rownum = 0";
            } else if (DialectEnum.DM.getValue().equals(dialect)) {
                sql = "Select * from \"" + tableName + "\"  where rownum = 0";
            } else if (DialectEnum.KINGBASE.getValue().equals(dialect)) {
                sql = "Select * from \"" + tableName + "\"  where rownum = 0";
            }
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            ResultSetMetaData dt = rs.getMetaData();
            for (int i = 0; i < dt.getColumnCount(); ++i) {
                String fieldName = dt.getColumnName(i + 1).toLowerCase();
                al.put(fieldName, fieldName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return al;
    }

    public String getInsertSqlStatement(String tableName, ArrayList fieldList) {
        boolean isHaveField = false;
        StringBuilder sqlStr = new StringBuilder();
        try {
            List list = Y9FormDbMetaDataUtil.listAllColumns((DataSource)this.jdbcTemplate4Tenant.getDataSource(), (String)tableName, (String)"");
            StringBuilder sqlStr1 = new StringBuilder(") values(");
            sqlStr.append("insert into " + tableName + " (");
            for (DbColumn column : list) {
                fieldList.add(column.getColumnName());
                if (isHaveField) {
                    sqlStr.append(",");
                }
                sqlStr.append(column.getColumnName());
                if (isHaveField) {
                    sqlStr1.append(",");
                }
                sqlStr1.append("?");
                isHaveField = true;
            }
            sqlStr1.append(")");
            sqlStr.append((CharSequence)sqlStr1);
            LOGGER.info("\u8868" + tableName + "\u7684insert\u8bed\u53e5\uff1a" + sqlStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sqlStr.toString();
    }

    public String getPreFieldName(String fieldName) {
        int i;
        String strPreFieldName = null;
        for (i = 0; i < this.allFieldName.length && !this.allFieldName[i].equals(fieldName); ++i) {
        }
        if (i < this.allFieldName.length && i > 0) {
            strPreFieldName = " after " + this.allFieldName[i - 1];
        } else if (i == 0) {
            strPreFieldName = " first";
        }
        if (strPreFieldName == null) {
            strPreFieldName = "";
        }
        return strPreFieldName;
    }

    public String getUpdateSqlStatement(String tableName) {
        boolean isHaveField = false;
        StringBuilder sqlStr = new StringBuilder();
        try {
            List list = Y9FormDbMetaDataUtil.listAllColumns((DataSource)this.jdbcTemplate4Tenant.getDataSource(), (String)tableName, (String)"");
            sqlStr.append("update " + tableName + " set ");
            StringBuilder sqlStr1 = new StringBuilder();
            for (DbColumn column : list) {
                if (column.getPrimaryKey().booleanValue()) {
                    sqlStr1.append(" where " + column.getColumnName() + "=?");
                    continue;
                }
                if (isHaveField) {
                    sqlStr.append(",");
                }
                sqlStr.append(column.getColumnName() + "=?");
                isHaveField = true;
            }
            sqlStr.append((CharSequence)sqlStr1);
            LOGGER.info("\u8868" + tableName + "\u7684update\u8bed\u53e5\uff1a" + sqlStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sqlStr.toString();
    }

    public void saveOrUpdate(Y9Table table) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (StringUtils.isBlank((CharSequence)table.getId())) {
                table.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
            }
            String dialect = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)this.jdbcTemplate4Tenant.getDataSource());
            if (DialectEnum.MYSQL.getValue().equals(dialect)) {
                table.setTableName(table.getTableName().toLowerCase());
            }
            table.setCreateTime(sdf.format(new Date()));
            this.y9TableRepository.save((Object)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Y9TableServiceImpl saveOrUpdate error");
        }
    }
}

