/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.enums.platform.DepartmentPropCategoryEnum;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import y9.client.rest.processadmin.RuntimeApiClient;

@Service
public class StarterDeptManagers
extends AbstractDynamicRoleMember {
    private final PositionApi positionManager;
    private final DepartmentApi departmentApi;
    private final RuntimeApiClient runtimeManager;

    @Override
    public List<OrgUnit> getOrgUnitList(String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            ProcessInstanceModel processInstance = (ProcessInstanceModel)this.runtimeManager.getProcessInstance(tenantId, processInstanceId).getData();
            String userIdAndDeptId = processInstance.getStartUserId();
            if (StringUtils.isNotEmpty((CharSequence)userIdAndDeptId)) {
                String userId = userIdAndDeptId.split(":")[0];
                OrgUnit orgUnit = (OrgUnit)this.positionManager.get(tenantId, userId).getData();
                List leaders = (List)this.departmentApi.listDepartmentPropOrgUnits(tenantId, orgUnit.getParentId(), DepartmentPropCategoryEnum.MANAGER.getValue()).getData();
                orgUnitList.addAll(leaders);
            }
        } else {
            String positionId = Y9LoginUserHolder.getPositionId();
            Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
            List leaders = (List)this.departmentApi.listDepartmentPropOrgUnits(tenantId, position.getParentId(), DepartmentPropCategoryEnum.MANAGER.getValue()).getData();
            orgUnitList.addAll(leaders);
        }
        return orgUnitList;
    }

    @Generated
    public StarterDeptManagers(PositionApi positionManager, DepartmentApi departmentApi, RuntimeApiClient runtimeManager) {
        this.positionManager = positionManager;
        this.departmentApi = departmentApi;
        this.runtimeManager = runtimeManager;
    }
}

