/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.dynamicrole.impl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.entity.ProcessParam;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Position;
import net.risesoft.service.ProcessParamService;
import net.risesoft.service.dynamicrole.AbstractDynamicRoleMember;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CurrentBureau
extends AbstractDynamicRoleMember {
    private final PositionApi positionManager;
    private final OrgUnitApi orgUnitManager;
    private final ProcessParamService processParamService;

    @Override
    public List<OrgUnit> getOrgUnitList() {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String positionId = Y9LoginUserHolder.getPositionId();
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        OrgUnit orgUnit = (OrgUnit)this.orgUnitManager.getBureau(tenantId, position.getParentId()).getData();
        orgUnitList.add(orgUnit);
        return orgUnitList;
    }

    @Override
    public List<OrgUnit> getOrgUnitList(String processInstanceId) {
        ProcessParam processParam;
        String tenantId = Y9LoginUserHolder.getTenantId();
        String positionId = Y9LoginUserHolder.getPositionId();
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        OrgUnit orgUnit = (OrgUnit)this.orgUnitManager.getBureau(tenantId, position.getParentId()).getData();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId) && null != (processParam = this.processParamService.findByProcessInstanceId(processInstanceId)) && StringUtils.isNotBlank((CharSequence)processParam.getBureauIds())) {
            String[] bureauIds;
            for (String bureauId : bureauIds = processParam.getBureauIds().split(";")) {
                if (bureauId.equals(orgUnit.getId())) continue;
                orgUnitList.add((OrgUnit)this.orgUnitManager.getOrgUnit(tenantId, bureauId).getData());
            }
        }
        orgUnitList.add(orgUnit);
        return orgUnitList;
    }

    @Generated
    public CurrentBureau(PositionApi positionManager, OrgUnitApi orgUnitManager, ProcessParamService processParamService) {
        this.positionManager = positionManager;
        this.orgUnitManager = orgUnitManager;
        this.processParamService = processParamService;
    }
}

