/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.processadmin.HistoricProcessApi;
import net.risesoft.entity.ProcInstanceRelationship;
import net.risesoft.model.processadmin.HistoricProcessInstanceModel;
import net.risesoft.repository.jpa.ProcInstanceRelationshipRepository;
import net.risesoft.util.ListUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcInstanceRelationshipService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcInstanceRelationshipService.class);
    private final ProcInstanceRelationshipRepository procInstanceRelationshipRepository;
    private final HistoricProcessApi historicProcessManager;

    public List<ProcInstanceRelationship> findByParentProcInstanceId(String procInstanceId) {
        List<Object> list = new ArrayList<ProcInstanceRelationship>();
        if (StringUtils.isNotBlank((CharSequence)procInstanceId)) {
            list = this.procInstanceRelationshipRepository.findByParentProcInstanceId(procInstanceId);
        }
        return list;
    }

    public List<ProcInstanceRelationship> findByProcDefKey(String processDefinitionKey) {
        List<Object> list = new ArrayList<ProcInstanceRelationship>();
        if (StringUtils.isNotBlank((CharSequence)processDefinitionKey)) {
            list = this.procInstanceRelationshipRepository.findByProcDefKey(processDefinitionKey);
        }
        return list;
    }

    public ProcInstanceRelationship findOne(String procInstanceId) {
        return this.procInstanceRelationshipRepository.findById((Object)procInstanceId).orElse(null);
    }

    public List<String> getAllRelateProcessInstanceIds(String processInstanceId) {
        String superProcessInstanceId;
        String parentProcessInstanceId;
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<String> results = new ArrayList<String>();
        List<String> subProcessInstanceIds = this.getSubProcessInstanceIds(processInstanceId);
        if (subProcessInstanceIds != null && !subProcessInstanceIds.isEmpty()) {
            results.addAll(this.getSubProcessInstanceIds(processInstanceId));
        }
        if (StringUtils.isNotBlank((CharSequence)(parentProcessInstanceId = this.getParentProcInstanceId(processInstanceId)))) {
            results.add(parentProcessInstanceId);
            subProcessInstanceIds = this.getSubProcessInstanceIds(parentProcessInstanceId);
            if (subProcessInstanceIds != null && !subProcessInstanceIds.isEmpty()) {
                results.addAll(subProcessInstanceIds);
            }
        }
        List hpiModel = (List)this.historicProcessManager.getBySuperProcessInstanceId(tenantId, processInstanceId).getData();
        for (HistoricProcessInstanceModel hpi : hpiModel) {
            subProcessInstanceIds.add(hpi.getId());
        }
        if (subProcessInstanceIds != null && !subProcessInstanceIds.isEmpty()) {
            results.addAll(subProcessInstanceIds);
        }
        if (StringUtils.isNotBlank((CharSequence)(superProcessInstanceId = ((HistoricProcessInstanceModel)this.historicProcessManager.getSuperProcessInstanceById(tenantId, processInstanceId).getData()).getId()))) {
            results.add(superProcessInstanceId);
            List hpiModelTemp = (List)this.historicProcessManager.getBySuperProcessInstanceId(tenantId, processInstanceId).getData();
            for (HistoricProcessInstanceModel hpi : hpiModelTemp) {
                subProcessInstanceIds.add(hpi.getId());
            }
            if (subProcessInstanceIds != null && !subProcessInstanceIds.isEmpty()) {
                results.addAll(subProcessInstanceIds);
            }
        }
        ListUtil.removeDuplicateWithOrder(results);
        ListUtil.traversalDel(results, processInstanceId);
        results.add(0, processInstanceId);
        return results;
    }

    public List<String> getAllSubProcessInstanceIds(String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.getSubProcessInstanceIds(processInstanceId));
        List hpiModel = (List)this.historicProcessManager.getBySuperProcessInstanceId(tenantId, processInstanceId).getData();
        ArrayList<String> list = new ArrayList<String>();
        for (HistoricProcessInstanceModel hpi : hpiModel) {
            list.add(hpi.getId());
        }
        results.addAll(list);
        return results;
    }

    public List<String> getAllSuperProcessInstanceIds(String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<String> results = new ArrayList<String>();
        results.add(this.getParentProcInstanceId(processInstanceId));
        results.add(((HistoricProcessInstanceModel)this.historicProcessManager.getSuperProcessInstanceById(tenantId, processInstanceId).getData()).getId());
        return results;
    }

    public String getParentProcInstanceId(String procInstanceId) {
        ProcInstanceRelationship entity = this.findOne(procInstanceId);
        if (entity != null) {
            return entity.getParentProcInstanceId();
        }
        return "";
    }

    public List<String> getProcInstanceIdsByProcDefKey(String processDefinitionKey) {
        ArrayList<String> result = new ArrayList<String>();
        List<ProcInstanceRelationship> list = this.findByProcDefKey(processDefinitionKey);
        for (ProcInstanceRelationship entity : list) {
            result.add(entity.getProcInstanceId());
        }
        return result;
    }

    public int getSubProcessInstanceIdCount(String processInstanceId) {
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            return this.procInstanceRelationshipRepository.getSubProcessInstanceIdCount(processInstanceId);
        }
        return 0;
    }

    public List<String> getSubProcessInstanceIds(String processInstanceId) {
        ArrayList<String> list = new ArrayList<String>();
        List<ProcInstanceRelationship> entityList = this.findByParentProcInstanceId(processInstanceId);
        for (ProcInstanceRelationship entity : entityList) {
            list.add(entity.getProcInstanceId());
        }
        return list;
    }

    public boolean isSubProcessInstance(String processInstanceId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        int count = 0;
        count = this.getSubProcessInstanceIdCount(processInstanceId);
        if (count > 0) {
            return true;
        }
        List hpiModelTemp = (List)this.historicProcessManager.getBySuperProcessInstanceId(tenantId, processInstanceId).getData();
        count = hpiModelTemp.size();
        return count > 0;
    }

    public void save(String procInstanceId, String parentProcInstanceId, String procDefinitionKey) {
        ProcInstanceRelationship entity = this.setCommon(procInstanceId, parentProcInstanceId, procDefinitionKey);
        try {
            this.procInstanceRelationshipRepository.save((Object)entity);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u6d41\u7a0b\u5173\u7cfb\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public ProcInstanceRelationship setCommon(String procInstanceId, String parentProcInstanceId, String procDefinitionKey) {
        ProcInstanceRelationship entity = new ProcInstanceRelationship();
        entity.setProcInstanceId(procInstanceId);
        entity.setParentProcInstanceId(parentProcInstanceId);
        entity.setProcDefinitionKey(procDefinitionKey);
        return entity;
    }

    @Generated
    public ProcInstanceRelationshipService(ProcInstanceRelationshipRepository procInstanceRelationshipRepository, HistoricProcessApi historicProcessManager) {
        this.procInstanceRelationshipRepository = procInstanceRelationshipRepository;
        this.historicProcessManager = historicProcessManager;
    }
}

