/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.entity.Y9FormItemMobileBind;
import net.risesoft.entity.form.Y9FieldPerm;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.form.Y9FieldPermRepository;
import net.risesoft.repository.jpa.Y9FormItemBindRepository;
import net.risesoft.repository.jpa.Y9FormItemMobileBindRepository;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/y9form/fieldPerm"}, produces={"application/json"})
public class Y9FieldPermController {
    private final Y9FormItemBindRepository y9FormItemBindRepository;
    private final Y9FormItemMobileBindRepository y9FormItemMobileBindRepository;
    private final Y9FieldPermRepository y9FieldPermRepository;
    private final ProcessDefinitionApi processDefinitionManager;

    @GetMapping(value={"/countPerm"})
    public Y9Result<Boolean> countPerm(@RequestParam String formId, @RequestParam String fieldName) {
        int count = this.y9FieldPermRepository.countByFormIdAndFieldName(formId, fieldName);
        return Y9Result.success((Object)(count != 0 ? 1 : 0), (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/deleteRole"})
    public Y9Result<String> deleteRole(@RequestParam String formId, @RequestParam String fieldName, @RequestParam(required=false) String taskDefKey) {
        Y9FieldPerm y9FieldPerm = this.y9FieldPermRepository.findByFormIdAndFieldNameAndTaskDefKey(formId, fieldName, taskDefKey);
        if (y9FieldPerm != null) {
            y9FieldPerm.setWriteRoleId("");
            y9FieldPerm.setWriteRoleName("");
            this.y9FieldPermRepository.save((Object)y9FieldPerm);
        }
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/delNodePerm"})
    public Y9Result<String> delNodePerm(@RequestParam String formId, @RequestParam String fieldName, @RequestParam(required=false) String taskDefKey) {
        Y9FieldPerm y9FieldPerm = this.y9FieldPermRepository.findByFormIdAndFieldNameAndTaskDefKey(formId, fieldName, taskDefKey);
        if (y9FieldPerm != null) {
            this.y9FieldPermRepository.delete((Object)y9FieldPerm);
        }
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getAllPerm"})
    public Y9Result<List<String>> getAllPerm(@RequestParam String formId) {
        List list = this.y9FieldPermRepository.findByFormId(formId);
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<Map<String, Object>>> getBpmList(@RequestParam String formId, @RequestParam String fieldName) {
        List bindList1;
        ArrayList resList = new ArrayList();
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList<String> list = new ArrayList<String>();
        list.add(formId);
        List bindList = this.y9FormItemBindRepository.findByFormIdList(list);
        String processDefinitionId = "";
        if (!bindList.isEmpty()) {
            processDefinitionId = ((Y9FormItemBind)bindList.get(0)).getProcessDefinitionId();
        }
        if (bindList.isEmpty() && !(bindList1 = this.y9FormItemMobileBindRepository.findByFormIdList(list)).isEmpty()) {
            processDefinitionId = ((Y9FormItemMobileBind)bindList1.get(0)).getProcessDefinitionId();
        }
        if (StringUtils.isNotBlank((CharSequence)processDefinitionId)) {
            List targetList = (List)this.processDefinitionManager.getNodes(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
            for (TargetModel targetModel : targetList) {
                Y9FieldPerm y9FieldPerm = this.y9FieldPermRepository.findByFormIdAndFieldNameAndTaskDefKey(formId, fieldName, targetModel.getTaskDefKey());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("writeRoleId", y9FieldPerm != null ? y9FieldPerm.getWriteRoleId() : "");
                map.put("writeRoleName", y9FieldPerm != null ? y9FieldPerm.getWriteRoleName() : "");
                map.put("id", y9FieldPerm != null ? y9FieldPerm.getId() : "");
                map.put("taskDefKey", targetModel.getTaskDefKey());
                map.put("taskDefName", targetModel.getTaskDefName());
                resList.add(map);
            }
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveNodePerm"})
    public Y9Result<String> saveNodePerm(@RequestParam String formId, @RequestParam String fieldName, @RequestParam(required=false) String taskDefKey) {
        Y9FieldPerm y9FieldPerm;
        List bindList1;
        String processDefinitionId = "";
        ArrayList<String> list = new ArrayList<String>();
        list.add(formId);
        List bindList = this.y9FormItemBindRepository.findByFormIdList(list);
        if (!bindList.isEmpty()) {
            processDefinitionId = ((Y9FormItemBind)bindList.get(0)).getProcessDefinitionId();
        }
        if (bindList.isEmpty() && !(bindList1 = this.y9FormItemMobileBindRepository.findByFormIdList(list)).isEmpty()) {
            processDefinitionId = ((Y9FormItemMobileBind)bindList1.get(0)).getProcessDefinitionId();
        }
        if ((y9FieldPerm = this.y9FieldPermRepository.findByFormIdAndFieldNameAndTaskDefKey(formId, fieldName, taskDefKey)) == null) {
            y9FieldPerm = new Y9FieldPerm();
            y9FieldPerm.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        }
        y9FieldPerm.setFieldName(fieldName);
        y9FieldPerm.setFormId(formId);
        y9FieldPerm.setProcessDefinitionId(processDefinitionId);
        y9FieldPerm.setTaskDefKey(taskDefKey);
        this.y9FieldPermRepository.save((Object)y9FieldPerm);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveRoleChoice"})
    public Y9Result<String> saveRoleChoice(@RequestParam String formId, @RequestParam String fieldName, @RequestParam(required=false) String taskDefKey, @RequestParam String roleNames, @RequestParam String roleIds) {
        Y9FieldPerm y9FieldPerm;
        String processDefinitionId = "";
        ArrayList<String> list = new ArrayList<String>();
        list.add(formId);
        List bindList = this.y9FormItemBindRepository.findByFormIdList(list);
        if (!bindList.isEmpty()) {
            processDefinitionId = ((Y9FormItemBind)bindList.get(0)).getProcessDefinitionId();
        }
        if ((y9FieldPerm = this.y9FieldPermRepository.findByFormIdAndFieldNameAndTaskDefKey(formId, fieldName, taskDefKey)) == null) {
            y9FieldPerm = new Y9FieldPerm();
            y9FieldPerm.setId(Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE));
        }
        y9FieldPerm.setFieldName(fieldName);
        y9FieldPerm.setFormId(formId);
        y9FieldPerm.setProcessDefinitionId(processDefinitionId);
        y9FieldPerm.setTaskDefKey(taskDefKey);
        y9FieldPerm.setWriteRoleId(roleIds);
        y9FieldPerm.setWriteRoleName(roleNames);
        this.y9FieldPermRepository.save((Object)y9FieldPerm);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public Y9FieldPermController(Y9FormItemBindRepository y9FormItemBindRepository, Y9FormItemMobileBindRepository y9FormItemMobileBindRepository, Y9FieldPermRepository y9FieldPermRepository, ProcessDefinitionApi processDefinitionManager) {
        this.y9FormItemBindRepository = y9FormItemBindRepository;
        this.y9FormItemMobileBindRepository = y9FormItemMobileBindRepository;
        this.y9FieldPermRepository = y9FieldPermRepository;
        this.processDefinitionManager = processDefinitionManager;
    }
}

