/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.entity.form.Y9Table;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.form.Y9TableService;
import net.risesoft.util.form.Y9FormDbMetaDataUtil;
import net.risesoft.y9.json.Y9JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/y9form/table"}, produces={"application/json"})
public class TableRestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TableRestController.class);
    private final JdbcTemplate jdbcTemplate4Tenant;
    private final Y9TableService y9TableService;

    public TableRestController(@Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate4Tenant, Y9TableService y9TableService) {
        this.jdbcTemplate4Tenant = jdbcTemplate4Tenant;
        this.y9TableService = y9TableService;
    }

    @PostMapping(value={"/addDataBaseTable"})
    public Y9Result<Object> addDataBaseTable(@RequestParam String tableName, @RequestParam String systemName, @RequestParam String systemCnName) {
        return this.y9TableService.addDataBaseTable(tableName, systemName, systemCnName);
    }

    @PostMapping(value={"/buildTable"})
    public Y9Result<Object> buildTable(@RequestParam String tables, @RequestParam String fields) {
        Y9Table table = (Y9Table)Y9JsonUtil.readValue((String)tables, Y9Table.class);
        List listMap = Y9JsonUtil.readListOfMap((String)fields, String.class, Object.class);
        return this.y9TableService.buildTable(table, listMap);
    }

    @GetMapping(value={"/checkTableExist"})
    public Y9Result<String> checkTableExist(@RequestParam String tableName) {
        try {
            boolean msg = Y9FormDbMetaDataUtil.checkTableExist((DataSource)Objects.requireNonNull(this.jdbcTemplate4Tenant.getDataSource()), (String)tableName);
            return Y9Result.success((Object)(msg ? "exist" : "isNotExist"), (String)"\u83b7\u53d6\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getAllTables"})
    public Y9Result<Map<String, Object>> getAllTables(@RequestParam(required=false) String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Map<String, String>> list = this.y9TableService.getAllTables(name);
        String tableNames = this.y9TableService.getAlltableName();
        map.put("rows", list);
        map.put("tableNames", tableNames);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getAppList"})
    public Y9Result<List<Map<String, Object>>> getAppList() {
        List<Map<String, Object>> list = this.y9TableService.listApps();
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getTables"})
    public Y9Page<Y9Table> getTables(@RequestParam(required=false) String systemName, @RequestParam int page, @RequestParam int rows) {
        return this.y9TableService.pageTables(systemName, page, rows);
    }

    @GetMapping(value={"/newOrModifyTable"})
    public Y9Result<Map<String, Object>> newOrModifyTable(@RequestParam(required=false) String id) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        try {
            String databaseName = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)Objects.requireNonNull(this.jdbcTemplate4Tenant.getDataSource()));
            map.put("databaseName", databaseName);
            if (StringUtils.isNotBlank((CharSequence)id) && !"null".equals(id)) {
                Y9Table y9Table = this.y9TableService.findById(id);
                map.put("y9Table", (String)y9Table);
            }
            String tableNames = this.y9TableService.getAlltableName();
            map.put("tableNames", tableNames);
            return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u5931\u8d25");
        }
    }

    @PostMapping(value={"/removeTable"})
    public Y9Result<Object> removeTable(@RequestParam String ids) {
        return this.y9TableService.delete(ids);
    }

    @PostMapping(value={"/saveTable"})
    public Y9Result<Object> saveTable(@RequestParam(required=false) String tables, @RequestParam(required=false) String fields) {
        List listMap = Y9JsonUtil.readListOfMap((String)fields, String.class, Object.class);
        Y9Table table = (Y9Table)Y9JsonUtil.readValue((String)tables, Y9Table.class);
        return this.y9TableService.updateTable(table, listMap, "save");
    }

    @PostMapping(value={"/updateTable"})
    public Y9Result<Object> updateTable(@RequestParam String tables, @RequestParam String fields) {
        Y9Table table = (Y9Table)Y9JsonUtil.readValue((String)tables, Y9Table.class);
        List listMap = Y9JsonUtil.readListOfMap((String)fields, String.class, Object.class);
        return this.y9TableService.updateTable(table, listMap, "");
    }
}

