/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.entity.form.Y9TableField;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.form.Y9TableFieldService;
import net.risesoft.util.form.Y9FormDbMetaDataUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/y9form/tableField"}, produces={"application/json"})
public class TableFieldRestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TableFieldRestController.class);
    private final JdbcTemplate jdbcTemplate4Tenant;
    private final Y9TableFieldService y9TableFieldService;

    public TableFieldRestController(@Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate4Tenant, Y9TableFieldService y9TableFieldService) {
        this.jdbcTemplate4Tenant = jdbcTemplate4Tenant;
        this.y9TableFieldService = y9TableFieldService;
    }

    @PostMapping(value={"/delete"})
    public Y9Result<String> delete(@RequestParam String id) {
        this.y9TableFieldService.delete(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getTableFieldList"})
    public Y9Result<List<Y9TableField>> getTableFieldList(@RequestParam String tableId) {
        List<Y9TableField> map = this.y9TableFieldService.listByTableId(tableId);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/newOrModifyField"})
    public Y9Result<Map<String, Object>> newOrModifyField(@RequestParam(required=false) String id, @RequestParam String tableId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("tableId", tableId);
        if (StringUtils.isNotBlank((CharSequence)id) && !"null".equals(id)) {
            Y9TableField field = this.y9TableFieldService.findById(id);
            if (field != null) {
                String type = field.getFieldType().substring(0, field.getFieldType().indexOf("("));
                field.setFieldType(type);
            }
            map.put("id", id);
            map.put("field", field);
        }
        try {
            List<Map<String, Object>> list = Y9FormDbMetaDataUtil.listTypes(Objects.requireNonNull(this.jdbcTemplate4Tenant.getDataSource()));
            map.put("typeList", list);
            String databaseName = Y9FormDbMetaDataUtil.getDatabaseDialectName((DataSource)Objects.requireNonNull(this.jdbcTemplate4Tenant.getDataSource()));
            map.put("databaseName", databaseName);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u5931\u8d25");
        }
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/saveField"})
    public Y9Result<String> saveField(Y9TableField field) {
        try {
            this.y9TableFieldService.saveOrUpdate(field);
            return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }
}

