/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.form;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.entity.form.Y9Form;
import net.risesoft.entity.form.Y9FormField;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.form.Y9FormFieldService;
import net.risesoft.service.form.Y9FormService;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/y9form"}, produces={"application/json"})
public class FormRestController {
    private final Y9FormService y9FormService;
    private final Y9FormFieldService y9FormFieldService;

    @PostMapping(value={"/deleteFormFieldBind"})
    public Y9Result<String> deleteFormFieldBind(@RequestParam @NotBlank String id) {
        return this.y9FormFieldService.deleteFormFieldBind(id);
    }

    @GetMapping(value={"/getForm"})
    public Y9Result<Map<String, Object>> getForm(@RequestParam String id) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Y9Form y9Form = this.y9FormService.findById(id);
        String json = this.y9FormService.getFormField(id);
        map.put("y9Form", y9Form);
        map.put("formField", json);
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getFormBindFieldList"})
    public Y9Page<Y9FormField> getFormBindFieldList(@RequestParam String formId, @RequestParam Integer page, @RequestParam Integer rows) {
        Page<Y9FormField> pageList = this.y9FormFieldService.pageByFormId(formId, page, rows);
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u8868\u5355\u7ed1\u5b9a\u7684\u4e1a\u52a1\u8868\u5b57\u6bb5\u5217\u8868\u6210\u529f");
    }

    @GetMapping(value={"/getFormList"})
    public Y9Page<Map<String, Object>> getFormList(@RequestParam(required=false) String systemName, @RequestParam int page, @RequestParam int rows) {
        return this.y9FormService.pageFormList(systemName, page, rows);
    }

    @PostMapping(value={"/newOrModifyForm"})
    public Y9Result<Object> newOrModifyForm(Y9Form form) {
        return this.y9FormService.saveOrUpdate(form);
    }

    @PostMapping(value={"/removeForm"})
    public Y9Result<Object> removeForm(@RequestParam String ids) {
        return this.y9FormService.delete(ids);
    }

    @PostMapping(value={"/saveFormField"})
    public Y9Result<Object> saveFormField(@RequestParam String formId, @RequestParam(required=false) String fieldJson) {
        return this.y9FormService.saveFormField(formId, fieldJson);
    }

    @PostMapping(value={"/saveFormJson"})
    public Y9Result<Object> saveFormJson(@RequestParam String id, @RequestParam(required=false) String formJson) {
        return this.y9FormService.saveFormJson(id, formJson);
    }

    @Generated
    public FormRestController(Y9FormService y9FormService, Y9FormFieldService y9FormFieldService) {
        this.y9FormService = y9FormService;
        this.y9FormFieldService = y9FormFieldService;
    }
}

