/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.config;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.entity.ItemOpinionFrameBind;
import net.risesoft.entity.ItemOpinionFrameRole;
import net.risesoft.entity.OpinionFrameOneClickSet;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.model.processadmin.TargetModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.OpinionFrameOneClickSetService;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.service.config.ItemOpinionFrameBindService;
import net.risesoft.service.config.ItemOpinionFrameRoleService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/vue/itemOpinionFrameBind"}, produces={"application/json"})
public class ItemOpinionFrameBindRestController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemOpinionFrameBindRestController.class);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final ItemOpinionFrameBindService itemOpinionFrameBindService;
    private final ItemOpinionFrameRoleService itemOpinionFrameRoleService;
    private final ProcessDefinitionApi processDefinitionManager;
    private final SpmApproveItemService spmApproveItemService;
    private final OpinionFrameOneClickSetService opinionFrameOneClickSetService;

    @PostMapping(value={"/bindOpinionFrame"})
    public Y9Result<String> bindOpinionFrame(@RequestParam String opinionFrameNameAndMarks, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        this.itemOpinionFrameBindService.save(opinionFrameNameAndMarks, itemId, processDefinitionId, taskDefKey);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/changeSignOpinion"})
    public Y9Result<String> changeSignOpinion(String id, boolean signOpinion) {
        this.itemOpinionFrameBindService.changeSignOpinion(id, signOpinion);
        return Y9Result.successMsg((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/copyBind"})
    public Y9Result<String> copyBind(@RequestParam String itemId, @RequestParam String processDefinitionId) {
        this.itemOpinionFrameBindService.copyBind(itemId, processDefinitionId);
        return Y9Result.successMsg((String)"\u590d\u5236\u6210\u529f");
    }

    @PostMapping(value={"/delOneClickSet"})
    public Y9Result<String> delOneClickSet(String id) {
        try {
            this.opinionFrameOneClickSetService.delete(id);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u4e00\u952e\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
            Y9Result.failure((String)"\u5220\u9664\u4e00\u952e\u8bbe\u7f6e\u5931\u8d25");
        }
        return Y9Result.successMsg((String)"\u5220\u9664\u4e00\u952e\u8bbe\u7f6e\u6210\u529f");
    }

    @GetMapping(value={"/getBindList"})
    public Y9Result<List<ItemOpinionFrameBind>> getBindList(@RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam(required=false) String taskDefKey) {
        List<ItemOpinionFrameBind> oftrbList = this.itemOpinionFrameBindService.listByItemIdAndProcessDefinitionIdAndTaskDefKeyContainRole(itemId, processDefinitionId, taskDefKey);
        return Y9Result.success(oftrbList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBindListByMark"})
    public Y9Result<List<Map<String, Object>>> getBindListByMark(@RequestParam String mark) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List<ItemOpinionFrameBind> oftrbList = this.itemOpinionFrameBindService.listByMark(mark);
        ArrayList bindList = new ArrayList();
        for (ItemOpinionFrameBind bind : oftrbList) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", bind.getId());
            SpmApproveItem item = this.spmApproveItemService.findById(bind.getItemId());
            map.put("itemName", null == item ? "\u4e8b\u9879\u4e0d\u5b58\u5728" : item.getName());
            map.put("processDefinitionId", bind.getProcessDefinitionId());
            List<ItemOpinionFrameRole> roleList = this.itemOpinionFrameRoleService.listByItemOpinionFrameIdContainRoleName(bind.getId());
            String roleNames = "";
            for (ItemOpinionFrameRole role : roleList) {
                if (StringUtils.isEmpty((CharSequence)roleNames)) {
                    roleNames = role.getRoleName();
                    continue;
                }
                roleNames = roleNames + "\u3001" + role.getRoleName();
            }
            map.put("roleNames", StringUtils.isEmpty((CharSequence)roleNames) ? "\u672a\u7ed1\u5b9a\u89d2\u8272\uff08\u6240\u6709\u4eba\u90fd\u53ef\u4ee5\u7b7e\u5199\uff09" : roleNames);
            String taskDefName = "\u6574\u4e2a\u6d41\u7a0b";
            if (StringUtils.isNotEmpty((CharSequence)bind.getTaskDefKey())) {
                List list = (List)this.processDefinitionManager.getNodes(tenantId, bind.getProcessDefinitionId(), Boolean.valueOf(false)).getData();
                for (TargetModel targetModel : list) {
                    if (!targetModel.getTaskDefKey().equals(bind.getTaskDefKey())) continue;
                    taskDefName = targetModel.getTaskDefName();
                }
            }
            map.put("taskDefKey", taskDefName + (StringUtils.isEmpty((CharSequence)bind.getTaskDefKey()) ? "" : "(" + bind.getTaskDefKey() + ")"));
            bindList.add(map);
        }
        return Y9Result.success(bindList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getBpmList"})
    public Y9Result<List<TargetModel>> getBpmList(@RequestParam String processDefinitionId, @RequestParam String itemId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List list = (List)this.processDefinitionManager.getNodes(tenantId, processDefinitionId, Boolean.valueOf(false)).getData();
        for (TargetModel targetModel : list) {
            StringBuilder opinionFrameNames = new StringBuilder();
            List<ItemOpinionFrameBind> bindList = this.itemOpinionFrameBindService.listByItemIdAndProcessDefinitionIdAndTaskDefKey(itemId, processDefinitionId, targetModel.getTaskDefKey());
            for (ItemOpinionFrameBind bind : bindList) {
                if (StringUtils.isEmpty((CharSequence)opinionFrameNames)) {
                    opinionFrameNames.append(bind.getOpinionFrameName());
                    continue;
                }
                opinionFrameNames.append("\u3001" + bind.getOpinionFrameName());
            }
            targetModel.setOpinionFrameNames(opinionFrameNames.toString());
        }
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOneClickSetBindList"})
    public Y9Result<List<OpinionFrameOneClickSet>> getOneClickSetBindList(@RequestParam(required=true) String bindId) {
        List<Object> bindList = new ArrayList();
        try {
            bindList = this.opinionFrameOneClickSetService.findByBindId(bindId);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u610f\u89c1\u6846\u7ed1\u5b9a\u7684\u4e00\u952e\u8bbe\u7f6e\u5217\u8868\u5931\u8d25", (Throwable)e);
            Y9Result.failure((String)"\u83b7\u53d6\u610f\u89c1\u6846\u7ed1\u5b9a\u7684\u4e00\u952e\u8bbe\u7f6e\u5217\u8868\u5931\u8d25");
        }
        return Y9Result.success(bindList, (String)"\u83b7\u53d6\u610f\u89c1\u6846\u7ed1\u5b9a\u7684\u4e00\u952e\u8bbe\u7f6e\u5217\u8868\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String[] ids) {
        this.itemOpinionFrameBindService.delete(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveModify"})
    public Y9Result<String> saveModify(@RequestParam String id, @RequestParam String opinionFrameNameAndMarks) {
        ItemOpinionFrameBind opinionBind = this.itemOpinionFrameBindService.getById(id);
        String[] opinionFrameNameAndMark = opinionFrameNameAndMarks.split(":");
        String name = opinionFrameNameAndMark[0];
        String mark = opinionFrameNameAndMark[1];
        opinionBind.setOpinionFrameMark(mark);
        opinionBind.setOpinionFrameName(name);
        opinionBind.setModifyDate(this.sdf.format(new Date()));
        this.itemOpinionFrameBindService.save(opinionBind);
        return Y9Result.successMsg((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/saveOneClickSet"})
    public Y9Result<Map<String, Object>> saveOneClickSet1(@Validated OpinionFrameOneClickSet opinionFrameOneClickSet) {
        Map<Object, Object> map = new HashMap();
        try {
            map = this.opinionFrameOneClickSetService.save(opinionFrameOneClickSet);
        }
        catch (Exception e) {
            LOGGER.error("\u4e00\u952e\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
            Y9Result.failure((String)"\u4e00\u952e\u8bbe\u7f6e\u5931\u8d25");
        }
        return Y9Result.success(map, (String)map.get("msg").toString());
    }

    @Generated
    public ItemOpinionFrameBindRestController(ItemOpinionFrameBindService itemOpinionFrameBindService, ItemOpinionFrameRoleService itemOpinionFrameRoleService, ProcessDefinitionApi processDefinitionManager, SpmApproveItemService spmApproveItemService, OpinionFrameOneClickSetService opinionFrameOneClickSetService) {
        this.itemOpinionFrameBindService = itemOpinionFrameBindService;
        this.itemOpinionFrameRoleService = itemOpinionFrameRoleService;
        this.processDefinitionManager = processDefinitionManager;
        this.spmApproveItemService = spmApproveItemService;
        this.opinionFrameOneClickSetService = opinionFrameOneClickSetService;
    }
}

