/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.ManagerApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.entity.TaoHongTemplate;
import net.risesoft.entity.TaoHongTemplateType;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.Manager;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.TaoHongTemplateService;
import net.risesoft.service.TaoHongTemplateTypeService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/vue/taoHongTemplate"}, produces={"application/json"})
public class TaoHongTemplateRestContronller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TaoHongTemplateRestContronller.class);
    private final TaoHongTemplateService taoHongTemplateService;
    private final TaoHongTemplateTypeService taoHongTemplateTypeService;
    private final OrgUnitApi orgUnitApi;
    private final ManagerApi managerApi;
    private final DepartmentApi departmentApi;

    @GetMapping(value={"/bureauTree"})
    public Y9Result<List<Department>> bureauTree(@RequestParam(required=false) String name) {
        name = StringUtils.isBlank((CharSequence)name) ? "" : name;
        return this.departmentApi.listBureauByNameLike(Y9LoginUserHolder.getTenantId(), name);
    }

    @RequestMapping(value={"/download"})
    public void download(@RequestParam String templateGuid, HttpServletRequest request, HttpServletResponse response) {
        try {
            TaoHongTemplate taoHongTemplate = this.taoHongTemplateService.getById(templateGuid);
            byte[] b = taoHongTemplate.getTemplateContent();
            int length = b.length;
            String filename = taoHongTemplate.getTemplateFileName();
            String userAgent = "User-Agent";
            String firefox = "firefox";
            String msie = "MSIE";
            filename = request.getHeader(userAgent).toLowerCase().indexOf(firefox) > 0 ? new String(filename.getBytes(StandardCharsets.UTF_8), "ISO8859-1") : (request.getHeader(userAgent).toUpperCase().indexOf(msie) > 0 ? URLEncoder.encode(filename, "UTF-8") : URLEncoder.encode(filename, "UTF-8"));
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.setHeader("Content-Length", String.valueOf(length));
            IOUtils.write((byte[])b, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (Exception e) {
            LOGGER.error("\u4e0b\u8f7d\u5957\u7ea2\u5931\u8d25", (Throwable)e);
        }
    }

    @GetMapping(value={"/getList"})
    public Y9Result<List<Map<String, Object>>> getList(@RequestParam(required=false) String name) {
        List<TaoHongTemplate> list;
        UserInfo person = Y9LoginUserHolder.getUserInfo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (person.isGlobalManager()) {
            list = this.taoHongTemplateService.listByTenantId(Y9LoginUserHolder.getTenantId(), StringUtils.isBlank((CharSequence)name) ? "%%" : "%" + name + "%");
        } else {
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getBureau(Y9LoginUserHolder.getTenantId(), person.getPersonId()).getData();
            list = this.taoHongTemplateService.listByBureauGuid(orgUnit.getId());
        }
        ArrayList items = new ArrayList();
        for (TaoHongTemplate taoHongTemplate : list) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("templateGuid", taoHongTemplate.getTemplateGuid());
            map.put("template_fileName", taoHongTemplate.getTemplateFileName());
            map.put("bureauName", taoHongTemplate.getBureauName());
            map.put("templateType", taoHongTemplate.getTemplateType());
            map.put("uploadTime", sdf.format(taoHongTemplate.getUploadTime()));
            String userId = taoHongTemplate.getUserId();
            Manager manger = (Manager)this.managerApi.get(Y9LoginUserHolder.getTenantId(), userId).getData();
            map.put("userName", manger != null ? manger.getName() : "\u4eba\u5458\u4e0d\u5b58\u5728");
            map.put("tabIndex", taoHongTemplate.getTabIndex());
            items.add(map);
        }
        return Y9Result.success(items, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/newOrModify"})
    public Y9Result<Map<String, Object>> newOrModify(@RequestParam(required=false) String id) {
        List<TaoHongTemplateType> typeList;
        UserInfo person = Y9LoginUserHolder.getUserInfo();
        String tenantId = Y9LoginUserHolder.getTenantId();
        String personId = person.getPersonId();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("tenantManager", person.isGlobalManager());
        if (person.isGlobalManager()) {
            typeList = this.taoHongTemplateTypeService.listAll();
        } else {
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getBureau(tenantId, personId).getData();
            map.put("bureauGuid", orgUnit.getId());
            map.put("bureauName", orgUnit.getName());
            typeList = this.taoHongTemplateTypeService.listByBureauId(orgUnit.getId());
        }
        map.put("typeList", typeList);
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            TaoHongTemplate taoHongTemplate = this.taoHongTemplateService.getById(id);
            map.put("taoHongTemplate", taoHongTemplate);
        }
        return Y9Result.success(map, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeTaoHongTemplate"})
    public Y9Result<String> removeTaoHongTemplate(@RequestParam String[] ids) {
        this.taoHongTemplateService.removeTaoHongTemplate(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(@RequestParam(required=false) String templateGuid, @RequestParam String bureauGuid, @RequestParam String bureauName, @RequestParam String templateType, MultipartFile file) {
        try {
            TaoHongTemplate taoHong = new TaoHongTemplate();
            taoHong.setBureauGuid(bureauGuid);
            taoHong.setBureauName(bureauName);
            taoHong.setTemplateGuid(templateGuid);
            taoHong.setTemplateType(templateType);
            if (file != null) {
                String[] fileName = Objects.requireNonNull(file.getOriginalFilename()).split("\\\\");
                taoHong.setTemplateContent(file.getBytes());
                if (fileName.length > 1) {
                    taoHong.setTemplateFileName(fileName[fileName.length - 1]);
                } else {
                    taoHong.setTemplateFileName(file.getOriginalFilename());
                }
            }
            this.taoHongTemplateService.saveOrUpdate(taoHong);
            return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5957\u7ea2\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @Generated
    public TaoHongTemplateRestContronller(TaoHongTemplateService taoHongTemplateService, TaoHongTemplateTypeService taoHongTemplateTypeService, OrgUnitApi orgUnitApi, ManagerApi managerApi, DepartmentApi departmentApi) {
        this.taoHongTemplateService = taoHongTemplateService;
        this.taoHongTemplateTypeService = taoHongTemplateTypeService;
        this.orgUnitApi = orgUnitApi;
        this.managerApi = managerApi;
        this.departmentApi = departmentApi;
    }
}

