/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.platform.org.DepartmentApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.ReceiveDepartment;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ReceiveDepartmentRepository;
import net.risesoft.service.ReceiveDeptAndPersonService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/sendReceive"}, produces={"application/json"})
public class SendReceiveRestController {
    private final ReceiveDeptAndPersonService receiveDeptAndPersonService;
    private final OrganizationApi organizationManager;
    private final OrgUnitApi orgUnitManager;
    private final PersonApi personManager;
    private final DepartmentApi departmentManager;
    private final ReceiveDepartmentRepository receiveDepartmentRepository;

    @PostMapping(value={"/checkReceiveSend"})
    public Y9Result<String> checkReceiveSend(@RequestParam String deptId) {
        ReceiveDepartment receiveDept = this.receiveDeptAndPersonService.findByDeptId(deptId);
        if (receiveDept != null) {
            return Y9Result.successMsg((String)"true");
        }
        return Y9Result.failure((String)"false");
    }

    @PostMapping(value={"/delPerson"})
    public Y9Result<String> delPerson(@RequestParam String id) {
        return this.receiveDeptAndPersonService.delPerson(id);
    }

    @GetMapping(value={"/deptTreeSearch"})
    public Y9Result<List<Map<String, Object>>> deptTreeSearch(@RequestParam(required=false) String name, @RequestParam String deptId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        ArrayList item = new ArrayList();
        List personList = (List)this.personManager.listRecursivelyByParentIdAndName(tenantId, deptId, name).getData();
        ArrayList<OrgUnit> orgUnitList = new ArrayList<OrgUnit>();
        for (Person person : personList) {
            orgUnitList.add((OrgUnit)person);
            Person p = (Person)this.personManager.get(tenantId, person.getId()).getData();
            this.recursionUpToOrg(tenantId, deptId, p.getParentId(), orgUnitList, false);
        }
        for (OrgUnit orgUnit : orgUnitList) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", orgUnit.getId());
            map.put("name", orgUnit.getName());
            map.put("orgType", orgUnit.getOrgType());
            map.put("parentId", orgUnit.getParentId());
            map.put("isParent", true);
            if (OrgTypeEnum.PERSON.equals((Object)orgUnit.getOrgType())) {
                Person per = (Person)this.personManager.get(Y9LoginUserHolder.getTenantId(), orgUnit.getId()).getData();
                map.put("sex", per.getSex());
                map.put("duty", per.getDuty());
                map.put("isParent", false);
            }
            item.add(map);
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getDeptTree"})
    public Y9Result<List<Map<String, Object>>> getDeptTrees(@RequestParam(required=false) String id, @RequestParam(required=false) String deptId) {
        Department dept;
        ArrayList item = new ArrayList();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)deptId) && (dept = (Department)this.departmentManager.get(tenantId, deptId).getData()) != null && dept.getId() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", dept.getId());
            map.put("parentId", dept.getParentId());
            map.put("name", dept.getName());
            map.put("isParent", true);
            map.put("orgType", dept.getOrgType());
            item.add(map);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List orgList = (List)this.orgUnitManager.getSubTree(tenantId, id, OrgTreeTypeEnum.TREE_TYPE_ORG).getData();
            for (OrgUnit orgunit : orgList) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("id", orgunit.getId());
                map.put("parentId", id);
                map.put("name", orgunit.getName());
                map.put("orgType", orgunit.getOrgType());
                if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                    map.put("isParent", true);
                } else {
                    if (!OrgTypeEnum.PERSON.equals((Object)orgunit.getOrgType())) continue;
                    Person person = (Person)this.personManager.get(tenantId, orgunit.getId()).getData();
                    map.put("isParent", false);
                    map.put("sex", person.getSex());
                    map.put("duty", person.getDuty());
                }
                item.add(map);
            }
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrg"})
    public Y9Result<List<Organization>> getOrg() {
        List list = (List)this.organizationManager.list(Y9LoginUserHolder.getTenantId()).getData();
        return Y9Result.success((Object)list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrgChildTree"})
    public Y9Result<List<Map<String, Object>>> getOrgChildTree(@RequestParam(required=false) String id, OrgTreeTypeEnum treeType) {
        ArrayList item = new ArrayList();
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            List orgList = (List)this.orgUnitManager.getSubTree(tenantId, id, treeType).getData();
            for (OrgUnit orgunit : orgList) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("id", orgunit.getId());
                map.put("parentId", id);
                map.put("name", orgunit.getName());
                map.put("orgType", orgunit.getOrgType());
                map.put("guidPath", orgunit.getGuidPath());
                if (OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())) {
                    map.put("isParent", true);
                } else if (OrgTypeEnum.PERSON.equals((Object)orgunit.getOrgType())) {
                    Person person = (Person)this.personManager.get(tenantId, orgunit.getId()).getData();
                    map.put("isParent", false);
                    map.put("sex", person.getSex());
                    map.put("duty", person.getDuty());
                } else {
                    if (!OrgTypeEnum.POSITION.equals((Object)orgunit.getOrgType())) continue;
                    map.put("isParent", false);
                }
                item.add(map);
            }
        }
        return Y9Result.success(item, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getOrgTree"})
    public Y9Result<List<OrgUnit>> getOrgTree(@RequestParam String id, @RequestParam OrgTreeTypeEnum treeType) {
        ArrayList<OrgUnit> newOrgUnitList = new ArrayList<OrgUnit>();
        List orgUnitList = (List)this.orgUnitManager.getSubTree(Y9LoginUserHolder.getTenantId(), id, treeType).getData();
        for (OrgUnit orgUnit : orgUnitList) {
            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) continue;
            orgUnit.setDn("false");
            ReceiveDepartment receiveDepartment = this.receiveDeptAndPersonService.findByDeptId(orgUnit.getId());
            List deptList = (List)this.departmentManager.listRecursivelyByParentId(Y9LoginUserHolder.getTenantId(), orgUnit.getId()).getData();
            orgUnit.setGuidPath("false");
            for (Department dept : deptList) {
                orgUnit.setGuidPath("true");
                ReceiveDepartment receiveDept = this.receiveDeptAndPersonService.findByDeptId(dept.getId());
                if (receiveDept == null) continue;
                orgUnit.setDn("true");
                break;
            }
            orgUnit.setCustomId("false");
            orgUnit.setProperties("false");
            if (receiveDepartment != null) {
                orgUnit.setCustomId("true");
                Integer count = this.receiveDeptAndPersonService.countByDeptId(orgUnit.getId());
                if (count > 0) {
                    orgUnit.setProperties("true");
                }
            }
            newOrgUnitList.add(orgUnit);
        }
        return Y9Result.success(newOrgUnitList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public OrgUnit getParent(String tenantId, String parentId) {
        Organization parent = (Organization)this.organizationManager.get(tenantId, parentId).getData();
        return parent.getId() != null ? parent : (OrgUnit)this.departmentManager.get(tenantId, parentId).getData();
    }

    @RequestMapping(value={"/orderDeptList"})
    public Y9Result<List<ReceiveDepartment>> orderDeptList() {
        List list = this.receiveDepartmentRepository.findAllOrderByTabIndex();
        for (ReceiveDepartment receiveDeptAndPerson : list) {
            Department department = (Department)this.departmentManager.get(Y9LoginUserHolder.getTenantId(), receiveDeptAndPerson.getDeptId()).getData();
            receiveDeptAndPerson.setDeptName(department.getName());
        }
        return Y9Result.success((Object)list);
    }

    @GetMapping(value={"/orgTreeSearch"})
    public Y9Result<List<OrgUnit>> orgTreeSearch(@RequestParam OrgTreeTypeEnum treeType, @RequestParam String name) {
        ArrayList<OrgUnit> newOrgUnitList = new ArrayList<OrgUnit>();
        List orgUnitList = (List)this.orgUnitManager.treeSearch(Y9LoginUserHolder.getTenantId(), name, treeType).getData();
        for (OrgUnit orgUnit : orgUnitList) {
            if (!orgUnit.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) continue;
            orgUnit.setDn("false");
            ReceiveDepartment receiveDepartment = this.receiveDeptAndPersonService.findByDeptId(orgUnit.getId());
            List deptList = (List)this.departmentManager.listRecursivelyByParentId(Y9LoginUserHolder.getTenantId(), orgUnit.getId()).getData();
            orgUnit.setGuidPath("false");
            for (Department dept : deptList) {
                orgUnit.setGuidPath("true");
                ReceiveDepartment receiveDept = this.receiveDeptAndPersonService.findByDeptId(dept.getId());
                if (receiveDept == null) continue;
                orgUnit.setDn("true");
                break;
            }
            orgUnit.setCustomId("false");
            orgUnit.setProperties("false");
            if (receiveDepartment != null) {
                orgUnit.setCustomId("true");
                Integer count = this.receiveDeptAndPersonService.countByDeptId(orgUnit.getId());
                if (count > 0) {
                    orgUnit.setProperties("true");
                }
            }
            newOrgUnitList.add(orgUnit);
        }
        List list = (List)this.organizationManager.list(Y9LoginUserHolder.getTenantId()).getData();
        if (!list.isEmpty()) {
            newOrgUnitList.addAll(list);
        }
        return Y9Result.success(newOrgUnitList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/personList"})
    public Y9Result<List<Map<String, Object>>> personList(@RequestParam String deptId) {
        List<Map<String, Object>> personList = this.receiveDeptAndPersonService.personList(deptId);
        return Y9Result.success(personList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public void recursionUpToOrg(String tenantId, String nodeId, String parentId, List<OrgUnit> orgUnitList, boolean isParent) {
        OrgUnit parent = this.getParent(tenantId, parentId);
        if (isParent) {
            parent.setDescription("parent");
        }
        if (orgUnitList.isEmpty()) {
            orgUnitList.add(parent);
        } else {
            boolean add = true;
            for (OrgUnit orgUnit : orgUnitList) {
                if (!orgUnit.getId().equals(parent.getId())) continue;
                add = false;
                break;
            }
            if (add) {
                orgUnitList.add(parent);
            }
        }
        if (parent.getOrgType().equals((Object)OrgTypeEnum.DEPARTMENT)) {
            if (parent.getId().equals(nodeId)) {
                return;
            }
            this.recursionUpToOrg(tenantId, nodeId, parent.getParentId(), orgUnitList, true);
        }
    }

    @PostMapping(value={"/saveOrCancelDept"})
    public Y9Result<String> saveOrCancelDept(@RequestParam String id, @RequestParam String type) {
        String save = "save";
        if (type.equals(save)) {
            return this.receiveDeptAndPersonService.saveDepartment(id);
        }
        return this.receiveDeptAndPersonService.delDepartment(id);
    }

    @RequestMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(String ids) {
        return this.receiveDeptAndPersonService.saveOrder(ids);
    }

    @PostMapping(value={"/savePerson"})
    public Y9Result<String> savePerson(@RequestParam String deptId, @RequestParam String ids) {
        return this.receiveDeptAndPersonService.savePosition(deptId, ids);
    }

    @GetMapping(value={"/searchOrgTree"})
    public Y9Result<List<OrgUnit>> searchOrgTree(@RequestParam OrgTreeTypeEnum treeType, @RequestParam String name) {
        List orgUnitList = (List)this.orgUnitManager.treeSearch(Y9LoginUserHolder.getTenantId(), name, treeType).getData();
        return Y9Result.success((Object)orgUnitList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/setReceive"})
    public Y9Result<String> setReceive(@RequestParam boolean receive, @RequestParam String ids) {
        return this.receiveDeptAndPersonService.setReceive(receive, ids);
    }

    @PostMapping(value={"/setSend"})
    public Y9Result<String> setSend(@RequestParam boolean send, @RequestParam String ids) {
        return this.receiveDeptAndPersonService.setSend(send, ids);
    }

    @Generated
    public SendReceiveRestController(ReceiveDeptAndPersonService receiveDeptAndPersonService, OrganizationApi organizationManager, OrgUnitApi orgUnitManager, PersonApi personManager, DepartmentApi departmentManager, ReceiveDepartmentRepository receiveDepartmentRepository) {
        this.receiveDeptAndPersonService = receiveDeptAndPersonService;
        this.organizationManager = organizationManager;
        this.orgUnitManager = orgUnitManager;
        this.personManager = personManager;
        this.departmentManager = departmentManager;
        this.receiveDepartmentRepository = receiveDepartmentRepository;
    }
}

