/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import net.risesoft.entity.OrganWordProperty;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.OrganWordPropertyService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/organWordProperty"}, produces={"application/json"})
public class OrganWordPropertyController {
    private final OrganWordPropertyService organWordPropertyService;

    @GetMapping(value={"/getOrganWordProperty"})
    public Y9Result<OrganWordProperty> getOrganWordProperty(String id) {
        OrganWordProperty property = this.organWordPropertyService.findById(id);
        return Y9Result.success((Object)property, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/propertyList"})
    public Y9Result<List<OrganWordProperty>> organWordList(String organWordId) {
        List<OrganWordProperty> propertyList = this.organWordPropertyService.listByOrganWordId(organWordId);
        return Y9Result.success(propertyList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/removeProperty"})
    public Y9Result<String> removePropertyIds(String[] propertyIds) {
        this.organWordPropertyService.removeOrganWordPropertys(propertyIds);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/save"})
    public Y9Result<OrganWordProperty> save(@Valid OrganWordProperty organWordProperty) {
        OrganWordProperty property = this.organWordPropertyService.save(organWordProperty);
        return Y9Result.success((Object)property, (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveOrder"})
    public Y9Result<String> saveOrder(String[] idAndTabIndexs) {
        this.organWordPropertyService.update4Order(idAndTabIndexs);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public OrganWordPropertyController(OrganWordPropertyService organWordPropertyService) {
        this.organWordPropertyService = organWordPropertyService;
    }
}

