/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.controller.vo.NodeTreeVO;
import net.risesoft.entity.DynamicRole;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DynamicRoleService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/dynamicRole"}, produces={"application/json"})
public class DynamicRoleRestController {
    private final DynamicRoleService dynamicRoleService;

    @GetMapping(value={"/dynamicRoleList"})
    public Y9Result<List<DynamicRole>> dynamicRoleList() {
        List<DynamicRole> drList = this.dynamicRoleService.listAll();
        return Y9Result.success(drList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/getDynamicRole"})
    public Y9Result<DynamicRole> getDynamicRole(@RequestParam String id) {
        DynamicRole dynamicRole = this.dynamicRoleService.getById(id);
        return Y9Result.success((Object)dynamicRole, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/list"})
    public Y9Result<List<NodeTreeVO>> list() {
        ArrayList<NodeTreeVO> listMap = new ArrayList<NodeTreeVO>();
        List<DynamicRole> dynamicRoleList = this.dynamicRoleService.listAll();
        for (DynamicRole dynamicRole : dynamicRoleList) {
            NodeTreeVO map = new NodeTreeVO();
            map.setId(dynamicRole.getId());
            map.setName(dynamicRole.getName());
            map.setIsParent(false);
            map.setOrgType("dynamicRole");
            listMap.add(map);
        }
        return Y9Result.success(listMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/remove"})
    public Y9Result<String> remove(@RequestParam String[] dynamicRoleIds) {
        this.dynamicRoleService.removeDynamicRoles(dynamicRoleIds);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Y9Result<String> saveOrUpdate(DynamicRole dynamicRole) {
        this.dynamicRoleService.saveOrUpdate(dynamicRole);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public DynamicRoleRestController(DynamicRoleService dynamicRoleService) {
        this.dynamicRoleService = dynamicRoleService;
    }
}

