/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import net.risesoft.api.itemadmin.SignaturePictureApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.SignaturePicture;
import net.risesoft.model.itemadmin.SignaturePictureModel;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.SignaturePictureService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/signaturePicture"}, produces={"application/json"})
public class SignaturePictureApiImpl
implements SignaturePictureApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SignaturePictureApiImpl.class);
    private final SignaturePictureService signaturePictureService;
    private final PersonApi personManager;

    public Y9Result<Object> deleteById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.signaturePictureService.deleteById(id);
        return Y9Result.success();
    }

    public Y9Result<SignaturePictureModel> findById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SignaturePicture sp = this.signaturePictureService.findById(id);
        SignaturePictureModel spModel = new SignaturePictureModel();
        if (null != sp) {
            Y9BeanUtil.copyProperties((Object)sp, (Object)spModel);
        }
        return Y9Result.success((Object)spModel);
    }

    public Y9Result<SignaturePictureModel> findByUserId(@RequestParam String tenantId, @RequestParam String userId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SignaturePictureModel spModel = new SignaturePictureModel();
        SignaturePicture sp = this.signaturePictureService.findByUserId(userId);
        if (null != sp) {
            Y9BeanUtil.copyProperties((Object)sp, (Object)spModel);
        }
        return Y9Result.success((Object)spModel);
    }

    public Y9Result<SignaturePictureModel> saveOrUpdate(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String spJson) {
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        ObjectMapper om = new ObjectMapper();
        try {
            JsonNode jn = om.readTree(spJson);
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SignaturePictureModel spModel = new SignaturePictureModel();
            SignaturePicture sp = (SignaturePicture)om.readValue(jn.toString(), SignaturePicture.class);
            SignaturePicture signaturePicture = this.signaturePictureService.saveOrUpdate(sp);
            if (null != signaturePicture) {
                Y9BeanUtil.copyProperties((Object)signaturePicture, (Object)spModel);
            }
            return Y9Result.success((Object)spModel);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u7b7e\u540d\u56fe\u7247\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u4fdd\u5b58\u6216\u66f4\u65b0\u7b7e\u540d\u56fe\u7247\u5931\u8d25");
        }
    }

    @Generated
    public SignaturePictureApiImpl(SignaturePictureService signaturePictureService, PersonApi personManager) {
        this.signaturePictureService = signaturePictureService;
        this.personManager = personManager;
    }
}

