/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.net.URLDecoder;
import lombok.Generated;
import net.risesoft.api.itemadmin.ReminderApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.entity.Reminder;
import net.risesoft.enums.ItemBoxTypeEnum;
import net.risesoft.model.itemadmin.ReminderModel;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ReminderService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.exception.Y9BusinessException;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/reminder"}, produces={"application/json"})
public class ReminderApiImpl
implements ReminderApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ReminderApiImpl.class);
    private static final FastDateFormat DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private final ReminderService reminderService;
    private final PositionApi positionApi;
    private final TaskApi taskManager;

    public Y9Result<Object> deleteList(@RequestParam String tenantId, @RequestBody String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.reminderService.deleteList(ids);
        return Y9Result.success();
    }

    public Y9Result<ReminderModel> findById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Reminder reminder = this.reminderService.findById(id);
        if (reminder != null && reminder.getId() != null) {
            ReminderModel model = new ReminderModel();
            model.setId(reminder.getId());
            model.setReminderMakeTyle(reminder.getReminderMakeTyle());
            model.setReminderSendType(reminder.getReminderSendType());
            model.setSenderId(reminder.getSenderId());
            model.setSenderName(reminder.getSenderName());
            model.setTaskId(reminder.getTaskId());
            model.setProcInstId(reminder.getProcInstId());
            model.setMsgContent(reminder.getMsgContent());
            return Y9Result.success((Object)model);
        }
        return Y9Result.failure((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u50ac\u529e\u4fe1\u606f");
    }

    public Y9Page<ReminderModel> findByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.reminderService.pageByProcessInstanceId(processInstanceId, page, rows);
    }

    public Y9Page<ReminderModel> findBySenderIdAndProcessInstanceIdAndActive(@RequestParam String tenantId, @RequestParam String senderId, @RequestParam String processInstanceId, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.reminderService.pageBySenderIdAndProcessInstanceIdAndActive(senderId, processInstanceId, page, rows);
    }

    public Y9Page<ReminderModel> findByTaskId(@RequestParam String tenantId, @RequestParam String taskId, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.reminderService.pageByTaskId(taskId, page, rows);
    }

    public Y9Result<ReminderModel> getReminder(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String taskId, @RequestParam String type) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        taskId = taskId.contains(",") ? taskId.split(",")[0] : taskId;
        Reminder reminder = new Reminder();
        if (ItemBoxTypeEnum.DOING.getValue().equals(type)) {
            reminder = this.reminderService.findByTaskIdAndSenderId(taskId, userId);
        }
        if (ItemBoxTypeEnum.TODO.getValue().equals(type)) {
            reminder = this.reminderService.findByTaskId(taskId);
        }
        if (reminder != null && reminder.getId() != null) {
            ReminderModel model = new ReminderModel();
            model.setId(reminder.getId());
            model.setCreateTime(DATE_TIME_FORMAT.format(reminder.getCreateTime()));
            model.setModifyTime(reminder.getModifyTime() != null ? DATE_TIME_FORMAT.format(reminder.getModifyTime()) : "");
            model.setReminderMakeTyle(reminder.getReminderMakeTyle());
            model.setReminderSendType(reminder.getReminderSendType());
            model.setSenderId(reminder.getSenderId());
            model.setSenderName(reminder.getSenderName());
            model.setTenantId(reminder.getTenantId());
            model.setTaskId(reminder.getTaskId());
            model.setProcInstId(reminder.getProcInstId());
            model.setMsgContent(reminder.getMsgContent());
            return Y9Result.success((Object)model);
        }
        return Y9Result.failure((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u50ac\u529e\u4fe1\u606f");
    }

    public Y9Result<String> saveReminder(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processInstanceId, @RequestBody String[] taskIds, @RequestParam String msgContent) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        try {
            for (String taskId : taskIds) {
                Reminder reminder = new Reminder();
                reminder.setMsgContent(URLDecoder.decode(msgContent, "utf-8"));
                reminder.setProcInstId(processInstanceId);
                reminder.setTaskId(taskId);
                this.reminderService.saveOrUpdate(reminder);
                TaskModel task = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
                if (String.valueOf(task.getPriority()).contains("8")) continue;
                this.taskManager.setPriority(tenantId, taskId, Integer.valueOf(task.getPriority() + 8));
            }
            return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            LOGGER.error("saveReminder error", (Throwable)e);
            throw new Y9BusinessException(500, "\u4fdd\u5b58\u50ac\u529e\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
    }

    public Y9Result<String> sendReminderMessage(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String remType, @RequestParam String procInstId, @RequestParam String processInstanceId, @RequestParam String documentTitle, @RequestParam String taskId, @RequestParam String taskAssigneeId, @RequestParam String msgContent) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        try {
            String err = this.reminderService.handleReminder(URLDecoder.decode(msgContent, "utf-8"), procInstId, 1, remType, taskId, taskAssigneeId, URLDecoder.decode(documentTitle, "utf-8"));
            if ("".equals(err)) {
                return Y9Result.successMsg((String)"\u50ac\u529e\u53d1\u9001\u6210\u529f!");
            }
            String errMsg = "";
            String[] errs = err.split(";");
            if (!"".equals(errs[0])) {
                errs[0] = errs[0].substring(0, errs[0].length() - 1);
                errMsg = errs[0] + "\u77ed\u4fe1\u672a\u53d1\u9001\u6210\u529f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u3002";
            }
            if (!"".equals(errs[1])) {
                errs[1] = errs[1].substring(0, errs[1].length() - 1);
                errMsg = errMsg.isEmpty() ? errs[1] + "\u90ae\u4ef6\u672a\u53d1\u9001\u6210\u529f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u3002" : "," + errs[1] + "\u90ae\u4ef6\u672a\u53d1\u9001\u6210\u529f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u3002";
            }
            return Y9Result.failure((String)errMsg);
        }
        catch (Exception e) {
            LOGGER.error("sendReminderMessage error", (Throwable)e);
            throw new Y9BusinessException(500, "\u53d1\u9001\u50ac\u529e\u4fe1\u606f\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
    }

    public Y9Result<Object> setReadTime(@RequestParam String tenantId, @RequestBody String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.reminderService.setReadTime(ids);
        return Y9Result.successMsg((String)"\u8bbe\u7f6e\u4e3a\u67e5\u770b\u72b6\u6001\u6210\u529f!");
    }

    public Y9Result<String> updateReminder(@RequestParam String tenantId, @RequestParam String id, @RequestParam String msgContent) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        try {
            Reminder reminder = new Reminder();
            reminder.setId(id);
            reminder.setMsgContent(URLDecoder.decode(msgContent, "utf-8"));
            this.reminderService.saveOrUpdate(reminder);
            return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            LOGGER.error("updateReminder error", (Throwable)e);
            throw new Y9BusinessException(500, "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
    }

    @Generated
    public ReminderApiImpl(ReminderService reminderService, PositionApi positionApi, TaskApi taskManager) {
        this.reminderService = reminderService;
        this.positionApi = positionApi;
        this.taskManager = taskManager;
    }
}

