/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.RemindInstanceApi;
import net.risesoft.entity.RemindInstance;
import net.risesoft.model.itemadmin.RemindInstanceModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.RemindInstanceService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/remindInstance"}, produces={"application/json"})
public class RemindInstanceApiImpl
implements RemindInstanceApi {
    private final RemindInstanceService remindInstanceService;

    public Y9Result<List<RemindInstanceModel>> findRemindInstance(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<RemindInstance> list = this.remindInstanceService.listByProcessInstanceId(processInstanceId);
        ArrayList<RemindInstanceModel> newList = new ArrayList<RemindInstanceModel>();
        for (RemindInstance remindInstance : list) {
            RemindInstanceModel remindInstanceModel = new RemindInstanceModel();
            Y9BeanUtil.copyProperties((Object)remindInstance, (Object)remindInstanceModel);
            newList.add(remindInstanceModel);
        }
        return Y9Result.success(newList);
    }

    public Y9Result<List<RemindInstanceModel>> findRemindInstanceByProcessInstanceIdAndArriveTaskKey(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String taskKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<RemindInstance> list = this.remindInstanceService.listByProcessInstanceIdAndArriveTaskKey(processInstanceId, taskKey);
        ArrayList<RemindInstanceModel> newList = new ArrayList<RemindInstanceModel>();
        for (RemindInstance remindInstance : list) {
            RemindInstanceModel remindInstanceModel = new RemindInstanceModel();
            Y9BeanUtil.copyProperties((Object)remindInstance, (Object)remindInstanceModel);
            newList.add(remindInstanceModel);
        }
        return Y9Result.success(newList);
    }

    public Y9Result<List<RemindInstanceModel>> findRemindInstanceByProcessInstanceIdAndCompleteTaskKey(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String taskKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<RemindInstance> list = this.remindInstanceService.listByProcessInstanceIdAndCompleteTaskKey(processInstanceId, taskKey);
        ArrayList<RemindInstanceModel> newList = new ArrayList<RemindInstanceModel>();
        for (RemindInstance remindInstance : list) {
            RemindInstanceModel remindInstanceModel = new RemindInstanceModel();
            Y9BeanUtil.copyProperties((Object)remindInstance, (Object)remindInstanceModel);
            newList.add(remindInstanceModel);
        }
        return Y9Result.success(newList);
    }

    public Y9Result<List<RemindInstanceModel>> findRemindInstanceByProcessInstanceIdAndRemindType(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String remindType) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<RemindInstance> list = this.remindInstanceService.listByProcessInstanceIdAndRemindType(processInstanceId, remindType);
        ArrayList<RemindInstanceModel> newList = new ArrayList<RemindInstanceModel>();
        for (RemindInstance remindInstance : list) {
            RemindInstanceModel remindInstanceModel = new RemindInstanceModel();
            Y9BeanUtil.copyProperties((Object)remindInstance, (Object)remindInstanceModel);
            newList.add(remindInstanceModel);
        }
        return Y9Result.success(newList);
    }

    public Y9Result<List<RemindInstanceModel>> findRemindInstanceByProcessInstanceIdAndTaskId(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<RemindInstance> list = this.remindInstanceService.listByProcessInstanceIdAndTaskId(processInstanceId, taskId);
        ArrayList<RemindInstanceModel> newList = new ArrayList<RemindInstanceModel>();
        for (RemindInstance remindInstance : list) {
            RemindInstanceModel remindInstanceModel = new RemindInstanceModel();
            Y9BeanUtil.copyProperties((Object)remindInstance, (Object)remindInstanceModel);
            newList.add(remindInstanceModel);
        }
        return Y9Result.success(newList);
    }

    public Y9Result<RemindInstanceModel> getRemindInstance(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)userId);
        RemindInstance remindInstance = this.remindInstanceService.getRemindInstance(processInstanceId);
        RemindInstanceModel remindInstanceModel = null;
        if (remindInstance != null) {
            remindInstanceModel = new RemindInstanceModel();
            Y9BeanUtil.copyProperties((Object)remindInstance, (Object)remindInstanceModel);
        }
        return Y9Result.success(remindInstanceModel);
    }

    public Y9Result<String> saveRemindInstance(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processInstanceId, @RequestParam String taskIds, @RequestParam Boolean process, @RequestParam String arriveTaskKey, @RequestParam String completeTaskKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)userId);
        return this.remindInstanceService.saveRemindInstance(processInstanceId, taskIds, process, arriveTaskKey, completeTaskKey);
    }

    @Generated
    public RemindInstanceApiImpl(RemindInstanceService remindInstanceService) {
        this.remindInstanceService = remindInstanceService;
    }
}

