/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.ProcessTrack4PositionApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.entity.ProcessTrack;
import net.risesoft.model.itemadmin.HistoricActivityInstanceModel;
import net.risesoft.model.itemadmin.HistoryProcessModel;
import net.risesoft.model.itemadmin.ProcessTrackModel;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ProcessTrackService;
import net.risesoft.util.ItemAdminModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/processTrack4Position"}, produces={"application/json"})
public class ProcessTrackApiImpl
implements ProcessTrack4PositionApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTrackApiImpl.class);
    private final ProcessTrackService processTrackService;
    private final PositionApi positionManager;

    public Y9Result<Object> deleteById(@RequestParam String tenantId, @RequestParam String id) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.processTrackService.deleteById(id);
        return Y9Result.success();
    }

    public Y9Result<List<ProcessTrackModel>> findByTaskId(@RequestParam String tenantId, @RequestParam String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Object> items = new ArrayList();
        try {
            List<ProcessTrack> list = this.processTrackService.listByTaskId(taskId);
            items = ItemAdminModelConvertUtil.processTrackList2ModelList(list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u81ea\u5b9a\u4e49\u5386\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        return Y9Result.success(items);
    }

    public Y9Result<List<ProcessTrackModel>> findByTaskIdAsc(@RequestParam String tenantId, @RequestParam String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Object> items = new ArrayList();
        try {
            List<ProcessTrack> list = this.processTrackService.listByTaskIdAsc(taskId);
            items = ItemAdminModelConvertUtil.processTrackList2ModelList(list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u81ea\u5b9a\u4e49\u5386\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        return Y9Result.success(items);
    }

    public Y9Result<List<HistoricActivityInstanceModel>> getTaskList(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.processTrackService.getTaskList(processInstanceId);
    }

    public Y9Result<List<HistoryProcessModel>> processTrackList(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        try {
            List<HistoryProcessModel> items = this.processTrackService.listByProcessInstanceId(processInstanceId);
            return Y9Result.success(items);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u7a0b\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u5386\u7a0b\u5217\u8868\u5f02\u5e38 ");
        }
    }

    public Y9Result<List<HistoryProcessModel>> processTrackList4Simple(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        try {
            List<HistoryProcessModel> items = this.processTrackService.listByProcessInstanceId4Simple(processInstanceId);
            return Y9Result.success(items);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u7a0b\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return Y9Result.failure((String)"\u83b7\u53d6\u5386\u7a0b\u5217\u8868\u5f02\u5e38 ");
        }
    }

    public Y9Result<ProcessTrackModel> saveOrUpdate(@RequestParam String tenantId, @RequestBody ProcessTrackModel processTrackModel) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ProcessTrack processTrack = ItemAdminModelConvertUtil.processTrackModel2ProcessTrack(processTrackModel);
        ProcessTrack ptTemp = this.processTrackService.saveOrUpdate(processTrack);
        return Y9Result.success((Object)ItemAdminModelConvertUtil.processTrack2Model(ptTemp));
    }

    @Generated
    public ProcessTrackApiImpl(ProcessTrackService processTrackService, PositionApi positionManager) {
        this.processTrackService = processTrackService;
        this.positionManager = positionManager;
    }
}

