/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.Date;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessInstanceApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.model.itemadmin.ProcessCooperationModel;
import net.risesoft.model.itemadmin.ProcessInstanceDetailsModel;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ProcessInstanceDetailsService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/processInstance"}, produces={"application/json"})
public class ProcessInstanceApiImpl
implements ProcessInstanceApi {
    private final ProcessInstanceDetailsService processInstanceDetailsService;
    private final PositionApi positionApi;

    public Y9Result<Boolean> deleteProcessInstance(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.processInstanceDetailsService.deleteProcessInstance(processInstanceId));
    }

    public Y9Page<ProcessCooperationModel> processInstanceList(@RequestParam String tenantId, @RequestParam String userId, String title, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.processInstanceDetailsService.pageByUserIdAndTitle(userId, title, page, rows);
    }

    public Y9Result<Boolean> saveProcessInstanceDetails(@RequestParam String tenantId, @RequestBody ProcessInstanceDetailsModel model) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.processInstanceDetailsService.save(model));
    }

    public Y9Result<Boolean> updateProcessInstanceDetails(@RequestParam String tenantId, @RequestParam String assigneeId, @RequestParam String processInstanceId, @RequestParam String taskId, @RequestParam String itembox, @RequestParam Date endTime) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionApi.get(tenantId, assigneeId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        return Y9Result.success((Object)this.processInstanceDetailsService.updateProcessInstanceDetails(processInstanceId, taskId, itembox, endTime));
    }

    @Generated
    public ProcessInstanceApiImpl(ProcessInstanceDetailsService processInstanceDetailsService, PositionApi positionApi) {
        this.processInstanceDetailsService = processInstanceDetailsService;
        this.positionApi = positionApi;
    }
}

