/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.Opinion4PositionApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.entity.Opinion;
import net.risesoft.model.itemadmin.ItemOpinionFrameBindModel;
import net.risesoft.model.itemadmin.OpinionHistoryModel;
import net.risesoft.model.itemadmin.OpinionListModel;
import net.risesoft.model.itemadmin.OpinionModel;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.OpinionService;
import net.risesoft.service.config.ItemOpinionFrameBindService;
import net.risesoft.util.ItemAdminModelConvertUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/opinion4Position"}, produces={"application/json"})
public class OpinionApiImpl
implements Opinion4PositionApi {
    private final OpinionService opinionService;
    private final ItemOpinionFrameBindService itemOpinionFrameBindService;
    private final PersonApi personManager;
    private final PositionApi positionManager;

    public Y9Result<Boolean> checkSignOpinion(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Boolean result = this.opinionService.checkSignOpinion(processSerialNumber, taskId);
        return Y9Result.success((Object)result);
    }

    public Y9Result<Integer> countOpinionHistory(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String opinionFrameMark) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int count = this.opinionService.countOpinionHistory(processSerialNumber, opinionFrameMark);
        return Y9Result.success((Object)count);
    }

    public Y9Result<Object> delete(@RequestParam String tenantId, @RequestParam String id) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.opinionService.delete(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    public Y9Result<List<ItemOpinionFrameBindModel>> getBindOpinionFrame(@RequestParam String tenantId, @RequestParam String itemId, String processDefinitionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<ItemOpinionFrameBindModel> list = new ArrayList<ItemOpinionFrameBindModel>();
        List<String> opinionFrameList = this.itemOpinionFrameBindService.getBindOpinionFrame(itemId, processDefinitionId);
        for (String opinionFrame : opinionFrameList) {
            ItemOpinionFrameBindModel model = new ItemOpinionFrameBindModel();
            model.setOpinionFrameMark(opinionFrame);
            list.add(model);
        }
        return Y9Result.success(list);
    }

    public Y9Result<OpinionModel> getById(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Opinion opinion = this.opinionService.getById(id);
        OpinionModel opinionModel = new OpinionModel();
        if (opinion != null) {
            Y9BeanUtil.copyProperties((Object)opinion, (Object)opinionModel);
        }
        return Y9Result.success((Object)opinionModel);
    }

    public Y9Result<List<OpinionHistoryModel>> opinionHistoryList(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String opinionFrameMark) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<OpinionHistoryModel> opinionHistoryModelList = this.opinionService.listOpinionHistory(processSerialNumber, opinionFrameMark);
        return Y9Result.success(opinionHistoryModelList);
    }

    public Y9Result<List<OpinionListModel>> personCommentList(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String processSerialNumber, String taskId, @RequestParam String itembox, @RequestParam String opinionFrameMark, @RequestParam String itemId, String taskDefinitionKey, String activitiUser, String orderByUser) {
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        List<OpinionListModel> opinionList = this.opinionService.listPersonComment(processSerialNumber, taskId, itembox, opinionFrameMark, itemId, taskDefinitionKey, activitiUser, orderByUser);
        return Y9Result.success(opinionList);
    }

    public Y9Result<Object> save(@RequestParam String tenantId, @RequestBody OpinionModel opinionModel) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Opinion opinion = ItemAdminModelConvertUtil.opinionModel2Opinion(opinionModel);
        this.opinionService.save(opinion);
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public Y9Result<OpinionModel> saveOrUpdate(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, @RequestBody OpinionModel opinionModel) throws Exception {
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Opinion opinion = new Opinion();
        Y9BeanUtil.copyProperties((Object)opinionModel, (Object)opinion);
        opinion = this.opinionService.saveOrUpdate(opinion);
        Y9BeanUtil.copyProperties((Object)opinion, (Object)opinionModel);
        return Y9Result.success((Object)opinionModel);
    }

    public Y9Result<Object> updateOpinion(@RequestParam String tenantId, @RequestParam String id, @RequestParam String content) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.opinionService.updateOpinion(id, content);
        return Y9Result.success();
    }

    @Generated
    public OpinionApiImpl(OpinionService opinionService, ItemOpinionFrameBindService itemOpinionFrameBindService, PersonApi personManager, PositionApi positionManager) {
        this.opinionService = opinionService;
        this.itemOpinionFrameBindService = itemOpinionFrameBindService;
        this.personManager = personManager;
        this.positionManager = positionManager;
    }
}

