/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.ItemRole4PositionApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.enums.ItemPrincipalTypeEnum;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.ItemRoleOrgUnitModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.RoleService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/itemRole4Position"}, produces={"application/json"})
public class ItemRoleApiImpl
implements ItemRole4PositionApi {
    private final RoleService roleService;
    private final PositionApi positionManager;
    private final PersonApi personApi;
    private final OrgUnitApi orgUnitManager;
    private final OrganizationApi organizationManager;

    public Y9Result<List<ItemRoleOrgUnitModel>> findCsUser(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, String id, @RequestParam Integer principalType, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listCsUser(id, principalType, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findCsUserBureau(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, @RequestParam Integer principalType) {
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        if (Objects.equals(principalType, ItemPrincipalTypeEnum.DEPT.getValue())) {
            OrgUnit orgunit = (OrgUnit)this.orgUnitManager.getBureau(tenantId, position.getParentId()).getData();
            ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
            model.setId(orgunit.getId());
            model.setName(orgunit.getName());
            model.setOrgType(orgunit.getOrgType().getValue());
            model.setIsParent(Boolean.valueOf(OrgTypeEnum.DEPARTMENT.equals((Object)orgunit.getOrgType())));
            item.add(model);
        }
        return Y9Result.success(item);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findCsUserSearch(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, @RequestParam String name, @RequestParam Integer principalType, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listCsUserSearch(name, principalType, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findPermUser(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey, @RequestParam Integer principalType, String id, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listPermUser(itemId, processDefinitionId, taskDefKey, principalType, id, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findPermUserByName(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, String name, @RequestParam Integer principalType, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefKey, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        List<ItemRoleOrgUnitModel> list = this.roleService.listPermUserByName(name, itemId, processDefinitionId, taskDefKey, principalType, processInstanceId);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> findPermUserSendReceive(@RequestParam String tenantId, @RequestParam String positionId, String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        List<ItemRoleOrgUnitModel> list = this.roleService.listPermUserSendReceive(id);
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemRoleOrgUnitModel>> getOrgTree(@RequestParam String tenantId, @RequestParam String positionId, String id, @RequestParam OrgTreeTypeEnum treeType, String name) {
        List org;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        ArrayList<ItemRoleOrgUnitModel> item = new ArrayList<ItemRoleOrgUnitModel>();
        if (StringUtils.isBlank((CharSequence)id) && (org = (List)this.organizationManager.list(tenantId).getData()) != null && !org.isEmpty()) {
            id = ((Organization)org.get(0)).getId();
        }
        List orgUnitList = StringUtils.isNotBlank((CharSequence)name) ? (List)this.orgUnitManager.treeSearch(tenantId, name, treeType).getData() : (List)this.orgUnitManager.getSubTree(tenantId, id, treeType).getData();
        for (OrgUnit orgUnit : orgUnitList) {
            ItemRoleOrgUnitModel model = new ItemRoleOrgUnitModel();
            model.setId(orgUnit.getId());
            model.setName(orgUnit.getName());
            model.setParentId(orgUnit.getParentId());
            model.setIsParent(Boolean.valueOf(false));
            model.setOrgType(orgUnit.getOrgType().getValue());
            if (OrgTypeEnum.DEPARTMENT.equals((Object)orgUnit.getOrgType())) {
                model.setIsParent(Boolean.valueOf(true));
            } else if (OrgTypeEnum.POSITION.equals((Object)orgUnit.getOrgType())) {
                model.setPerson("6:" + orgUnit.getId());
            }
            item.add(model);
        }
        return Y9Result.success(item);
    }

    @Generated
    public ItemRoleApiImpl(RoleService roleService, PositionApi positionManager, PersonApi personApi, OrgUnitApi orgUnitManager, OrganizationApi organizationManager) {
        this.roleService = roleService;
        this.positionManager = positionManager;
        this.personApi = personApi;
        this.orgUnitManager = orgUnitManager;
        this.organizationManager = organizationManager;
    }
}

