/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.ItemInterfaceApi;
import net.risesoft.entity.InterfaceInfo;
import net.risesoft.entity.ItemInterfaceParamsBind;
import net.risesoft.entity.ItemInterfaceTaskBind;
import net.risesoft.model.itemadmin.InterfaceModel;
import net.risesoft.model.itemadmin.InterfaceParamsModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.InterfaceInfoRepository;
import net.risesoft.repository.jpa.ItemInterfaceParamsBindRepository;
import net.risesoft.repository.jpa.ItemInterfaceTaskBindRepository;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/itemInterface"}, produces={"application/json"})
public class ItemInterfaceApiImpl
implements ItemInterfaceApi {
    private final ItemInterfaceTaskBindRepository itemInterfaceTaskBindRepository;
    private final InterfaceInfoRepository interfaceInfoRepository;
    private final ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository;

    public Y9Result<List<InterfaceModel>> getInterface(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String taskKey, @RequestParam String processDefinitionId, @RequestParam String condition) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.itemInterfaceTaskBindRepository.findByItemIdAndTaskDefKeyAndProcessDefinitionIdAndExecuteConditionContaining(itemId, taskKey, processDefinitionId, condition);
        ArrayList<InterfaceModel> resList = new ArrayList<InterfaceModel>();
        for (ItemInterfaceTaskBind bind : list) {
            InterfaceModel model = new InterfaceModel();
            InterfaceInfo info = this.interfaceInfoRepository.findById((Object)bind.getInterfaceId()).orElse(null);
            if (info == null) continue;
            model.setId(info.getId());
            model.setInterfaceAddress(info.getInterfaceAddress());
            model.setInterfaceName(info.getInterfaceName());
            model.setRequestType(info.getRequestType());
            model.setAsyn(info.getAsyn());
            model.setAbnormalStop(info.getAbnormalStop());
            resList.add(model);
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<List<InterfaceParamsModel>> getInterfaceParams(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String interfaceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.itemInterfaceParamsBindRepository.findByItemIdAndInterfaceIdOrderByCreateTimeDesc(itemId, interfaceId);
        ArrayList<InterfaceParamsModel> resList = new ArrayList<InterfaceParamsModel>();
        for (ItemInterfaceParamsBind bind : list) {
            InterfaceParamsModel model = new InterfaceParamsModel();
            model.setId(bind.getId());
            model.setBindType(bind.getBindType());
            model.setColumnName(bind.getColumnName());
            model.setParameterName(bind.getParameterName());
            model.setParameterType(bind.getParameterType());
            model.setTableName(bind.getTableName());
            resList.add(model);
        }
        return Y9Result.success(resList, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @Generated
    public ItemInterfaceApiImpl(ItemInterfaceTaskBindRepository itemInterfaceTaskBindRepository, InterfaceInfoRepository interfaceInfoRepository, ItemInterfaceParamsBindRepository itemInterfaceParamsBindRepository) {
        this.itemInterfaceTaskBindRepository = itemInterfaceTaskBindRepository;
        this.interfaceInfoRepository = interfaceInfoRepository;
        this.itemInterfaceParamsBindRepository = itemInterfaceParamsBindRepository;
    }
}

