/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.Item4PositionApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.entity.ItemMappingConf;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.model.itemadmin.ItemListModel;
import net.risesoft.model.itemadmin.ItemMappingConfModel;
import net.risesoft.model.itemadmin.ItemModel;
import net.risesoft.model.itemadmin.ItemSystemListModel;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.ItemMappingConfRepository;
import net.risesoft.repository.jpa.SpmApproveItemRepository;
import net.risesoft.service.DocumentService;
import net.risesoft.service.SpmApproveItemService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/item4Position"}, produces={"application/json"})
public class ItemApiImpl
implements Item4PositionApi {
    private final DocumentService documentService;
    private final SpmApproveItemService spmApproveItemService;
    private final SpmApproveItemRepository spmApproveItemRepository;
    private final PositionApi positionManager;
    private final ItemMappingConfRepository itemMappingConfRepository;

    public Y9Result<List<ItemModel>> findAll(@RequestParam String tenantId, @RequestParam String systemName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.spmApproveItemRepository.findAll(systemName);
        ArrayList<ItemModel> itemModelList = new ArrayList<ItemModel>();
        for (SpmApproveItem item : list) {
            ItemModel itemModel = new ItemModel();
            Y9BeanUtil.copyProperties((Object)item, (Object)itemModel);
            itemModelList.add(itemModel);
        }
        return Y9Result.success(itemModelList);
    }

    public Y9Result<ItemModel> findByProcessDefinitionKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ItemModel itemModel = this.spmApproveItemService.findByProcessDefinitionKey(tenantId, processDefinitionKey);
        return Y9Result.success((Object)itemModel);
    }

    public Y9Result<List<ItemModel>> getAllItem(@RequestParam String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.spmApproveItemRepository.findAll();
        ArrayList<ItemModel> itemModelList = new ArrayList<ItemModel>();
        for (SpmApproveItem item : list) {
            ItemModel itemModel = new ItemModel();
            Y9BeanUtil.copyProperties((Object)item, (Object)itemModel);
            itemModelList.add(itemModel);
        }
        return Y9Result.success(itemModelList);
    }

    public Y9Result<List<ItemModel>> getAllItemList(@RequestParam String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<SpmApproveItem> list = this.spmApproveItemService.list();
        ArrayList<ItemModel> itemList = new ArrayList<ItemModel>();
        for (SpmApproveItem item : list) {
            ItemModel itemModel = new ItemModel();
            Y9BeanUtil.copyProperties((Object)item, (Object)itemModel);
            itemList.add(itemModel);
        }
        return Y9Result.success(itemList);
    }

    public Y9Result<ItemModel> getByItemId(@RequestParam String tenantId, @RequestParam String itemId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        SpmApproveItem item = this.spmApproveItemService.findById(itemId);
        ItemModel itemModel = new ItemModel();
        if (item != null) {
            Y9BeanUtil.copyProperties((Object)item, (Object)itemModel);
        }
        return Y9Result.success((Object)itemModel);
    }

    public Y9Result<String> getFirstItem(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        String itemId = this.documentService.getFirstItem();
        return Y9Result.success((Object)itemId);
    }

    public Y9Result<String> getFormIdByItemId(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String processDefinitionKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String formId = this.documentService.getFormIdByItemId(itemId, processDefinitionKey);
        return Y9Result.success((Object)formId);
    }

    public Y9Result<List<ItemListModel>> getItemList(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        List<ItemListModel> list = this.documentService.listItems();
        return Y9Result.success(list);
    }

    public Y9Result<List<ItemMappingConfModel>> getItemMappingConf(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String mappingId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.itemMappingConfRepository.findByItemIdAndMappingIdOrderByCreateTimeDesc(itemId, mappingId);
        ArrayList<ItemMappingConfModel> itemList = new ArrayList<ItemMappingConfModel>();
        for (ItemMappingConf item : list) {
            ItemMappingConfModel itemModel = new ItemMappingConfModel();
            Y9BeanUtil.copyProperties((Object)item, (Object)itemModel);
            itemList.add(itemModel);
        }
        return Y9Result.success(itemList);
    }

    public Y9Result<List<ItemSystemListModel>> getItemSystem(@RequestParam String tenantId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List list = this.spmApproveItemRepository.getItemSystem();
        ArrayList<ItemSystemListModel> itemList = new ArrayList<ItemSystemListModel>();
        for (Map map : list) {
            ItemSystemListModel itemSystemListModel = new ItemSystemListModel();
            itemSystemListModel.setSystemName(map.get("systemName").toString());
            itemSystemListModel.setSysLevel(map.get("sysLevel").toString());
            itemList.add(itemSystemListModel);
        }
        return Y9Result.success(itemList);
    }

    public Y9Result<List<ItemListModel>> getMyItemList(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        List<ItemListModel> list = this.documentService.listMyItems();
        return Y9Result.success(list);
    }

    public Y9Result<Boolean> hasProcessDefinitionByKey(@RequestParam String tenantId, @RequestParam String processDefinitionKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Boolean hasProcessDefinition = this.spmApproveItemService.hasProcessDefinitionByKey(processDefinitionKey);
        return Y9Result.success((Object)hasProcessDefinition);
    }

    @Generated
    public ItemApiImpl(DocumentService documentService, SpmApproveItemService spmApproveItemService, SpmApproveItemRepository spmApproveItemRepository, PositionApi positionManager, ItemMappingConfRepository itemMappingConfRepository) {
        this.documentService = documentService;
        this.spmApproveItemService = spmApproveItemService;
        this.spmApproveItemRepository = spmApproveItemRepository;
        this.positionManager = positionManager;
        this.itemMappingConfRepository = itemMappingConfRepository;
    }
}

