/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.FormDataApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.entity.Y9FormItemBind;
import net.risesoft.model.itemadmin.BindFormModel;
import net.risesoft.model.itemadmin.FieldPermModel;
import net.risesoft.model.itemadmin.FormFieldDefineModel;
import net.risesoft.model.itemadmin.Y9FormFieldModel;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.FormDataService;
import net.risesoft.service.config.Y9FormItemBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/formData"}, produces={"application/json"})
public class FormDataApiImpl
implements FormDataApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDataApiImpl.class);
    private final FormDataService formDataService;
    private final PersonApi personManager;
    private final Y9FormItemBindService y9FormItemBindService;

    public Y9Result<Object> delChildTableRow(@RequestParam String tenantId, @RequestParam String formId, @RequestParam String tableId, @RequestParam String guid) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.formDataService.delChildTableRow(formId, tableId, guid);
    }

    public Y9Result<Object> delPreFormData(@RequestParam String tenantId, @RequestParam String formId, @RequestParam String guid) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.formDataService.delPreFormData(formId, guid);
    }

    public Y9Result<List<BindFormModel>> findFormItemBind(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String processDefinitionId, String taskDefinitionKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        ArrayList<BindFormModel> res_list = new ArrayList<BindFormModel>();
        List<Y9FormItemBind> list = this.y9FormItemBindService.listByItemIdAndProcDefIdAndTaskDefKey(itemId, processDefinitionId, taskDefinitionKey);
        for (Y9FormItemBind item : list) {
            BindFormModel model = new BindFormModel();
            Y9BeanUtil.copyProperties((Object)item, (Object)model);
            res_list.add(model);
        }
        return Y9Result.success(res_list);
    }

    public Y9Result<List<FieldPermModel>> getAllFieldPerm(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String formId, @RequestParam String taskDefKey, @RequestParam String processDefinitionId) {
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        List<FieldPermModel> list = this.formDataService.listAllFieldPerm(formId, taskDefKey, processDefinitionId);
        return Y9Result.success(list);
    }

    public Y9Result<BindFormModel> getBindPreFormByItemId(@RequestParam String tenantId, @RequestParam String itemId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Map<String, Object> map = this.formDataService.getBindPreFormByItemId(itemId);
        BindFormModel bindFormModel = new BindFormModel();
        bindFormModel.setFormId((String)map.get("formId"));
        bindFormModel.setFormName((String)map.get("formName"));
        return Y9Result.success((Object)bindFormModel);
    }

    public Y9Result<List<Map<String, Object>>> getChildTableData(@RequestParam String tenantId, @RequestParam String formId, @RequestParam String tableId, @RequestParam String processSerialNumber) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Map<String, Object>> list = this.formDataService.listChildTableData(formId, tableId, processSerialNumber);
        return Y9Result.success(list);
    }

    public Y9Result<Map<String, Object>> getData(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Map<String, Object> map = this.formDataService.getData(tenantId, itemId, processSerialNumber);
        return Y9Result.success(map);
    }

    public Y9Result<FieldPermModel> getFieldPerm(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String formId, @RequestParam String fieldName, @RequestParam String taskDefKey, @RequestParam String processDefinitionId) {
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPerson((Person)person);
        FieldPermModel model = this.formDataService.getFieldPerm(formId, fieldName, taskDefKey, processDefinitionId);
        return Y9Result.success((Object)model);
    }

    public Y9Result<List<Y9FormFieldModel>> getFormField(@RequestParam String tenantId, @RequestParam String itemId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Y9FormFieldModel> list = this.formDataService.listFormFieldByItemId(itemId);
        return Y9Result.success(list);
    }

    public Y9Result<List<FormFieldDefineModel>> getFormFieldDefine(@RequestParam String tenantId, @RequestParam String formId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<FormFieldDefineModel> list = this.formDataService.listFormFieldDefineByFormId(formId);
        return Y9Result.success(list);
    }

    public Y9Result<String> getFormJson(@RequestParam String tenantId, @RequestParam String formId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        String json = this.formDataService.getFormJson(formId);
        return Y9Result.success((Object)json);
    }

    public Y9Result<Map<String, Object>> getFromData(@RequestParam String tenantId, @RequestParam String formId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Map<String, Object> map = this.formDataService.getFromData(formId, processSerialNumber);
        if (((Boolean)map.get("success")).booleanValue()) {
            return Y9Result.success((Object)((Map)map.get("formData")));
        }
        return Y9Result.failure((String)"\u83b7\u53d6\u5931\u8d25");
    }

    public Y9Result<List<Map<String, Object>>> getPreFormDataByFormId(@RequestParam String tenantId, @RequestParam String formId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<Map<String, Object>> list = this.formDataService.listPreFormDataByFormId(formId);
        return Y9Result.success(list);
    }

    public Y9Result<Object> saveChildTableData(@RequestParam String tenantId, @RequestParam String formId, @RequestParam String tableId, @RequestParam String processSerialNumber, @RequestBody String jsonData) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.formDataService.saveChildTableData(formId, tableId, processSerialNumber, jsonData);
        return Y9Result.success();
    }

    public Y9Result<Object> saveFormData(@RequestParam String tenantId, @RequestParam String formId, @RequestBody String formJsonData) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.formDataService.saveFormData(formJsonData, formId);
        return Y9Result.success();
    }

    public Y9Result<String> savePreFormData(@RequestParam String tenantId, @RequestParam String itemId, @RequestParam String formId, @RequestBody String formJsonData) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        LOGGER.info("***********************savePreFormData   formJsonData****************" + formJsonData);
        String processSerialNumber = this.formDataService.saveAFormData(itemId, formJsonData, formId);
        return Y9Result.success((Object)processSerialNumber);
    }

    @Generated
    public FormDataApiImpl(FormDataService formDataService, PersonApi personManager, Y9FormItemBindService y9FormItemBindService) {
        this.formDataService = formDataService;
        this.personManager = personManager;
        this.y9FormItemBindService = y9FormItemBindService;
    }
}

