/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.Entrust4PositionApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.entity.Entrust;
import net.risesoft.model.itemadmin.EntrustModel;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.EntrustService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/entrust4Position"}, produces={"application/json"})
public class EntrustApiImpl
implements Entrust4PositionApi {
    private final EntrustService entrustService;
    private final PositionApi positionApi;

    public Y9Result<Object> deleteEntrust(@RequestParam String tenantId, @RequestParam String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.entrustService.destroyEntrust(id);
        return Y9Result.success();
    }

    public Y9Result<List<EntrustModel>> getEntrustList(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<EntrustModel> list = this.entrustService.listEntrustByPositionId(positionId);
        return Y9Result.success(list);
    }

    public Y9Result<List<EntrustModel>> getMyEntrustList(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        List<EntrustModel> list = this.entrustService.listMyEntrust(positionId);
        return Y9Result.success(list);
    }

    public Y9Result<Object> saveOrUpdate(@RequestParam String tenantId, @RequestParam String positionId, @RequestBody EntrustModel entrustModel) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionApi.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Entrust entrust = new Entrust();
        Y9BeanUtil.copyProperties((Object)entrustModel, (Object)entrust);
        this.entrustService.saveOrUpdate(entrust);
        return Y9Result.success();
    }

    @Generated
    public EntrustApiImpl(EntrustService entrustService, PositionApi positionApi) {
        this.entrustService = entrustService;
        this.positionApi = positionApi;
    }
}

