/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.Draft4PositionApi;
import net.risesoft.entity.DraftEntity;
import net.risesoft.entity.SpmApproveItem;
import net.risesoft.enums.ItemLeaveTypeEnum;
import net.risesoft.model.itemadmin.DraftModel;
import net.risesoft.model.itemadmin.OpenDataModel;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.repository.jpa.DraftEntityRepository;
import net.risesoft.repository.jpa.SpmApproveItemRepository;
import net.risesoft.service.DraftEntityService;
import net.risesoft.service.FormDataService;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/draft4Position"}, produces={"application/json"})
public class DraftApiImpl
implements Draft4PositionApi {
    private final DraftEntityService draftEntityService;
    private final DraftEntityRepository draftEntityRepository;
    private final SpmApproveItemRepository spmApproveitemRepository;
    private final FormDataService formDataService;

    public Y9Result<Integer> countBySystemName(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String systemName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        int num = this.draftEntityRepository.countByTypeAndCreaterIdAndDelFlagFalse(systemName, positionId);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Object> deleteDraft(@RequestParam String tenantId, @RequestParam(value="ids") String ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.draftEntityService.deleteDraft(ids);
        return Y9Result.success();
    }

    public Y9Result<Integer> getDeleteDraftCount(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int count = 0;
        count = StringUtils.isEmpty((CharSequence)itemId) ? this.draftEntityRepository.countByCreaterIdAndDelFlagTrue(positionId).intValue() : this.draftEntityRepository.countByItemIdAndCreaterIdAndDelFlagTrue(itemId, positionId).intValue();
        return Y9Result.success((Object)count);
    }

    public Y9Result<DraftModel> getDraftByProcessSerialNumber(@RequestParam String tenantId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        DraftEntity draftEntity = this.draftEntityRepository.findByProcessSerialNumber(processSerialNumber);
        DraftModel model = null;
        if (draftEntity != null) {
            model = new DraftModel();
            Y9BeanUtil.copyProperties((Object)draftEntity, (Object)model);
        }
        return Y9Result.success(model);
    }

    public Y9Result<Integer> getDraftCount(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        int count = 0;
        count = StringUtils.isEmpty((CharSequence)itemId) ? this.draftEntityRepository.countByCreaterIdAndDelFlagFalse(positionId).intValue() : this.draftEntityRepository.countByItemIdAndCreaterIdAndDelFlagFalse(itemId, positionId).intValue();
        return Y9Result.success((Object)count);
    }

    public Y9Page<Map<String, Object>> getDraftList(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam int page, @RequestParam int rows, String title, @RequestParam String itemId, boolean delFlag) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        if (StringUtils.isEmpty((CharSequence)title)) {
            title = "";
        }
        Page<DraftEntity> pageList = this.draftEntityService.pageDraftList(itemId, positionId, page, rows, title, delFlag);
        ArrayList draftList = new ArrayList();
        Map<String, Object> formDataMap = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int number = (page - 1) * rows;
        ItemLeaveTypeEnum[] arr = ItemLeaveTypeEnum.values();
        for (DraftEntity draftEntity : pageList) {
            HashMap<String, Object> retMap = new HashMap<String, Object>(16);
            Optional spmApproveitem = this.spmApproveitemRepository.findById((Object)draftEntity.getItemId());
            if (spmApproveitem.isPresent() && ((SpmApproveItem)spmApproveitem.get()).getId() != null) {
                retMap.put("itemName", ((SpmApproveItem)spmApproveitem.get()).getName());
            } else {
                retMap.put("itemName", "");
            }
            retMap.put("serialNumber", number + 1);
            retMap.put("id", draftEntity.getId());
            retMap.put("type", draftEntity.getType());
            retMap.put("creater", draftEntity.getCreater());
            retMap.put("createrId", draftEntity.getCreaterId());
            retMap.put("docNumber", draftEntity.getDocNumber());
            retMap.put("itemId", draftEntity.getItemId());
            retMap.put("processDefinitionKey", draftEntity.getProcessDefinitionKey());
            retMap.put("processInstanceId", draftEntity.getProcessInstanceId());
            retMap.put("processSerialNumber", draftEntity.getProcessSerialNumber());
            retMap.put("title", StringUtils.isEmpty((CharSequence)draftEntity.getTitle()) ? "\u65e0\u6807\u9898" : draftEntity.getTitle());
            retMap.put("urgency", draftEntity.getUrgency());
            retMap.put("draftTime", sdf.format(draftEntity.getDraftTime()));
            formDataMap = this.formDataService.getData(tenantId, itemId, draftEntity.getProcessSerialNumber());
            if (formDataMap.get("leaveType") != null) {
                String leaveType = (String)formDataMap.get("leaveType");
                for (ItemLeaveTypeEnum leaveTypeEnum : arr) {
                    if (!leaveType.equals(leaveTypeEnum.getValue())) continue;
                    formDataMap.put("leaveType", leaveTypeEnum.getName());
                    break;
                }
            }
            retMap.putAll(formDataMap);
            draftList.add(retMap);
            ++number;
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), draftList);
    }

    public Y9Page<DraftModel> getDraftListBySystemName(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam int page, @RequestParam int rows, String title, @RequestParam String systemName, @RequestParam boolean delFlag) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        if (StringUtils.isEmpty((CharSequence)title)) {
            title = "";
        }
        Page<DraftEntity> pageList = this.draftEntityService.pageDraftListBySystemName(systemName, positionId, page, rows, title, delFlag);
        int number = (page - 1) * rows;
        ArrayList<DraftModel> list = new ArrayList<DraftModel>();
        for (DraftEntity draftEntity : pageList) {
            DraftModel model = new DraftModel();
            Y9BeanUtil.copyProperties((Object)draftEntity, (Object)model);
            Optional spmApproveitem = this.spmApproveitemRepository.findById((Object)draftEntity.getItemId());
            if (spmApproveitem.isPresent() && ((SpmApproveItem)spmApproveitem.get()).getId() != null) {
                model.setItemName(((SpmApproveItem)spmApproveitem.get()).getName());
            } else {
                model.setItemName("");
            }
            model.setSerialNumber(Integer.valueOf(number + 1));
            model.setTitle(StringUtils.isEmpty((CharSequence)draftEntity.getTitle()) ? "\u65e0\u6807\u9898" : draftEntity.getTitle());
            list.add(model);
            ++number;
        }
        return Y9Page.success((int)page, (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), list);
    }

    public Y9Result<OpenDataModel> openDraft4Position(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processSerialNumber, @RequestParam boolean mobile) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        OpenDataModel model = null;
        if (StringUtils.isNotBlank((CharSequence)itemId) && StringUtils.isNotBlank((CharSequence)processSerialNumber)) {
            model = this.draftEntityService.openDraft(processSerialNumber, itemId, mobile);
        }
        return Y9Result.success(model);
    }

    public Y9Result<Object> reduction(@RequestParam String tenantId, @RequestParam(value="ids") String ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.draftEntityService.reduction(ids);
        return Y9Result.success();
    }

    public Y9Result<Object> removeDraft(@RequestParam String tenantId, @RequestParam(value="ids") String ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.draftEntityService.removeDraft(ids);
        return Y9Result.success();
    }

    public Y9Result<Object> saveDraft(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processSerialNumber, @RequestParam String processDefinitionKey, String number, String level, @RequestParam String title) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        this.draftEntityService.saveDraft(itemId, processSerialNumber, processDefinitionKey, number, level, title, "");
        return Y9Result.successMsg((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Generated
    public DraftApiImpl(DraftEntityService draftEntityService, DraftEntityRepository draftEntityRepository, SpmApproveItemRepository spmApproveitemRepository, FormDataService formDataService) {
        this.draftEntityService = draftEntityService;
        this.draftEntityRepository = draftEntityRepository;
        this.spmApproveitemRepository = spmApproveitemRepository;
        this.formDataService = formDataService;
    }
}

