/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.Document4PositionApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.processadmin.VariableApi;
import net.risesoft.entity.ProcessParam;
import net.risesoft.model.itemadmin.DocUserChoiseModel;
import net.risesoft.model.itemadmin.OpenDataModel;
import net.risesoft.model.itemadmin.SignTaskConfigModel;
import net.risesoft.model.itemadmin.StartProcessResultModel;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.AsyncUtilService;
import net.risesoft.service.DocumentService;
import net.risesoft.service.ProcessParamService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/document4Position"}, produces={"application/json"})
public class DocumentApiImpl
implements Document4PositionApi {
    private final DocumentService documentService;
    private final PersonApi personManager;
    private final PositionApi positionManager;
    private final VariableApi variableManager;
    private final AsyncUtilService asyncUtilService;
    private final ProcessParamService processParamService;

    public Y9Result<OpenDataModel> add(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam boolean mobile) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        OpenDataModel model = this.documentService.add(itemId, mobile);
        return Y9Result.success((Object)model);
    }

    public Y9Result<Object> complete(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.documentService.complete(taskId);
        return Y9Result.success();
    }

    public Y9Result<DocUserChoiseModel> docUserChoise(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processDefinitionKey, @RequestParam String processDefinitionId, String taskId, @RequestParam String routeToTask, String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        DocUserChoiseModel model = this.documentService.docUserChoise(itemId, processDefinitionKey, processDefinitionId, taskId, routeToTask, processInstanceId);
        return Y9Result.success((Object)model);
    }

    public Y9Result<OpenDataModel> edit(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itembox, @RequestParam(required=false) String taskId, @RequestParam String processInstanceId, @RequestParam String itemId, @RequestParam boolean mobile) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        OpenDataModel model = this.documentService.edit(itembox, taskId, processInstanceId, itemId, mobile);
        return Y9Result.success((Object)model);
    }

    public Y9Result<List<String>> parserUser(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String routeToTaskId, @RequestParam String taskDefName, @RequestParam String processInstanceId, @RequestParam(required=false) String multiInstance) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        return this.documentService.parserUser(itemId, processDefinitionId, routeToTaskId, taskDefName, processInstanceId, multiInstance);
    }

    public Y9Result<String> saveAndForwarding(@RequestParam String tenantId, @RequestParam String positionId, String processInstanceId, String taskId, String sponsorHandle, @RequestParam String itemId, @RequestParam String processSerialNumber, @RequestParam String processDefinitionKey, @RequestParam String userChoice, String sponsorGuid, @RequestParam String routeToTaskId, @RequestBody Map<String, Object> variables) {
        Y9Result<String> y9Result;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        if (StringUtils.isBlank((CharSequence)processInstanceId) || "null".equals(processInstanceId)) {
            y9Result = this.documentService.saveAndForwarding(itemId, processSerialNumber, processDefinitionKey, userChoice, sponsorGuid, routeToTaskId, variables);
        } else {
            this.variableManager.setVariables(tenantId, taskId, variables);
            y9Result = this.documentService.forwarding(taskId, sponsorHandle, userChoice, routeToTaskId, sponsorGuid);
        }
        if (y9Result.isSuccess()) {
            this.asyncUtilService.loopSending(tenantId, positionId, itemId, (String)y9Result.getData());
        }
        return y9Result;
    }

    public Y9Result<String> saveAndForwardingByTaskKey(@RequestParam String tenantId, @RequestParam String positionId, String processInstanceId, String taskId, String sponsorHandle, @RequestParam String itemId, @RequestParam String processSerialNumber, @RequestParam String processDefinitionKey, @RequestParam String userChoice, String sponsorGuid, @RequestParam String routeToTaskId, @RequestParam String startRouteToTaskId, @RequestBody Map<String, Object> variables) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        if (StringUtils.isBlank((CharSequence)processInstanceId) || "null".equals(processInstanceId)) {
            return this.documentService.saveAndForwardingByTaskKey(itemId, processSerialNumber, processDefinitionKey, userChoice, sponsorGuid, routeToTaskId, startRouteToTaskId, variables);
        }
        if (!variables.isEmpty()) {
            this.variableManager.setVariables(tenantId, taskId, variables);
        }
        return this.documentService.forwarding(taskId, sponsorHandle, userChoice, routeToTaskId, sponsorGuid);
    }

    public Y9Result<Object> saveAndSubmitTo(@RequestParam String tenantId, @RequestParam String positionId, String taskId, @RequestParam String itemId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Y9Result<Object> y9Result = StringUtils.isBlank((CharSequence)taskId) || "null".equals(taskId) ? this.documentService.saveAndSubmitTo(itemId, processSerialNumber) : this.documentService.submitTo(processSerialNumber, taskId);
        if (y9Result.isSuccess()) {
            ProcessParam processParam = this.processParamService.findByProcessSerialNumber(processSerialNumber);
            this.asyncUtilService.loopSending(tenantId, positionId, itemId, processParam.getProcessInstanceId());
        }
        return y9Result;
    }

    public Y9Result<SignTaskConfigModel> signTaskConfig(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processDefinitionId, @RequestParam String taskDefinitionKey, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        SignTaskConfigModel model = this.documentService.signTaskConfig(itemId, processDefinitionId, taskDefinitionKey, processSerialNumber);
        return Y9Result.success((Object)model);
    }

    public Y9Result<StartProcessResultModel> startProcess(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processSerialNumber, @RequestParam String processDefinitionKey) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        StartProcessResultModel model = this.documentService.startProcess(itemId, processSerialNumber, processDefinitionKey);
        return Y9Result.success((Object)model);
    }

    public Y9Result<StartProcessResultModel> startProcess(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String itemId, @RequestParam String processSerialNumber, @RequestParam String processDefinitionKey, @RequestParam String positionIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        StartProcessResultModel model = this.documentService.startProcess(itemId, processSerialNumber, processDefinitionKey, positionIds);
        return Y9Result.success((Object)model);
    }

    @Generated
    public DocumentApiImpl(DocumentService documentService, PersonApi personManager, PositionApi positionManager, VariableApi variableManager, AsyncUtilService asyncUtilService, ProcessParamService processParamService) {
        this.documentService = documentService;
        this.personManager = personManager;
        this.positionManager = positionManager;
        this.variableManager = variableManager;
        this.asyncUtilService = asyncUtilService;
        this.processParamService = processParamService;
    }
}

