/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import lombok.Generated;
import net.risesoft.api.itemadmin.position.ChaoSong4PositionApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.model.itemadmin.ChaoSongModel;
import net.risesoft.model.itemadmin.OpenDataModel;
import net.risesoft.model.platform.Person;
import net.risesoft.model.platform.Position;
import net.risesoft.nosql.elastic.entity.ChaoSongInfo;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.ChaoSongInfoService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/chaoSong4Position"}, produces={"application/json"})
public class ChaoSongInfoApiImpl
implements ChaoSong4PositionApi {
    private final ChaoSongInfoService chaoSongInfoService;
    private final PersonApi personManager;
    private final PositionApi positionManager;

    public Y9Result<Object> changeChaoSongState(@RequestParam String tenantId, @RequestParam String id, String type) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongInfoService.changeChaoSongState(id, type);
        return Y9Result.success();
    }

    public Y9Result<Object> changeStatus(@RequestParam String tenantId, @RequestBody String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongInfoService.changeStatus(ids);
        return Y9Result.success();
    }

    public Y9Result<Object> changeStatus2read(@RequestParam String tenantId, @RequestParam String chaoSongId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongInfoService.changeStatus(chaoSongId);
        return Y9Result.success();
    }

    public Y9Result<Integer> countByProcessInstanceId(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongInfoService.countByProcessInstanceId(positionId, processInstanceId);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Integer> countByUserIdAndProcessInstanceId(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongInfoService.countByUserIdAndProcessInstanceId(positionId, processInstanceId);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Object> deleteByIds(@RequestParam String tenantId, @RequestParam @RequestBody String[] ids) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongInfoService.deleteByIds(ids);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteByProcessInstanceId(@RequestParam String tenantId, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongInfoService.deleteByProcessInstanceId(processInstanceId);
        return Y9Result.success();
    }

    public Y9Result<OpenDataModel> detail(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String id, @RequestParam String processInstanceId, @RequestParam Integer status, Boolean openNotRead, @RequestParam boolean mobile) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        OpenDataModel model = this.chaoSongInfoService.detail(processInstanceId, status, mobile);
        model.setId(id);
        model.setStatus(status);
        ChaoSongInfo chaoSong = this.chaoSongInfoService.getById(id);
        if (null != chaoSong && chaoSong.getStatus() != 1 && !Boolean.TRUE.equals(openNotRead)) {
            this.chaoSongInfoService.changeStatus(id);
        }
        return Y9Result.success((Object)model);
    }

    public Y9Result<Integer> getDone4OpinionCountByUserId(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongInfoService.getDone4OpinionCountByUserId(positionId);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Integer> getDoneCount(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongInfoService.getDoneCountByUserId(positionId);
        return Y9Result.success((Object)num);
    }

    public Y9Page<ChaoSongModel> getDoneList(@RequestParam String tenantId, @RequestParam String positionId, String documentTitle, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongInfoService.pageDoneList(positionId, documentTitle, rows, page);
    }

    public Y9Page<ChaoSongModel> getListByProcessInstanceId(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processInstanceId, String userName, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        return this.chaoSongInfoService.pageByProcessInstanceIdAndUserName(processInstanceId, userName, rows, page);
    }

    public Y9Page<ChaoSongModel> getListBySenderIdAndProcessInstanceId(@RequestParam String tenantId, @RequestParam String senderId, @RequestParam String processInstanceId, String userName, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongInfoService.pageBySenderIdAndProcessInstanceId(senderId, processInstanceId, userName, rows, page);
    }

    public Y9Page<ChaoSongModel> getOpinionChaosongByUserId(@RequestParam String tenantId, @RequestParam String positionId, String documentTitle, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongInfoService.pageOpinionChaosongByUserId(positionId, documentTitle, rows, page);
    }

    public Y9Result<Integer> getTodoCount(@RequestParam String tenantId, @RequestParam String positionId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.chaoSongInfoService.getTodoCountByUserId(positionId);
        return Y9Result.success((Object)num);
    }

    public Y9Page<ChaoSongModel> getTodoList(@RequestParam String tenantId, @RequestParam String positionId, String documentTitle, @RequestParam int rows, @RequestParam int page) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongInfoService.pageTodoList(positionId, documentTitle, rows, page);
    }

    public Y9Page<ChaoSongModel> myChaoSongList(@RequestParam String tenantId, @RequestParam String positionId, String searchName, String itemId, String userName, String state, String year, @RequestParam int page, @RequestParam int rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        return this.chaoSongInfoService.pageMyChaoSongList(searchName, itemId, userName, state, year, rows, page);
    }

    public Y9Result<Object> save(@RequestParam String tenantId, @RequestParam String userId, @RequestParam String positionId, @RequestParam String processInstanceId, @RequestParam String users, String isSendSms, String isShuMing, String smsContent, String smsPersonId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        return this.chaoSongInfoService.save(processInstanceId, users, isSendSms, isShuMing, smsContent, smsPersonId);
    }

    public Y9Page<ChaoSongModel> searchAllByUserId(@RequestParam String tenantId, @RequestParam String positionId, String searchName, String itemId, String userName, String state, String year, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setPositionId((String)positionId);
        return this.chaoSongInfoService.searchAllByUserId(searchName, itemId, userName, state, year, page, rows);
    }

    public Y9Page<ChaoSongModel> searchAllList(@RequestParam String tenantId, String searchName, String itemId, String senderName, String userName, String state, String year, @RequestParam Integer page, @RequestParam Integer rows) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return this.chaoSongInfoService.searchAllList(searchName, itemId, senderName, userName, state, year, page, rows);
    }

    public Y9Result<Object> updateTitle(@RequestParam String tenantId, @RequestParam String processInstanceId, @RequestParam String documentTitle) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.chaoSongInfoService.updateTitle(processInstanceId, documentTitle);
        return Y9Result.success();
    }

    @Generated
    public ChaoSongInfoApiImpl(ChaoSongInfoService chaoSongInfoService, PersonApi personManager, PositionApi positionManager) {
        this.chaoSongInfoService = chaoSongInfoService;
        this.personManager = personManager;
        this.positionManager = positionManager;
    }
}

