/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.ButtonOperation4PositionApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.api.processadmin.HistoricTaskApi;
import net.risesoft.api.processadmin.ProcessDefinitionApi;
import net.risesoft.api.processadmin.RuntimeApi;
import net.risesoft.api.processadmin.SpecialOperationApi;
import net.risesoft.api.processadmin.TaskApi;
import net.risesoft.api.processadmin.VariableApi;
import net.risesoft.model.platform.Position;
import net.risesoft.model.processadmin.HistoricTaskInstanceModel;
import net.risesoft.model.processadmin.ProcessInstanceModel;
import net.risesoft.model.processadmin.TaskModel;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DocumentService;
import net.risesoft.service.MultiInstanceService;
import net.risesoft.util.CommonOpt;
import net.risesoft.y9.Y9LoginUserHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/buttonOperation4Position"}, produces={"application/json"})
public class ButtonOperationApiImpl
implements ButtonOperation4PositionApi {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ButtonOperationApiImpl.class);
    private final DocumentService documentService;
    private final MultiInstanceService multiInstanceService;
    private final PositionApi positionManager;
    private final TaskApi taskManager;
    private final VariableApi variableManager;
    private final ProcessDefinitionApi processDefinitionManager;
    private final HistoricTaskApi historicTaskManager;
    private final RuntimeApi runtimeManager;
    private final SpecialOperationApi specialOperationManager;

    public Y9Result<Object> addMultiInstanceExecution(@RequestParam String tenantId, @RequestParam String activityId, @RequestParam String parentExecutionId, @RequestParam String taskId, @RequestParam String elementUser) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.multiInstanceService.addMultiInstanceExecution(activityId, parentExecutionId, taskId, elementUser);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteMultiInstanceExecution(@RequestParam String tenantId, @RequestParam String executionId, @RequestParam String taskId, @RequestParam String elementUser) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.multiInstanceService.deleteMultiInstanceExecution(executionId, taskId, elementUser);
        return Y9Result.success();
    }

    public Y9Result<Object> directSend(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, @RequestParam String routeToTask, @RequestParam String processInstanceId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        ProcessInstanceModel processInstance = (ProcessInstanceModel)this.runtimeManager.getProcessInstance(tenantId, processInstanceId).getData();
        String startUserId = "6:" + processInstance.getStartUserId();
        Y9Result<String> y9Result = this.documentService.forwarding(taskId, "true", startUserId, routeToTask, "");
        if (y9Result.isSuccess()) {
            return Y9Result.success();
        }
        return Y9Result.failure((String)y9Result.getMsg());
    }

    public Y9Result<Object> refuseClaimRollback(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        try {
            this.taskManager.claim(tenantId, positionId, taskId);
            TaskModel currentTask = (TaskModel)this.taskManager.findById(tenantId, taskId).getData();
            ArrayList<String> userAndDeptIdList = new ArrayList<String>();
            HistoricTaskInstanceModel hti = (HistoricTaskInstanceModel)this.historicTaskManager.getThePreviousTask(tenantId, taskId).getData();
            String assignee = hti.getAssignee();
            userAndDeptIdList.add(assignee);
            Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
            String htiMultiInstance = (String)this.processDefinitionManager.getNodeType(tenantId, hti.getProcessDefinitionId(), hti.getTaskDefinitionKey()).getData();
            Map<String, Object> variables = CommonOpt.setVariables(positionId, position.getName(), hti.getTaskDefinitionKey(), userAndDeptIdList, "");
            HashMap<String, String> val = new HashMap<String, String>();
            val.put("val", "refuseClaimRollback");
            this.variableManager.setVariableLocal(tenantId, taskId, "refuseClaimRollback", val);
            this.taskManager.completeWithVariables4Position(tenantId, taskId, positionId, variables);
            if ("parallel".equals(htiMultiInstance)) {
                List taskNextList1 = (List)this.taskManager.findByProcessInstanceId(tenantId, currentTask.getProcessInstanceId()).getData();
                for (TaskModel taskModelNext : taskNextList1) {
                    HashMap<String, String> val1 = new HashMap<String, String>();
                    val1.put("val", assignee.split(":")[0]);
                    this.variableManager.setVariableLocal(tenantId, taskModelNext.getId(), "parallelSponsor", val1);
                }
            }
        }
        catch (Exception e) {
            this.taskManager.unClaim(tenantId, taskId);
            LOGGER.error("\u9000\u56de\u5931\u8d25", (Throwable)e);
            return Y9Result.failure((String)"\u9000\u56de\u5931\u8d25");
        }
        return Y9Result.success();
    }

    public Y9Result<Object> reposition(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, @RequestParam String repositionToTaskId, @RequestParam(value="userChoice") List<String> userChoice, String reason, String sponsorGuid) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.specialOperationManager.reposition4Position(tenantId, positionId, taskId, repositionToTaskId, userChoice, reason, sponsorGuid);
        return Y9Result.success();
    }

    public Y9Result<Object> rollBack(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.specialOperationManager.rollBack4Position(tenantId, positionId, taskId, reason).isSuccess());
    }

    public Y9Result<Object> rollbackToSender(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.specialOperationManager.rollbackToSender4Position(tenantId, positionId, taskId).isSuccess());
    }

    public Y9Result<Object> rollbackToStartor(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.specialOperationManager.rollbackToStartor4Position(tenantId, positionId, taskId, reason).isSuccess());
    }

    public Y9Result<Object> specialComplete(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.specialOperationManager.specialComplete4Position(tenantId, positionId, taskId, reason).isSuccess());
    }

    public Y9Result<Object> takeback(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String taskId, String reason) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        return Y9Result.success((Object)this.specialOperationManager.takeBack4Position(tenantId, positionId, taskId, reason).isSuccess());
    }

    @Generated
    public ButtonOperationApiImpl(DocumentService documentService, MultiInstanceService multiInstanceService, PositionApi positionManager, TaskApi taskManager, VariableApi variableManager, ProcessDefinitionApi processDefinitionManager, HistoricTaskApi historicTaskManager, RuntimeApi runtimeManager, SpecialOperationApi specialOperationManager) {
        this.documentService = documentService;
        this.multiInstanceService = multiInstanceService;
        this.positionManager = positionManager;
        this.taskManager = taskManager;
        this.variableManager = variableManager;
        this.processDefinitionManager = processDefinitionManager;
        this.historicTaskManager = historicTaskManager;
        this.runtimeManager = runtimeManager;
        this.specialOperationManager = specialOperationManager;
    }
}

